/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.jta;

import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.CompositeTransactionManager;
import com.atomikos.icatch.SubTxAwareParticipant;
import com.atomikos.icatch.config.Configuration;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.util.Assert;

public class ResumePreviousTransactionSubTxAwareParticipant
implements SubTxAwareParticipant {
    private static final Logger LOGGER = LoggerFactory.createLogger(ResumePreviousTransactionSubTxAwareParticipant.class);
    private CompositeTransaction previous;

    public ResumePreviousTransactionSubTxAwareParticipant(CompositeTransaction previous) {
        Assert.notNull("Previous transaction is null?", previous);
        this.previous = previous;
    }

    private void resume() {
        CompositeTransactionManager ctm = Configuration.getCompositeTransactionManager();
        if (ctm == null) {
            LOGGER.logWarning("ResumePreviousTransactionSubTxAwareParticipant: no transaction manager found?");
        } else {
            try {
                ctm.resume(this.previous);
            }
            catch (Exception error2) {
                LOGGER.logWarning("ResumePreviousTransactionSubTxAwareParticipant: could not resume previous transaction", error2);
            }
        }
    }

    @Override
    public void committed(CompositeTransaction tx) {
        this.resume();
    }

    @Override
    public void rolledback(CompositeTransaction tx) {
        this.resume();
    }
}

