/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jdbc;

import com.atomikos.datasource.pool.ConnectionFactory;
import com.atomikos.datasource.pool.ConnectionPoolProperties;
import com.atomikos.datasource.pool.CreateConnectionException;
import com.atomikos.datasource.pool.XPooledConnection;
import com.atomikos.jdbc.internal.AbstractDataSourceBean;
import com.atomikos.jdbc.internal.AtomikosNonXAPooledConnection;
import com.atomikos.jdbc.internal.AtomikosSQLException;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.util.ClassLoadingHelper;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;

public class AtomikosNonXADataSourceBean
extends AbstractDataSourceBean {
    private static final Logger LOGGER = LoggerFactory.createLogger(AtomikosNonXADataSourceBean.class);
    private static final long serialVersionUID = 1L;
    private String url;
    private String user;
    private String password;
    private String driverClassName;
    private boolean readOnly;
    private boolean localTransactionMode;
    private boolean ignoreJtaTransactions;

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string2) {
        this.password = string2;
    }

    public void setUser(String string2) {
        this.user = string2;
    }

    public String getUser() {
        return this.user;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String string2) {
        this.driverClassName = string2;
    }

    @Override
    protected void doClose() {
    }

    @Override
    protected ConnectionFactory<Connection> doInit() throws Exception {
        AtomikosNonXAConnectionFactory ret = null;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logInfo(this + ": initializing with [ uniqueResourceName=" + this.getUniqueResourceName() + ", maxPoolSize=" + this.getMaxPoolSize() + ", minPoolSize=" + this.getMinPoolSize() + ", borrowConnectionTimeout=" + this.getBorrowConnectionTimeout() + ", maxIdleTime=" + this.getMaxIdleTime() + ", reapTimeout=" + this.getReapTimeout() + ", maintenanceInterval=" + this.getMaintenanceInterval() + ", testQuery=" + this.getTestQuery() + ", driverClassName=" + this.getDriverClassName() + ", user=" + this.getUser() + ", url=" + this.getUrl() + " loginTimeout=" + this.getLoginTimeout() + ", localTransactionMode=" + this.getLocalTransactionMode() + ", ignoreJtaTransactions=" + this.getIgnoreJtaTransactions() + "]");
        }
        ret = new AtomikosNonXAConnectionFactory(this, this.url, this.driverClassName, this.user, this.password, this.getLoginTimeout(), this.readOnly, this.ignoreJtaTransactions);
        ret.init();
        return ret;
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this + ": getConnection()...");
        }
        this.init();
        Connection connection = super.getConnection();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace(this + ": returning " + connection);
        }
        return connection;
    }

    public void setLocalTransactionMode(boolean value2) {
        this.localTransactionMode = value2;
    }

    @Override
    public boolean getLocalTransactionMode() {
        return this.localTransactionMode;
    }

    @Override
    protected boolean isAssignableFromWrappedVendorClass(Class<?> iface) {
        return false;
    }

    @Override
    protected Object unwrapVendorInstance() {
        throw new UnsupportedOperationException();
    }

    public void setIgnoreJtaTransactions(boolean ignoreJtaTransactions) {
        this.ignoreJtaTransactions = ignoreJtaTransactions;
    }

    @Override
    public boolean getIgnoreJtaTransactions() {
        return this.ignoreJtaTransactions;
    }

    private static class AtomikosNonXAConnectionFactory
    implements ConnectionFactory<Connection> {
        private static final Logger LOGGER = LoggerFactory.createLogger(AtomikosNonXAConnectionFactory.class);
        private final String url;
        private final String driverClassName;
        private final String user;
        private final String password;
        private final ConnectionPoolProperties props;
        private final int loginTimeout;
        private final boolean readOnly;
        private Driver driver;
        private Properties connectionProperties = new Properties();

        private AtomikosNonXAConnectionFactory(ConnectionPoolProperties props, String url, String driverClassName, String user, String password, int loginTimeout, boolean readOnly, boolean ignoreJtaTransactions) {
            this.props = props;
            this.user = user;
            this.password = password;
            this.url = url;
            this.driverClassName = driverClassName;
            this.loginTimeout = loginTimeout;
            this.readOnly = readOnly;
        }

        private void init() throws SQLException {
            try {
                Class driverClass = ClassLoadingHelper.loadClass(this.driverClassName);
                this.driver = (Driver)driverClass.newInstance();
                if (this.user != null) {
                    this.connectionProperties.put("user", this.user);
                }
                if (this.password != null) {
                    this.connectionProperties.put("password", this.password);
                }
            }
            catch (InstantiationException e) {
                AtomikosSQLException.throwAtomikosSQLException("Could not instantiate driver class: " + this.driverClassName);
            }
            catch (IllegalAccessException e) {
                AtomikosSQLException.throwAtomikosSQLException(e.getMessage());
            }
            catch (ClassNotFoundException e) {
                AtomikosSQLException.throwAtomikosSQLException("Driver class not found: '" + this.driverClassName + "' - please make sure the spelling is correct.");
            }
            catch (ClassCastException cce) {
                String msg = "Driver class '" + this.driverClassName + "' does not seem to be a valid JDBC driver - please check the spelling and verify your JDBC vendor's documentation";
                AtomikosSQLException.throwAtomikosSQLException(msg);
            }
            DriverManager.setLoginTimeout(this.loginTimeout);
        }

        private Connection getConnection() throws SQLException {
            Connection ret = null;
            ret = this.driver.connect(this.url, this.connectionProperties);
            return ret;
        }

        @Override
        public XPooledConnection<Connection> createPooledConnection() throws CreateConnectionException {
            Connection c;
            try {
                c = this.getConnection();
            }
            catch (SQLException e) {
                LOGGER.logWarning("NonXAConnectionFactory: failed to create connection: ", e);
                throw new CreateConnectionException("Could not create JDBC connection", e);
            }
            return new AtomikosNonXAPooledConnection(c, this.props, this.readOnly);
        }
    }
}

