/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.recovery;

import com.atomikos.recovery.TxState;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class PendingTransactionRecord {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String COLUMN_SEPARATOR = "|";
    public final String id;
    public final TxState state;
    public final long expires;
    public final String superiorId;
    public final String recoveryDomainName;

    public PendingTransactionRecord(String id, TxState state, long expires, String recoveryDomainName) {
        this(id, state, expires, recoveryDomainName, null);
    }

    public PendingTransactionRecord(String id, TxState state, long expires, String recoveryDomainName, String superiorId) {
        this.id = id;
        this.state = state;
        this.expires = expires;
        this.superiorId = superiorId;
        this.recoveryDomainName = recoveryDomainName;
    }

    public String toRecord() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.id).append(COLUMN_SEPARATOR).append(this.state.name()).append(COLUMN_SEPARATOR).append(this.expires).append(COLUMN_SEPARATOR).append(this.recoveryDomainName).append(COLUMN_SEPARATOR).append(this.superiorId == null ? "" : this.superiorId).append(LINE_SEPARATOR);
        return sb.toString();
    }

    public static PendingTransactionRecord fromRecord(String record) {
        String[] properties = record.split("\\|");
        if (properties.length < 4) {
            throw new IllegalArgumentException("Invalid record value supplied: " + record);
        }
        String id = properties[0];
        TxState state = TxState.valueOf(properties[1]);
        Long expires = Long.valueOf(properties[2]);
        String recoveryDomainName = String.valueOf(properties[3]);
        String superiorId = null;
        if (properties.length > 4) {
            superiorId = properties[4];
        }
        return new PendingTransactionRecord(id, state, expires, recoveryDomainName, superiorId);
    }

    public static Collection<PendingTransactionRecord> findAllDescendants(PendingTransactionRecord entry, Collection<PendingTransactionRecord> collection2) {
        return PendingTransactionRecord.collectLineages(r -> entry.id.equals(r.superiorId), collection2);
    }

    public static void removeAllDescendants(PendingTransactionRecord entry, Collection<PendingTransactionRecord> allCoordinatorLogEntries) {
        Collection<PendingTransactionRecord> descendants = PendingTransactionRecord.findAllDescendants(entry, allCoordinatorLogEntries);
        for (PendingTransactionRecord descendant : descendants) {
            allCoordinatorLogEntries.remove(descendant);
        }
    }

    public static Collection<PendingTransactionRecord> collectLineages(AncestorPredicate predicate, Collection<PendingTransactionRecord> collection2) {
        HashSet<PendingTransactionRecord> results = new HashSet<PendingTransactionRecord>();
        Map<String, PendingTransactionRecord> map2 = PendingTransactionRecord.map(collection2);
        for (PendingTransactionRecord record : collection2) {
            if (!predicate.holdsFor(record)) {
                if (record.superiorId == null) continue;
                HashSet<PendingTransactionRecord> ret = new HashSet<PendingTransactionRecord>();
                PendingTransactionRecord.collectAncestors(ret, record.superiorId, predicate, map2);
                if (ret.isEmpty()) continue;
                ret.add(record);
                results.addAll(ret);
                continue;
            }
            results.add(record);
        }
        return results;
    }

    private static Map<String, PendingTransactionRecord> map(Collection<PendingTransactionRecord> collection2) {
        HashMap<String, PendingTransactionRecord> ret = new HashMap<String, PendingTransactionRecord>();
        for (PendingTransactionRecord record : collection2) {
            ret.put(record.id, record);
        }
        return ret;
    }

    private static void collectAncestors(Collection<PendingTransactionRecord> collector, String superiorId, AncestorPredicate predicate, Map<String, PendingTransactionRecord> map2) {
        PendingTransactionRecord superior = map2.get(superiorId);
        if (superior != null) {
            if (predicate.holdsFor(superior)) {
                collector.add(superior);
            } else if (superior.superiorId != null) {
                PendingTransactionRecord.collectAncestors(collector, superior.superiorId, predicate, map2);
            }
        }
    }

    public PendingTransactionRecord markAsTerminated() {
        return new PendingTransactionRecord(this.id, TxState.TERMINATED, this.expires, this.recoveryDomainName, this.superiorId);
    }

    public PendingTransactionRecord markAsCommitting() {
        return new PendingTransactionRecord(this.id, TxState.COMMITTING, this.expires, this.recoveryDomainName, this.superiorId);
    }

    public String toString() {
        return this.toRecord();
    }

    public boolean isForeignInDomain(String recoveryDomainName) {
        return !this.recoveryDomainName.equals(recoveryDomainName);
    }

    public boolean isRecoveredByDomain(String recoveryDomainName) {
        boolean ret = true;
        if (this.isForeignInDomain(recoveryDomainName) && this.superiorId != null && this.superiorId.startsWith("http")) {
            ret = false;
        }
        return ret;
    }

    public boolean isLocalRoot(String recoveryDomainName) {
        return this.isForeignInDomain(recoveryDomainName) || this.superiorId == null;
    }

    public boolean allowsHeuristicTermination(String recoveryDomainName) {
        boolean ret = false;
        if (this.isForeignInDomain(recoveryDomainName) && this.isRecoveredByDomain(recoveryDomainName) && this.state.equals((Object)TxState.IN_DOUBT)) {
            ret = true;
        }
        return ret;
    }

    public static Collection<String> extractCoordinatorIds(Collection<PendingTransactionRecord> collection2, TxState ... statesToFilterOn) {
        HashSet<String> ret = new HashSet<String>();
        for (PendingTransactionRecord entry : collection2) {
            if (!entry.state.isOneOf(statesToFilterOn)) continue;
            ret.add(entry.id);
        }
        return ret;
    }

    @FunctionalInterface
    public static interface AncestorPredicate {
        public boolean holdsFor(PendingTransactionRecord var1);
    }
}

