/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.shaded.msv_core.scanner.dtd;

import com.ctc.wstx.shaded.msv_core.scanner.dtd.XmlChars;

public class XmlNames {
    private XmlNames() {
    }

    public static boolean isName(String value2) {
        if (value2 == null) {
            return false;
        }
        char c = value2.charAt(0);
        if (!XmlChars.isLetter(c) && c != '_' && c != ':') {
            return false;
        }
        for (int i = 1; i < value2.length(); ++i) {
            if (XmlChars.isNameChar(value2.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isUnqualifiedName(String value2) {
        if (value2 == null || value2.length() == 0) {
            return false;
        }
        char c = value2.charAt(0);
        if (!XmlChars.isLetter(c) && c != '_') {
            return false;
        }
        for (int i = 1; i < value2.length(); ++i) {
            if (XmlChars.isNCNameChar(value2.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isQualifiedName(String value2) {
        if (value2 == null) {
            return false;
        }
        int first = value2.indexOf(58);
        if (first <= 0) {
            return XmlNames.isUnqualifiedName(value2);
        }
        int last = value2.lastIndexOf(58);
        if (last != first) {
            return false;
        }
        return XmlNames.isUnqualifiedName(value2.substring(0, first)) && XmlNames.isUnqualifiedName(value2.substring(first + 1));
    }

    public static boolean isNmtoken(String token) {
        int length = token.length();
        for (int i = 0; i < length; ++i) {
            if (XmlChars.isNameChar(token.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNCNmtoken(String token) {
        return XmlNames.isNmtoken(token) && token.indexOf(58) < 0;
    }
}

