/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.identifier;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.text.StringEscapeUtils;

public final class Utils {
    private static final String UNICODE_REGEX = "\\\\(\\\\*)u\\{([a-fA-F0-9]+)\\}";
    public static final Pattern UNICODE_PATTERN = Pattern.compile("\\\\(\\\\*)u\\{([a-fA-F0-9]+)\\}");
    private static final String CHAR_PREFIX = "&";
    private static final String ESCAPE_PREFIX = "\\";
    private static final Pattern UNESCAPED_SPECIAL_CHAR_SET = Pattern.compile("([$&+,:;=\\?@#\\\\|/'\\ \\[\\}\\]<\\>.\"^*{}~`()%!-])");
    private static final String GENERATED_METHOD_PREFIX = "$gen$";

    private Utils() {
    }

    private static String encodeSpecialCharacters(String identifier) {
        StringBuilder sb = new StringBuilder();
        int index = 0;
        while (index < identifier.length()) {
            String formattedString;
            if (identifier.charAt(index) == '\\' && index + 1 < identifier.length() && (formattedString = Utils.getFormattedStringForQuotedIdentifiers(identifier.charAt(index + 1))) != null) {
                String unicodePoint = CHAR_PREFIX + formattedString;
                sb.append(unicodePoint);
                index += 2;
                continue;
            }
            sb.append(identifier.charAt(index));
            ++index;
        }
        return sb.toString();
    }

    public static String escapeSpecialCharacters(String identifier) {
        return UNESCAPED_SPECIAL_CHAR_SET.matcher(identifier).replaceAll("\\\\$1");
    }

    private static String encodeIdentifier(String identifier) {
        if (identifier.contains(ESCAPE_PREFIX)) {
            identifier = Utils.encodeSpecialCharacters(identifier);
            return Utils.unescapeJava(identifier);
        }
        return identifier;
    }

    public static String unescapeJava(String str) {
        return StringEscapeUtils.unescapeJava(str);
    }

    private static Identifier encodeGeneratedName(String identifier) {
        StringBuilder sb = new StringBuilder();
        boolean isEncoded = false;
        for (int index = 0; index < identifier.length(); ++index) {
            String formattedString = Utils.getFormattedStringForJvmReservedSet(identifier.charAt(index));
            if (formattedString != null) {
                String unicodePoint = CHAR_PREFIX + formattedString;
                sb.append(unicodePoint);
                isEncoded = true;
                continue;
            }
            sb.append(identifier.charAt(index));
        }
        return new Identifier(sb.toString(), isEncoded);
    }

    private static String getFormattedStringForQuotedIdentifiers(char c) {
        if (c == '$') {
            return "0036";
        }
        return Utils.getFormattedStringForJvmReservedSet(c);
    }

    private static String getFormattedStringForJvmReservedSet(char c) {
        return switch (c) {
            case '\\' -> "0092";
            case '.' -> "0046";
            case ':' -> "0058";
            case ';' -> "0059";
            case '[' -> "0091";
            case ']' -> "0093";
            case '/' -> "0047";
            case '<' -> "0060";
            case '>' -> "0062";
            default -> null;
        };
    }

    public static String decodeIdentifier(String encodedIdentifier) {
        if (encodedIdentifier == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int index = 0;
        while (index < encodedIdentifier.length()) {
            if (encodedIdentifier.charAt(index) == '&' && index + 4 < encodedIdentifier.length()) {
                if (Utils.isUnicodePoint(encodedIdentifier, index)) {
                    sb.append((char)Integer.parseInt(encodedIdentifier.substring(index + 1, index + 5)));
                    index += 5;
                    continue;
                }
                sb.append(encodedIdentifier.charAt(index));
                ++index;
                continue;
            }
            sb.append(encodedIdentifier.charAt(index));
            ++index;
        }
        return Utils.decodeGeneratedMethodName(sb.toString());
    }

    private static String decodeGeneratedMethodName(String decodedName) {
        return decodedName.startsWith(GENERATED_METHOD_PREFIX) ? decodedName.substring(GENERATED_METHOD_PREFIX.length()) : decodedName;
    }

    public static String unescapeBallerina(String text) {
        return Utils.unescapeJava(Utils.unescapeUnicodeCodepoints(text));
    }

    public static String unescapeUnicodeCodepoints(String identifier) {
        Matcher matcher = UNICODE_PATTERN.matcher(identifier);
        StringBuilder buffer = new StringBuilder(identifier.length());
        while (matcher.find()) {
            String leadingSlashes = matcher.group(1);
            if (Utils.isEscapedNumericEscape(leadingSlashes)) continue;
            int codePoint = Integer.parseInt(matcher.group(2), 16);
            char[] chars = Character.toChars(codePoint);
            String ch = String.valueOf(chars);
            if (ch.equals(ESCAPE_PREFIX)) {
                matcher.appendReplacement(buffer, Matcher.quoteReplacement(leadingSlashes + "\\u005C"));
                continue;
            }
            matcher.appendReplacement(buffer, Matcher.quoteReplacement(leadingSlashes + ch));
        }
        matcher.appendTail(buffer);
        return String.valueOf(buffer);
    }

    public static boolean isEscapedNumericEscape(String leadingSlashes) {
        return !Utils.isEven(leadingSlashes.length());
    }

    private static boolean isEven(int n) {
        return (n & 1) == 0;
    }

    private static boolean isUnicodePoint(String encodedName, int index) {
        return Utils.containsOnlyDigits(encodedName.substring(index + 1, index + 5));
    }

    private static boolean containsOnlyDigits(String digitString) {
        for (int i = 0; i < digitString.length(); ++i) {
            if (Character.isDigit(digitString.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String encodeFunctionIdentifier(String functionName) {
        switch (functionName = Utils.encodeIdentifier(functionName)) {
            case ".<init>": {
                return "$gen$&0046&0060init&0062";
            }
            case ".<start>": {
                return "$gen$&0046&0060start&0062";
            }
            case ".<stop>": {
                return "$gen$&0046&0060stop&0062";
            }
            case ".<testinit>": {
                return "$gen$&0046&0060testinit&0062";
            }
        }
        Identifier encodedName = Utils.encodeGeneratedName(functionName);
        return encodedName.isEncoded ? GENERATED_METHOD_PREFIX + encodedName.name : functionName;
    }

    public static String encodeNonFunctionIdentifier(String identifierString) {
        identifierString = Utils.encodeIdentifier(identifierString);
        Identifier encodedName = Utils.encodeGeneratedName(identifierString);
        return encodedName.name;
    }

    private static class Identifier {
        boolean isEncoded;
        String name;

        Identifier(String name, boolean isEncoded) {
            this.name = name;
            this.isEncoded = isEncoded;
        }
    }
}

