/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.repository.Repository;
import io.ballerina.runtime.api.types.Parameter;
import io.ballerina.runtime.internal.BalRuntime;
import io.ballerina.runtime.internal.repository.RepositoryImpl;
import io.ballerina.runtime.internal.scheduling.Strand;
import java.util.function.Supplier;

public class BalEnvironment
extends Environment {
    private final Strand strand;
    private final Module currentModule;
    private final String funcName;
    private final Parameter[] funcPathParams;
    private final Repository repository;

    public BalEnvironment(Strand strand, Module currentModule, String funcName, Parameter[] funcPathParams) {
        this.strand = strand;
        this.currentModule = currentModule;
        this.funcName = funcName;
        this.funcPathParams = funcPathParams;
        this.repository = new RepositoryImpl();
    }

    @Override
    public String getFunctionName() {
        return this.funcName;
    }

    @Override
    public Parameter[] getFunctionPathParameters() {
        return this.funcPathParams;
    }

    @Override
    public <T> T yieldAndRun(Supplier<T> supplier) {
        try {
            this.strand.yield();
            T t = supplier.get();
            return t;
        }
        finally {
            this.strand.resume();
        }
    }

    @Override
    public BalRuntime getRuntime() {
        return this.strand.scheduler.runtime;
    }

    @Override
    public Module getCurrentModule() {
        return this.currentModule;
    }

    @Override
    public int getStrandId() {
        return this.strand.getId();
    }

    @Override
    public String getStrandName() {
        return this.strand.name;
    }

    @Override
    public void setStrandLocal(String key, Object value2) {
        this.strand.setProperty(key, value2);
    }

    @Override
    public Object getStrandLocal(String key) {
        return this.strand.getProperty(key);
    }

    @Override
    public Repository getRepository() {
        return this.repository;
    }
}

