/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal;

import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.flags.SymbolFlags;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.FiniteType;
import io.ballerina.runtime.api.types.IntersectionType;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.ReferenceType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.TypeTags;
import io.ballerina.runtime.api.types.UnionType;
import io.ballerina.runtime.api.types.semtype.Builder;
import io.ballerina.runtime.api.types.semtype.Context;
import io.ballerina.runtime.api.types.semtype.Core;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.utils.XmlUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BDecimal;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTable;
import io.ballerina.runtime.api.values.BXml;
import io.ballerina.runtime.internal.TypeChecker;
import io.ballerina.runtime.internal.commons.TypeValuePair;
import io.ballerina.runtime.internal.errors.ErrorCodes;
import io.ballerina.runtime.internal.errors.ErrorHelper;
import io.ballerina.runtime.internal.errors.ErrorReasons;
import io.ballerina.runtime.internal.regexp.RegExpFactory;
import io.ballerina.runtime.internal.types.BArrayType;
import io.ballerina.runtime.internal.types.BByteType;
import io.ballerina.runtime.internal.types.BFiniteType;
import io.ballerina.runtime.internal.types.BIntersectionType;
import io.ballerina.runtime.internal.types.BMapType;
import io.ballerina.runtime.internal.types.BRecordType;
import io.ballerina.runtime.internal.types.BTableType;
import io.ballerina.runtime.internal.types.BTupleType;
import io.ballerina.runtime.internal.types.BTypeReferenceType;
import io.ballerina.runtime.internal.types.BTypedescType;
import io.ballerina.runtime.internal.types.BUnionType;
import io.ballerina.runtime.internal.utils.ErrorUtils;
import io.ballerina.runtime.internal.values.ArrayValue;
import io.ballerina.runtime.internal.values.DecimalValue;
import io.ballerina.runtime.internal.values.MapValueImpl;
import io.ballerina.runtime.internal.values.RegExpValue;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;

public final class TypeConverter {
    private static final String NAN = "NaN";
    private static final String POSITIVE_INFINITY = "Infinity";
    private static final String NEGATIVE_INFINITY = "-Infinity";
    public static final byte MAX_CONVERSION_ERROR_COUNT = 20;
    public static final byte MAX_DISPLAYED_SOURCE_VALUE_LENGTH = 20;
    public static final String ERROR_MESSAGE_UNION_START = "{";
    public static final String ERROR_MESSAGE_UNION_END = "}";
    public static final String ERROR_MESSAGE_UNION_SEPARATOR = "or";

    public static Object convertValues(Type targetType, Object inputValue) {
        Type inputType = TypeChecker.getType(inputValue);
        return switch (targetType.getTag()) {
            case 1, 7, 8, 9, 10, 11, 12 -> TypeConverter.anyToInt(inputValue, () -> ErrorUtils.createNumericConversionError(inputValue, PredefinedTypes.TYPE_INT));
            case 4 -> TypeConverter.anyToDecimal(inputValue, () -> ErrorUtils.createNumericConversionError(inputValue, PredefinedTypes.TYPE_DECIMAL));
            case 3 -> TypeConverter.anyToFloat(inputValue, () -> ErrorUtils.createNumericConversionError(inputValue, PredefinedTypes.TYPE_FLOAT));
            case 5 -> StringUtils.fromString(TypeConverter.anyToString(inputValue));
            case 6 -> TypeConverter.anyToBoolean(inputValue, () -> ErrorUtils.createNumericConversionError(inputValue, PredefinedTypes.TYPE_BOOLEAN));
            case 2 -> TypeConverter.anyToByte(inputValue, () -> ErrorUtils.createNumericConversionError(inputValue, PredefinedTypes.TYPE_BYTE));
            default -> throw ErrorCreator.createError(ErrorReasons.NUMBER_CONVERSION_ERROR, ErrorHelper.getErrorDetails(ErrorCodes.INCOMPATIBLE_SIMPLE_TYPE_CONVERT_OPERATION, inputType, inputValue, targetType));
        };
    }

    private static Object castValueToInt(Context cx, SemType targetType, Object inputValue) {
        assert (Core.isSubType(cx, targetType, Builder.getIntType()));
        if (targetType instanceof BByteType) {
            return TypeConverter.anyToByteCast(inputValue, () -> ErrorUtils.createTypeCastError(inputValue, PredefinedTypes.TYPE_BYTE));
        }
        Predicate<Type> isIntSubType = subType -> Core.isSameType(cx, targetType, SemType.tryInto(cx, subType));
        if (isIntSubType.test(PredefinedTypes.TYPE_INT_SIGNED_32)) {
            return TypeChecker.anyToSigned32(inputValue);
        }
        if (isIntSubType.test(PredefinedTypes.TYPE_INT_SIGNED_16)) {
            return TypeChecker.anyToSigned16(inputValue);
        }
        if (isIntSubType.test(PredefinedTypes.TYPE_INT_SIGNED_8)) {
            return TypeChecker.anyToSigned8(inputValue);
        }
        if (isIntSubType.test(PredefinedTypes.TYPE_INT_UNSIGNED_32)) {
            return TypeChecker.anyToUnsigned32(inputValue);
        }
        if (isIntSubType.test(PredefinedTypes.TYPE_INT_UNSIGNED_16)) {
            return TypeChecker.anyToUnsigned16(inputValue);
        }
        if (isIntSubType.test(PredefinedTypes.TYPE_INT_UNSIGNED_8)) {
            return TypeChecker.anyToUnsigned8(inputValue);
        }
        return TypeConverter.anyToIntCast(inputValue, () -> ErrorUtils.createTypeCastError(inputValue, PredefinedTypes.TYPE_INT));
    }

    public static Object castValues(Type targetType, Object inputValue) {
        Context cx = TypeChecker.context();
        return TypeConverter.castValuesInner(cx, SemType.tryInto(cx, targetType), inputValue, () -> ErrorUtils.createTypeCastError(inputValue, targetType));
    }

    static Object castValuesInner(Context cx, SemType targetType, Object inputValue, Supplier<BError> errorSupplier) {
        if (Core.isSubType(cx, targetType, Builder.getIntType())) {
            return TypeConverter.castValueToInt(cx, targetType, inputValue);
        }
        if (Core.isSubType(cx, targetType, Builder.getDecimalType())) {
            return TypeConverter.anyToDecimalCast(inputValue, () -> ErrorUtils.createTypeCastError(inputValue, PredefinedTypes.TYPE_DECIMAL));
        }
        if (Core.isSubType(cx, targetType, Builder.getFloatType())) {
            return TypeConverter.anyToFloatCast(inputValue, () -> ErrorUtils.createTypeCastError(inputValue, PredefinedTypes.TYPE_FLOAT));
        }
        if (Core.isSubType(cx, targetType, Builder.getStringType())) {
            return TypeConverter.anyToStringCast(inputValue, () -> ErrorUtils.createTypeCastError(inputValue, PredefinedTypes.TYPE_STRING));
        }
        if (Core.isSubType(cx, targetType, Builder.getBooleanType())) {
            return TypeConverter.anyToBooleanCast(inputValue, () -> ErrorUtils.createTypeCastError(inputValue, PredefinedTypes.TYPE_BOOLEAN));
        }
        throw errorSupplier.get();
    }

    static boolean isConvertibleToByte(Object value2) {
        Type inputType = TypeChecker.getType(value2);
        return switch (inputType.getTag()) {
            case 2 -> true;
            case 1 -> TypeChecker.isByteLiteral((Long)value2);
            case 3 -> {
                Double doubleValue = (Double)value2;
                if (TypeConverter.isFloatWithinIntRange(doubleValue) && TypeChecker.isByteLiteral(doubleValue.longValue())) {
                    yield true;
                }
                yield false;
            }
            case 4 -> {
                if (DecimalValue.isDecimalWithinIntRange((DecimalValue)value2) && TypeChecker.isByteLiteral(((DecimalValue)value2).value().longValue())) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    static boolean isConvertibleToInt(Object value2) {
        Type inputType = TypeChecker.getType(value2);
        return switch (inputType.getTag()) {
            case 1, 2 -> true;
            case 3 -> TypeConverter.isFloatWithinIntRange((Double)value2);
            case 4 -> DecimalValue.isDecimalWithinIntRange((DecimalValue)value2);
            default -> false;
        };
    }

    static boolean isConvertibleToIntSubType(Object value2, Type targetType) {
        long val2;
        Type inputType = TypeChecker.getType(value2);
        switch (inputType.getTag()) {
            case 1: 
            case 2: {
                val2 = ((Number)value2).longValue();
                break;
            }
            case 3: {
                if (!TypeConverter.isFloatWithinIntRange((Double)value2)) {
                    return false;
                }
                val2 = TypeConverter.floatToInt((Double)value2);
                break;
            }
            case 4: {
                if (!DecimalValue.isDecimalWithinIntRange((DecimalValue)value2)) {
                    return false;
                }
                val2 = ((DecimalValue)value2).value().intValue();
                break;
            }
            default: {
                return false;
            }
        }
        return TypeConverter.isConvertibleToIntRange(targetType, val2);
    }

    public static boolean isConvertibleToIntRange(Type targetType, long val2) {
        return switch (targetType.getTag()) {
            case 1 -> true;
            case 11 -> TypeChecker.isSigned32LiteralValue(val2);
            case 9 -> TypeChecker.isSigned16LiteralValue(val2);
            case 7 -> TypeChecker.isSigned8LiteralValue(val2);
            case 12 -> TypeChecker.isUnsigned32LiteralValue(val2);
            case 10 -> TypeChecker.isUnsigned16LiteralValue(val2);
            case 8 -> TypeChecker.isUnsigned8LiteralValue(val2);
            default -> false;
        };
    }

    static boolean isConvertibleToChar(Object value2) {
        Type inputType = TypeChecker.getType(value2);
        if (inputType.getTag() == 5) {
            return TypeChecker.isCharLiteralValue(value2);
        }
        return false;
    }

    static boolean isConvertibleToFloatingPointTypes(Object value2) {
        Type inputType = TypeChecker.getType(value2);
        return switch (inputType.getTag()) {
            case 1, 2, 3, 4 -> true;
            default -> false;
        };
    }

    public static Type getConvertibleType(Object inputValue, Type targetType, String varName, Set<TypeValuePair> unresolvedValues, List<String> errors, boolean allowNumericConversion) {
        int targetTypeTag = targetType.getTag();
        switch (targetTypeTag) {
            case 33: {
                return TypeConverter.getConvertibleTypeInTargetUnionType(inputValue, (BUnionType)targetType, varName, errors, unresolvedValues, allowNumericConversion);
            }
            case 32: {
                if (!TypeConverter.isConvertibleToArrayType(inputValue, (BArrayType)targetType, unresolvedValues, varName, errors, allowNumericConversion)) break;
                return targetType;
            }
            case 44: {
                if (!TypeConverter.isConvertibleToTupleType(inputValue, (BTupleType)targetType, unresolvedValues, varName, errors, allowNumericConversion)) break;
                return targetType;
            }
            case 24: {
                if (!TypeConverter.isConvertibleToRecordType(inputValue, (BRecordType)targetType, varName, unresolvedValues, errors, allowNumericConversion)) break;
                return targetType;
            }
            case 27: {
                if (!TypeConverter.isConvertibleToMapType(inputValue, (MapType)targetType, unresolvedValues, varName, errors, allowNumericConversion)) break;
                return targetType;
            }
            case 17: {
                if (!TypeConverter.isConvertibleToTableType(inputValue, (BTableType)targetType, unresolvedValues, varName, errors, allowNumericConversion)) break;
                return targetType;
            }
            case 15: {
                return TypeConverter.getConvertibleTypeForJsonType(inputValue, targetType, allowNumericConversion);
            }
            case 23: {
                return TypeConverter.resolveMatchingTypeForUnion(inputValue, targetType);
            }
            case 34: {
                Type effectiveType = ((BIntersectionType)targetType).getEffectiveType();
                return TypeConverter.getConvertibleType(inputValue, effectiveType, varName, unresolvedValues, errors, allowNumericConversion);
            }
            case 46: {
                return TypeConverter.getConvertibleFiniteType(inputValue, (BFiniteType)targetType, varName, errors, unresolvedValues, allowNumericConversion);
            }
            case 53: {
                Type referredType = ((BTypeReferenceType)targetType).getReferredType();
                Type convertibleType = TypeConverter.getConvertibleType(inputValue, referredType, varName, unresolvedValues, errors, allowNumericConversion);
                return referredType == convertibleType ? targetType : convertibleType;
            }
            case 25: {
                return TypeConverter.getConvertibleType(inputValue, ((BTypedescType)targetType).getConstraint(), varName, unresolvedValues, errors, allowNumericConversion);
            }
            default: {
                if (!TypeChecker.checkIsLikeType(inputValue, targetType, allowNumericConversion) && (!TypeTags.isXMLTypeTag(targetTypeTag) || !TypeConverter.isStringConvertibleToTargetXmlType(inputValue, targetType))) break;
                return targetType;
            }
        }
        return null;
    }

    private static Type getConvertibleTypeForJsonType(Object inputValue, Type targetJsonType, boolean allowNumericConversion) {
        if (!TypeChecker.checkIsLikeType(inputValue, targetJsonType, allowNumericConversion)) {
            return null;
        }
        return TypeConverter.resolveMatchingTypeForUnion(inputValue, targetJsonType);
    }

    private static boolean isStringConvertibleToTargetXmlType(Object inputValue, Type targetType) {
        BXml xmlValue;
        if (TypeChecker.getType(inputValue).getTag() != 5) {
            return false;
        }
        try {
            xmlValue = TypeConverter.stringToXml(((BString)inputValue).getValue());
        }
        catch (BError e) {
            return false;
        }
        return TypeChecker.checkIsLikeType(xmlValue, targetType);
    }

    public static Type getConvertibleTypeInTargetUnionType(Object inputValue, BUnionType targetUnionType, String varName, List<String> errors, Set<TypeValuePair> unresolvedValues, boolean allowNumericConversion) {
        List<Type> memberTypes = targetUnionType.getMemberTypes();
        if (TypeChecker.isStructuredType(TypeChecker.getType(inputValue))) {
            return TypeConverter.getConvertibleStructuredTypeInUnion(inputValue, varName, errors, unresolvedValues, allowNumericConversion, memberTypes);
        }
        for (Type memType : memberTypes) {
            if (!TypeChecker.checkIsLikeType(inputValue, memType, false)) continue;
            return TypeConverter.getConvertibleType(inputValue, memType, varName, unresolvedValues, errors, false);
        }
        for (Type memType : memberTypes) {
            Type convertibleTypeInUnion = TypeConverter.getConvertibleType(inputValue, memType, varName, unresolvedValues, errors, allowNumericConversion);
            if (convertibleTypeInUnion == null) continue;
            return convertibleTypeInUnion;
        }
        return null;
    }

    private static Type getConvertibleStructuredTypeInUnion(Object inputValue, String varName, List<String> errors, Set<TypeValuePair> unresolvedValues, boolean allowNumericConversion, List<Type> memberTypes) {
        int initialErrorListSize;
        errors.add(ERROR_MESSAGE_UNION_START);
        int currentErrorListSize = initialErrorListSize = errors.size();
        for (Type memType : memberTypes) {
            int initialErrorCount = errors.size();
            Type convertibleTypeInUnion = TypeConverter.getConvertibleType(inputValue, memType, varName, unresolvedValues, errors, allowNumericConversion);
            currentErrorListSize = errors.size();
            if (convertibleTypeInUnion != null) {
                errors.subList(initialErrorListSize - 1, currentErrorListSize).clear();
                return convertibleTypeInUnion;
            }
            if (initialErrorCount == currentErrorListSize) continue;
            errors.add(ERROR_MESSAGE_UNION_SEPARATOR);
        }
        errors.remove(errors.size() - 1);
        if (initialErrorListSize != currentErrorListSize) {
            errors.add(ERROR_MESSAGE_UNION_END);
        }
        return null;
    }

    public static Type getConvertibleFiniteType(Object inputValue, BFiniteType targetFiniteType, String varName, List<String> errors, Set<TypeValuePair> unresolvedValues, boolean allowNumericConversion) {
        Type valueType;
        Context cx = TypeChecker.context();
        if (targetFiniteType.valueSpace.size() == 1 && !TypeChecker.belongToSingleBasicTypeOrString(cx, valueType = TypeChecker.getType(targetFiniteType.valueSpace.iterator().next())) && valueType.getTag() != 14) {
            return TypeConverter.getConvertibleType(inputValue, valueType, varName, unresolvedValues, errors, allowNumericConversion);
        }
        Type inputValueType = TypeChecker.getType(inputValue);
        Set<Object> finiteTypeValueSpace = targetFiniteType.valueSpace;
        for (Object valueSpaceItem : finiteTypeValueSpace) {
            if (inputValue == valueSpaceItem) {
                return inputValueType;
            }
            if (!TypeChecker.isFiniteTypeValue(inputValue, inputValueType, valueSpaceItem, false)) continue;
            return TypeChecker.getType(valueSpaceItem);
        }
        if (!allowNumericConversion) {
            return null;
        }
        for (Object valueSpaceItem : finiteTypeValueSpace) {
            if (!TypeChecker.isFiniteTypeValue(inputValue, inputValueType, valueSpaceItem, true)) continue;
            return TypeChecker.getType(valueSpaceItem);
        }
        return null;
    }

    private static boolean isConvertibleToRecordType(Object sourceValue, BRecordType targetType, String varName, Set<TypeValuePair> unresolvedValues, List<String> errors, boolean allowNumericConversion) {
        String fieldNameLong;
        String fieldName;
        if (!(sourceValue instanceof MapValueImpl)) {
            return false;
        }
        MapValueImpl sourceMapValueImpl = (MapValueImpl)sourceValue;
        TypeValuePair typeValuePair = new TypeValuePair(sourceValue, targetType);
        if (unresolvedValues.contains(typeValuePair)) {
            return true;
        }
        unresolvedValues.add(typeValuePair);
        HashMap<String, Type> targetFieldTypes = new HashMap<String, Type>();
        Type restFieldType = targetType.restFieldType;
        boolean returnVal = true;
        for (Map.Entry<String, Field> entry : targetType.getFields().entrySet()) {
            targetFieldTypes.put(entry.getKey(), entry.getValue().getFieldType());
        }
        for (Map.Entry<String, Field> entry : targetFieldTypes.entrySet()) {
            Field targetField;
            fieldName = entry.getKey().toString();
            fieldNameLong = TypeConverter.getLongFieldName(varName, fieldName);
            if (sourceMapValueImpl.containsKey(StringUtils.fromString(fieldName)) || !SymbolFlags.isFlagOn((targetField = targetType.getFields().get(fieldName)).getFlags(), 256L)) continue;
            TypeConverter.addErrorMessage(0, errors, "missing required field '" + fieldNameLong + "' of type '" + targetField.getFieldType().toString() + "' in record '" + String.valueOf(targetType) + "'");
            if (errors.size() >= 21) {
                return false;
            }
            returnVal = false;
        }
        for (Map.Entry<String, Field> entry : sourceMapValueImpl.entrySet()) {
            fieldName = entry.getKey().toString();
            fieldNameLong = TypeConverter.getLongFieldName(varName, fieldName);
            int initialErrorCount = errors.size();
            if (targetFieldTypes.containsKey(fieldName)) {
                if (TypeConverter.getConvertibleType(entry.getValue(), (Type)targetFieldTypes.get(fieldName), fieldNameLong, unresolvedValues, errors, allowNumericConversion) == null) {
                    TypeConverter.addErrorMessage(errors.size() - initialErrorCount, errors, "field '" + fieldNameLong + "' in record '" + String.valueOf(targetType) + "' should be of type '" + String.valueOf(targetFieldTypes.get(fieldName)) + "', found '" + TypeConverter.getShortSourceValue(entry.getValue()) + "'");
                    returnVal = false;
                }
            } else if (!targetType.sealed) {
                if (TypeConverter.getConvertibleType(entry.getValue(), restFieldType, fieldNameLong, unresolvedValues, errors, allowNumericConversion) == null) {
                    TypeConverter.addErrorMessage(errors.size() - initialErrorCount, errors, "value of field '" + String.valueOf(entry.getKey()) + "' adding to the record '" + String.valueOf(targetType) + "' should be of type '" + String.valueOf(restFieldType) + "', found '" + TypeConverter.getShortSourceValue(entry.getValue()) + "'");
                    returnVal = false;
                }
            } else {
                TypeConverter.addErrorMessage(0, errors, "field '" + fieldNameLong + "' cannot be added to the closed record '" + String.valueOf(targetType) + "'");
                returnVal = false;
            }
            if (returnVal || errors.size() < 21) continue;
            unresolvedValues.remove(typeValuePair);
            return false;
        }
        if (!returnVal) {
            unresolvedValues.remove(typeValuePair);
        }
        return returnVal;
    }

    static String getShortSourceValue(Object sourceValue) {
        if (sourceValue == null) {
            return "()";
        }
        Object sourceValueName = sourceValue.toString();
        if (TypeChecker.checkIsType(sourceValue, (Type)PredefinedTypes.TYPE_STRING)) {
            sourceValueName = "\"" + (String)sourceValueName + "\"";
        }
        if (((String)sourceValueName).length() > 20) {
            sourceValueName = ((String)sourceValueName).substring(0, 20).concat("...");
        }
        return sourceValueName;
    }

    static String getLongFieldName(String varName, String fieldName) {
        if (varName == null) {
            return fieldName;
        }
        return varName + "." + fieldName;
    }

    private static void addErrorMessage(int errorCountDifference, List<String> errors, String errorMessage) {
        if (errors.size() <= 20 && errorCountDifference == 0) {
            errors.add(errorMessage);
        }
    }

    private static boolean isConvertibleToTableType(Object sourceValue, BTableType tableType, Set<TypeValuePair> unresolvedValues, String varName, List<String> errors, boolean allowNumericConversion) {
        boolean returnVal = true;
        Type constrainedType = tableType.getConstrainedType();
        int sourceTypeReferredTypeTag = TypeUtils.getImpliedType(TypeChecker.getType(sourceValue)).getTag();
        switch (sourceTypeReferredTypeTag) {
            case 17: {
                Collection bTableValues = ((BTable)sourceValue).values();
                Iterator bTableIterator = bTableValues.iterator();
                for (int i = 0; i < bTableValues.size(); ++i) {
                    int initialErrorCount = errors.size();
                    String elementIndex = TypeConverter.getElementIndex(varName, i);
                    Object bTableValue = bTableIterator.next();
                    Type convertibleType = TypeConverter.getConvertibleType(bTableValue, constrainedType, elementIndex, unresolvedValues, errors, allowNumericConversion);
                    if (convertibleType != null) continue;
                    TypeConverter.addErrorMessage(errors.size() - initialErrorCount, errors, "table element '" + elementIndex + "' should be of type '" + String.valueOf(constrainedType) + "', found '" + TypeConverter.getShortSourceValue(bTableValue) + "'");
                    if (errors.size() >= 21) {
                        return false;
                    }
                    returnVal = false;
                }
                return returnVal;
            }
            case 32: 
            case 44: {
                BArray array2 = (BArray)sourceValue;
                for (int i = 0; i < array2.size(); ++i) {
                    int initialErrorCount = errors.size();
                    String elementIndex = TypeConverter.getElementIndex(varName, i);
                    Type convertibleType = TypeConverter.getConvertibleType(array2.get(i), constrainedType, elementIndex, unresolvedValues, errors, allowNumericConversion);
                    if (convertibleType != null) continue;
                    TypeConverter.addErrorMessage(errors.size() - initialErrorCount, errors, "list element '" + elementIndex + "' should be of type '" + String.valueOf(constrainedType) + "', found '" + TypeConverter.getShortSourceValue(array2.get(i)) + "'");
                    if (errors.size() >= 21) {
                        return false;
                    }
                    returnVal = false;
                }
                return returnVal;
            }
        }
        return false;
    }

    private static boolean isConvertibleToMapType(Object sourceValue, MapType targetType, Set<TypeValuePair> unresolvedValues, String varName, List<String> errors, boolean allowNumericConversion) {
        if (!(sourceValue instanceof MapValueImpl)) {
            return false;
        }
        boolean returnVal = true;
        for (Map.Entry valueEntry : ((MapValueImpl)sourceValue).entrySet()) {
            String fieldNameLong = TypeConverter.getLongFieldName(varName, valueEntry.getKey().toString());
            int initialErrorCount = errors.size();
            if (TypeConverter.getConvertibleType(valueEntry.getValue(), targetType.getConstrainedType(), fieldNameLong, unresolvedValues, errors, allowNumericConversion) != null) continue;
            TypeConverter.addErrorMessage(errors.size() - initialErrorCount, errors, "map field '" + fieldNameLong + "' should be of type '" + String.valueOf(targetType.getConstrainedType()) + "', found '" + TypeConverter.getShortSourceValue(valueEntry.getValue()) + "'");
            if (errors.size() >= 21) {
                return false;
            }
            returnVal = false;
        }
        return returnVal;
    }

    private static boolean isConvertibleToArrayType(Object sourceValue, BArrayType targetType, Set<TypeValuePair> unresolvedValues, String varName, List<String> errors, boolean allowNumericConversion) {
        Type sourceElementType;
        if (!(sourceValue instanceof ArrayValue)) {
            return false;
        }
        ArrayValue source = (ArrayValue)sourceValue;
        int targetSize = targetType.getSize();
        long sourceSize = source.getLength();
        if (targetType.getState() == ArrayType.ArrayState.CLOSED && (long)targetSize < sourceSize) {
            TypeConverter.addErrorMessage(0, errors, "element count exceeds the target array size '" + targetSize + "'");
            return false;
        }
        Type targetTypeElementType = TypeUtils.getImpliedType(targetType.getElementType());
        Type sourceType = source.getType();
        if (sourceType.getTag() == 32 && TypeChecker.isNumericType(sourceElementType = TypeUtils.getImpliedType(((BArrayType)sourceType).getElementType())) && TypeChecker.isNumericType(targetTypeElementType)) {
            return true;
        }
        if (!TypeChecker.hasFillerValue(targetType) && sourceSize < (long)targetSize) {
            TypeConverter.addErrorMessage(0, errors, "array cannot be expanded to size '" + targetSize + "' because, the target type '" + String.valueOf(targetType) + "' does not have a filler value");
            return false;
        }
        boolean returnVal = true;
        for (int i = 0; i < source.size(); ++i) {
            int initialErrorCount = errors.size();
            String elementIndex = TypeConverter.getElementIndex(varName, i);
            Type convertibleType = TypeConverter.getConvertibleType(source.get(i), targetTypeElementType, elementIndex, unresolvedValues, errors, allowNumericConversion);
            if (convertibleType != null) continue;
            TypeConverter.addErrorMessage(errors.size() - initialErrorCount, errors, "array element '" + elementIndex + "' should be of type '" + String.valueOf(targetTypeElementType) + "', found '" + TypeConverter.getShortSourceValue(source.get(i)) + "'");
            if (errors.size() >= 21) {
                return false;
            }
            returnVal = false;
        }
        return returnVal;
    }

    private static boolean isConvertibleToTupleType(Object sourceValue, BTupleType targetType, Set<TypeValuePair> unresolvedValues, String varName, List<String> errors, boolean allowNumericConversion) {
        Type convertibleType;
        String elementIndex;
        int initialErrorCount;
        int i;
        if (!(sourceValue instanceof ArrayValue)) {
            return false;
        }
        ArrayValue source = (ArrayValue)sourceValue;
        List<Type> targetTypes = targetType.getTupleTypes();
        int sourceTypeSize = source.size();
        int targetTypeSize = targetTypes.size();
        Type targetRestType = targetType.getRestType();
        if (sourceTypeSize < targetTypeSize || targetRestType == null && sourceTypeSize > targetTypeSize) {
            return false;
        }
        boolean returnVal = true;
        for (i = 0; i < targetTypeSize; ++i) {
            initialErrorCount = errors.size();
            elementIndex = TypeConverter.getElementIndex(varName, i);
            convertibleType = TypeConverter.getConvertibleType(source.getRefValue(i), targetTypes.get(i), elementIndex, unresolvedValues, errors, allowNumericConversion);
            if (convertibleType != null) continue;
            TypeConverter.addErrorMessage(errors.size() - initialErrorCount, errors, "tuple element '" + elementIndex + "' should be of type '" + targetTypes.get(i).toString() + "', found '" + TypeConverter.getShortSourceValue(source.getRefValue(i)) + "'");
            if (errors.size() >= 21) {
                return false;
            }
            returnVal = false;
        }
        for (i = targetTypeSize; i < sourceTypeSize; ++i) {
            initialErrorCount = errors.size();
            elementIndex = TypeConverter.getElementIndex(varName, i);
            convertibleType = TypeConverter.getConvertibleType(source.getRefValue(i), targetRestType, elementIndex, unresolvedValues, errors, allowNumericConversion);
            if (convertibleType != null) continue;
            TypeConverter.addErrorMessage(errors.size() - initialErrorCount, errors, "tuple element '" + elementIndex + "' should be of type '" + String.valueOf(targetRestType) + "', found '" + TypeConverter.getShortSourceValue(source.getRefValue(i)) + "'");
            if (errors.size() >= 21) {
                return false;
            }
            returnVal = false;
        }
        return returnVal;
    }

    private static String getElementIndex(String varName, int index) {
        if (varName == null) {
            return "[" + index + "]";
        }
        return varName + "[" + index + "]";
    }

    static long anyToInt(Object sourceVal, Supplier<BError> errorFunc) {
        long l;
        Object object = sourceVal;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Long.class, Double.class, Integer.class, Boolean.class, DecimalValue.class, String.class}, (Object)object2, n)) {
            case 0: {
                long l2;
                Long l3 = (Long)object2;
                l = l2 = l3.longValue();
                break;
            }
            case 1: {
                long l4;
                Double d = (Double)object2;
                l = l4 = TypeConverter.floatToInt(d);
                break;
            }
            case 2: {
                long l5;
                Integer i = (Integer)object2;
                l = l5 = i.longValue();
                break;
            }
            case 3: {
                long l6;
                Boolean b = (Boolean)object2;
                l = l6 = b != false ? 1L : 0L;
                break;
            }
            case 4: {
                long l7;
                DecimalValue decimalValue = (DecimalValue)object2;
                l = l7 = decimalValue.intValue();
                break;
            }
            case 5: {
                String s = (String)object2;
                try {
                    long l8;
                    l = l8 = Long.parseLong(s);
                    break;
                }
                catch (NumberFormatException e) {
                    throw errorFunc.get();
                }
            }
            default: {
                throw errorFunc.get();
            }
        }
        return l;
    }

    static long anyToIntCast(Object sourceVal, Supplier<BError> errorFunc) {
        Object object = sourceVal;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Long.class, Double.class, Integer.class, DecimalValue.class}, (Object)object, n)) {
            case 0 -> {
                Long l = (Long)object;
                yield l;
            }
            case 1 -> {
                Double d = (Double)object;
                yield TypeConverter.floatToInt(d);
            }
            case 2 -> {
                Integer i = (Integer)object;
                yield i.longValue();
            }
            case 3 -> {
                DecimalValue decimalValue = (DecimalValue)object;
                yield decimalValue.intValue();
            }
            default -> throw errorFunc.get();
        };
    }

    static long anyToIntSubTypeCast(Object sourceVal, Type type, Supplier<BError> errorFunc) {
        long value2 = TypeConverter.anyToIntCast(sourceVal, errorFunc);
        if (type == PredefinedTypes.TYPE_INT_SIGNED_32 && TypeChecker.isSigned32LiteralValue(value2)) {
            return value2;
        }
        if (type == PredefinedTypes.TYPE_INT_SIGNED_16 && TypeChecker.isSigned16LiteralValue(value2) || type == PredefinedTypes.TYPE_INT_SIGNED_8 && TypeChecker.isSigned8LiteralValue(value2) || type == PredefinedTypes.TYPE_INT_UNSIGNED_32 && TypeChecker.isUnsigned32LiteralValue(value2) || type == PredefinedTypes.TYPE_INT_UNSIGNED_16 && TypeChecker.isUnsigned16LiteralValue(value2) || type == PredefinedTypes.TYPE_INT_UNSIGNED_8 && TypeChecker.isUnsigned8LiteralValue(value2)) {
            return value2;
        }
        throw errorFunc.get();
    }

    static double anyToFloat(Object sourceVal, Supplier<BError> errorFunc) {
        double d;
        Object object = sourceVal;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Long.class, Double.class, Integer.class, Boolean.class, DecimalValue.class, String.class}, (Object)object, n)) {
            case 0: {
                double d2;
                Long l = (Long)object;
                d = d2 = l.doubleValue();
                break;
            }
            case 1: {
                double d3;
                Double d4 = (Double)object;
                d = d3 = d4.doubleValue();
                break;
            }
            case 2: {
                double d5;
                Integer i = (Integer)object;
                d = d5 = (double)i.floatValue();
                break;
            }
            case 3: {
                double d6;
                Boolean b = (Boolean)object;
                d = d6 = b != false ? 1.0 : 0.0;
                break;
            }
            case 4: {
                double d7;
                DecimalValue decimalValue = (DecimalValue)object;
                d = d7 = decimalValue.floatValue();
                break;
            }
            case 5: {
                String s = (String)object;
                try {
                    double d8;
                    d = d8 = Double.parseDouble(s);
                    break;
                }
                catch (NumberFormatException e) {
                    throw errorFunc.get();
                }
            }
            default: {
                throw errorFunc.get();
            }
        }
        return d;
    }

    static double anyToFloatCast(Object sourceVal, Supplier<BError> errorFunc) {
        Object object = sourceVal;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Long.class, Double.class, Integer.class, DecimalValue.class}, (Object)object, n)) {
            case 0 -> {
                Long l = (Long)object;
                yield l.doubleValue();
            }
            case 1 -> {
                Double d = (Double)object;
                yield d;
            }
            case 2 -> {
                Integer i = (Integer)object;
                yield i.floatValue();
            }
            case 3 -> {
                DecimalValue decimalValue = (DecimalValue)object;
                yield decimalValue.floatValue();
            }
            default -> throw errorFunc.get();
        };
    }

    static boolean anyToBoolean(Object sourceVal, Supplier<BError> errorFunc) {
        boolean bl;
        Object object = sourceVal;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Long.class, Double.class, Integer.class, Boolean.class, DecimalValue.class, String.class}, (Object)object, n)) {
            case 0: {
                boolean bl2;
                Long l = (Long)object;
                bl = bl2 = l != 0L;
                break;
            }
            case 1: {
                boolean bl3;
                Double d = (Double)object;
                bl = bl3 = d != 0.0;
                break;
            }
            case 2: {
                boolean bl4;
                Integer i = (Integer)object;
                bl = bl4 = i != 0;
                break;
            }
            case 3: {
                boolean bl5;
                Boolean b = (Boolean)object;
                bl = bl5 = b.booleanValue();
                break;
            }
            case 4: {
                boolean bl6;
                DecimalValue decimalValue = (DecimalValue)object;
                bl = bl6 = decimalValue.booleanValue();
                break;
            }
            case 5: {
                String s = (String)object;
                try {
                    boolean bl7;
                    bl = bl7 = Boolean.parseBoolean(s);
                    break;
                }
                catch (NumberFormatException e) {
                    throw errorFunc.get();
                }
            }
            default: {
                throw errorFunc.get();
            }
        }
        return bl;
    }

    static boolean anyToBooleanCast(Object sourceVal, Supplier<BError> errorFunc) {
        if (sourceVal instanceof Boolean) {
            Boolean b = (Boolean)sourceVal;
            return b;
        }
        throw errorFunc.get();
    }

    public static int intToByte(long sourceVal) {
        if (!TypeChecker.isByteLiteral(sourceVal)) {
            throw ErrorUtils.createNumericConversionError(sourceVal, PredefinedTypes.TYPE_BYTE);
        }
        return Long.valueOf(sourceVal).intValue();
    }

    public static long intToSigned32(long sourceVal) {
        if (!TypeChecker.isSigned32LiteralValue(sourceVal)) {
            throw ErrorUtils.createNumericConversionError(sourceVal, PredefinedTypes.TYPE_INT_SIGNED_32);
        }
        return sourceVal;
    }

    public static long intToSigned16(long sourceVal) {
        if (!TypeChecker.isSigned16LiteralValue(sourceVal)) {
            throw ErrorUtils.createNumericConversionError(sourceVal, PredefinedTypes.TYPE_INT_SIGNED_16);
        }
        return sourceVal;
    }

    public static long intToSigned8(long sourceVal) {
        if (!TypeChecker.isSigned8LiteralValue(sourceVal)) {
            throw ErrorUtils.createNumericConversionError(sourceVal, PredefinedTypes.TYPE_INT_SIGNED_8);
        }
        return sourceVal;
    }

    public static long intToUnsigned32(long sourceVal) {
        if (!TypeChecker.isUnsigned32LiteralValue(sourceVal)) {
            throw ErrorUtils.createNumericConversionError(sourceVal, PredefinedTypes.TYPE_INT_UNSIGNED_32);
        }
        return sourceVal;
    }

    public static long intToUnsigned16(long sourceVal) {
        if (!TypeChecker.isUnsigned16LiteralValue(sourceVal)) {
            throw ErrorUtils.createNumericConversionError(sourceVal, PredefinedTypes.TYPE_INT_UNSIGNED_16);
        }
        return sourceVal;
    }

    public static long intToUnsigned8(long sourceVal) {
        if (!TypeChecker.isUnsigned8LiteralValue(sourceVal)) {
            throw ErrorUtils.createNumericConversionError(sourceVal, PredefinedTypes.TYPE_INT_UNSIGNED_8);
        }
        return sourceVal;
    }

    public static long floatToSigned32(double sourceVal) {
        return TypeConverter.intToSigned32(TypeConverter.floatToInt(sourceVal));
    }

    public static long floatToSigned16(double sourceVal) {
        return TypeConverter.intToSigned16(TypeConverter.floatToInt(sourceVal));
    }

    public static long floatToSigned8(double sourceVal) {
        return TypeConverter.intToSigned8(TypeConverter.floatToInt(sourceVal));
    }

    public static long floatToUnsigned32(double sourceVal) {
        return TypeConverter.intToUnsigned32(TypeConverter.floatToInt(sourceVal));
    }

    public static long floatToUnsigned16(double sourceVal) {
        return TypeConverter.intToUnsigned16(TypeConverter.floatToInt(sourceVal));
    }

    public static long floatToUnsigned8(double sourceVal) {
        return TypeConverter.intToUnsigned8(TypeConverter.floatToInt(sourceVal));
    }

    public static BString stringToChar(Object sourceVal) {
        if (!TypeChecker.isCharLiteralValue(sourceVal)) {
            throw ErrorUtils.createNumericConversionError(sourceVal, PredefinedTypes.TYPE_STRING_CHAR);
        }
        return StringUtils.fromString(Objects.toString(sourceVal));
    }

    public static Long stringToInt(String value2) throws NumberFormatException {
        return Long.parseLong(value2);
    }

    public static int stringToByte(String value2) throws NumberFormatException, BError {
        int byteValue = Integer.parseInt(value2);
        return TypeConverter.intToByte(byteValue);
    }

    public static Double stringToFloat(String value2) throws NumberFormatException {
        if (TypeConverter.hasFloatOrDecimalLiteralSuffix(value2)) {
            throw new NumberFormatException();
        }
        return Double.parseDouble(value2);
    }

    public static boolean hasFloatOrDecimalLiteralSuffix(String value2) {
        int length = value2.length();
        if (length == 0) {
            return false;
        }
        return switch (value2.charAt(length - 1)) {
            case 'D', 'F', 'd', 'f' -> true;
            default -> false;
        };
    }

    public static Boolean stringToBoolean(String value2) throws NumberFormatException {
        if ("true".equalsIgnoreCase(value2) || "1".equalsIgnoreCase(value2)) {
            return true;
        }
        if ("false".equalsIgnoreCase(value2) || "0".equalsIgnoreCase(value2)) {
            return false;
        }
        throw new NumberFormatException();
    }

    public static BDecimal stringToDecimal(String value2) throws NumberFormatException {
        return new DecimalValue(value2);
    }

    public static BXml stringToXml(String value2) throws BError {
        BXml item = XmlUtils.parse("<root>" + value2 + "</root>");
        return item.children();
    }

    public static RegExpValue stringToRegExp(String value2) throws BError {
        return RegExpFactory.parse(value2);
    }

    public static BString anyToChar(Object sourceVal) {
        String value2 = Objects.toString(sourceVal);
        return TypeConverter.stringToChar(value2);
    }

    public static int floatToByte(double sourceVal) {
        TypeConverter.checkIsValidFloat(sourceVal, PredefinedTypes.TYPE_BYTE);
        long intVal = Math.round(sourceVal);
        if (!TypeChecker.isByteLiteral(intVal)) {
            throw ErrorUtils.createNumericConversionError(sourceVal, PredefinedTypes.TYPE_BYTE);
        }
        return (int)intVal;
    }

    public static long floatToInt(double sourceVal) {
        TypeConverter.checkIsValidFloat(sourceVal, PredefinedTypes.TYPE_INT);
        if (!TypeConverter.isFloatWithinIntRange(sourceVal)) {
            throw ErrorUtils.createNumericConversionError(sourceVal, PredefinedTypes.TYPE_INT);
        }
        return (long)Math.rint(sourceVal);
    }

    private static void checkIsValidFloat(double sourceVal, Type targetType) {
        if (Double.isNaN(sourceVal)) {
            throw ErrorUtils.createNumericConversionError(NAN, PredefinedTypes.TYPE_FLOAT, targetType);
        }
        if (Double.isInfinite(sourceVal)) {
            String value2 = sourceVal > 0.0 ? POSITIVE_INFINITY : NEGATIVE_INFINITY;
            throw ErrorUtils.createNumericConversionError(value2, PredefinedTypes.TYPE_FLOAT, targetType);
        }
    }

    static int anyToByte(Object sourceVal, Supplier<BError> errorFunc) {
        int n;
        Object object = sourceVal;
        int n2 = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Long.class, Double.class, Integer.class, Boolean.class, DecimalValue.class, String.class}, (Object)object, n2)) {
            case 0: {
                int n3;
                Long l = (Long)object;
                n = n3 = TypeConverter.intToByte(l);
                break;
            }
            case 1: {
                int n4;
                Double d = (Double)object;
                n = n4 = TypeConverter.floatToByte(d);
                break;
            }
            case 2: {
                int n5;
                Integer i = (Integer)object;
                n = n5 = i.intValue();
                break;
            }
            case 3: {
                int n6;
                Boolean b = (Boolean)object;
                n = n6 = b != false ? 1 : 0;
                break;
            }
            case 4: {
                int n7;
                DecimalValue decimalValue = (DecimalValue)object;
                n = n7 = decimalValue.byteValue();
                break;
            }
            case 5: {
                String s = (String)object;
                try {
                    int n8;
                    n = n8 = Integer.parseInt(s);
                    break;
                }
                catch (NumberFormatException e) {
                    throw errorFunc.get();
                }
            }
            default: {
                throw errorFunc.get();
            }
        }
        return n;
    }

    static int anyToByteCast(Object sourceVal, Supplier<BError> errorFunc) {
        Object object = sourceVal;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Long.class, Byte.class, Double.class, Integer.class, DecimalValue.class}, (Object)object, n)) {
            case 0 -> {
                Long l = (Long)object;
                yield TypeConverter.intToByte(l);
            }
            case 1 -> {
                Byte b = (Byte)object;
                yield b.intValue();
            }
            case 2 -> {
                Double d = (Double)object;
                yield TypeConverter.floatToByte(d);
            }
            case 3 -> {
                Integer i = (Integer)object;
                yield i;
            }
            case 4 -> {
                DecimalValue decimalValue = (DecimalValue)object;
                yield decimalValue.byteValue();
            }
            default -> throw errorFunc.get();
        };
    }

    private static String anyToString(Object sourceVal) {
        Object object = sourceVal;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Long.class, Double.class, Integer.class, Boolean.class, DecimalValue.class, String.class}, (Object)object, n)) {
            case 0 -> {
                Long l = (Long)object;
                yield Long.toString(l);
            }
            case 1 -> {
                Double d = (Double)object;
                yield Double.toString(d);
            }
            case 2 -> {
                Integer i = (Integer)object;
                yield Long.toString(i.intValue());
            }
            case 3 -> {
                Boolean b = (Boolean)object;
                yield Boolean.toString(b);
            }
            case 4 -> {
                DecimalValue decimalValue = (DecimalValue)object;
                yield decimalValue.stringValue(null);
            }
            case 5 -> {
                String s;
                yield s = (String)object;
            }
            case -1 -> "()";
            default -> throw ErrorUtils.createNumericConversionError(sourceVal, PredefinedTypes.TYPE_STRING);
        };
    }

    private static String anyToStringCast(Object sourceVal, Supplier<BError> errorFunc) {
        if (sourceVal instanceof String) {
            String s = (String)sourceVal;
            return s;
        }
        throw errorFunc.get();
    }

    static DecimalValue anyToDecimal(Object sourceVal, Supplier<BError> errorFunc) {
        Object object = sourceVal;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Long.class, Double.class, Integer.class, Boolean.class, DecimalValue.class}, (Object)object, n)) {
            case 0 -> {
                Long l = (Long)object;
                yield DecimalValue.valueOf(l);
            }
            case 1 -> {
                Double d = (Double)object;
                yield DecimalValue.valueOf(d);
            }
            case 2 -> {
                Integer i = (Integer)object;
                yield DecimalValue.valueOf(i);
            }
            case 3 -> {
                Boolean b = (Boolean)object;
                yield DecimalValue.valueOf(b);
            }
            case 4 -> {
                DecimalValue decimalValue;
                yield decimalValue = (DecimalValue)object;
            }
            default -> throw errorFunc.get();
        };
    }

    static DecimalValue anyToDecimalCast(Object sourceVal, Supplier<BError> errorFunc) {
        Object object = sourceVal;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Long.class, Double.class, Integer.class, DecimalValue.class, String.class}, (Object)object, n)) {
            case 0 -> {
                Long l = (Long)object;
                yield DecimalValue.valueOf(l);
            }
            case 1 -> {
                Double d = (Double)object;
                yield DecimalValue.valueOf(d);
            }
            case 2 -> {
                Integer i = (Integer)object;
                yield DecimalValue.valueOf(i);
            }
            case 3 -> {
                DecimalValue decimalValue;
                yield decimalValue = (DecimalValue)object;
            }
            case 4 -> {
                String s = (String)object;
                yield new DecimalValue(s);
            }
            default -> throw errorFunc.get();
        };
    }

    static byte anyToJByteCast(Object sourceVal, Supplier<BError> errorFunc) {
        if (sourceVal instanceof Byte) {
            Byte bVal = (Byte)sourceVal;
            return bVal;
        }
        throw errorFunc.get();
    }

    static char anyToJCharCast(Object sourceVal, Supplier<BError> errorFunc) {
        if (sourceVal instanceof Character) {
            Character cVal = (Character)sourceVal;
            return cVal.charValue();
        }
        throw errorFunc.get();
    }

    static short anyToJShortCast(Object sourceVal, Supplier<BError> errorFunc) {
        if (sourceVal instanceof Short) {
            Short sVal = (Short)sourceVal;
            return sVal;
        }
        throw errorFunc.get();
    }

    static int anyToJIntCast(Object sourceVal, Supplier<BError> errorFunc) {
        if (sourceVal instanceof Integer) {
            Integer iVal = (Integer)sourceVal;
            return iVal;
        }
        throw errorFunc.get();
    }

    static long anyToJLongCast(Object sourceVal, Supplier<BError> errorFunc) {
        if (sourceVal instanceof Long) {
            Long lVal = (Long)sourceVal;
            return lVal;
        }
        throw errorFunc.get();
    }

    static float anyToJFloatCast(Object sourceVal, Supplier<BError> errorFunc) {
        if (sourceVal instanceof Float) {
            Float fVal = (Float)sourceVal;
            return fVal.floatValue();
        }
        throw errorFunc.get();
    }

    static double anyToJDoubleCast(Object sourceVal, Supplier<BError> errorFunc) {
        if (sourceVal instanceof Double) {
            Double dVal = (Double)sourceVal;
            return dVal;
        }
        throw errorFunc.get();
    }

    static boolean anyToJBooleanCast(Object sourceVal, Supplier<BError> errorFunc) {
        if (sourceVal instanceof Boolean) {
            Boolean bVal = (Boolean)sourceVal;
            return bVal;
        }
        throw errorFunc.get();
    }

    public static long jFloatToBInt(float sourceVal) {
        TypeConverter.checkIsValidFloat(sourceVal, PredefinedTypes.TYPE_INT);
        if (!TypeConverter.isFloatWithinIntRange(sourceVal)) {
            throw ErrorUtils.createNumericConversionError(Float.valueOf(sourceVal), PredefinedTypes.TYPE_INT);
        }
        return (long)Math.rint(sourceVal);
    }

    public static long jDoubleToBInt(double sourceVal) {
        TypeConverter.checkIsValidFloat(sourceVal, PredefinedTypes.TYPE_INT);
        if (!TypeConverter.isFloatWithinIntRange(sourceVal)) {
            throw ErrorUtils.createNumericConversionError(sourceVal, PredefinedTypes.TYPE_INT);
        }
        return (long)Math.rint(sourceVal);
    }

    private static boolean isFloatWithinIntRange(double doubleValue) {
        return doubleValue < 9.223372036854776E18 && doubleValue > -9.223372036854776E18;
    }

    public static Type resolveMatchingTypeForUnion(Object value2, Type targetUnionType) {
        if (value2 == null && targetUnionType.isNilable()) {
            return PredefinedTypes.TYPE_NULL;
        }
        if (TypeChecker.checkIsLikeType(value2, PredefinedTypes.TYPE_INT)) {
            return PredefinedTypes.TYPE_INT;
        }
        if (TypeChecker.checkIsLikeType(value2, PredefinedTypes.TYPE_FLOAT)) {
            return PredefinedTypes.TYPE_FLOAT;
        }
        if (TypeChecker.checkIsLikeType(value2, PredefinedTypes.TYPE_STRING)) {
            return PredefinedTypes.TYPE_STRING;
        }
        if (TypeChecker.checkIsLikeType(value2, PredefinedTypes.TYPE_BOOLEAN)) {
            return PredefinedTypes.TYPE_BOOLEAN;
        }
        if (TypeChecker.checkIsLikeType(value2, PredefinedTypes.TYPE_DECIMAL)) {
            return PredefinedTypes.TYPE_DECIMAL;
        }
        boolean readOnlyTargetType = targetUnionType.isReadOnly();
        if (TypeChecker.checkIsLikeType(value2, PredefinedTypes.TYPE_XML)) {
            return readOnlyTargetType ? PredefinedTypes.TYPE_READONLY_XML : PredefinedTypes.TYPE_XML;
        }
        BArrayType targetTypeArrayType = new BArrayType(targetUnionType, readOnlyTargetType);
        if (TypeChecker.checkIsLikeType(value2, targetTypeArrayType)) {
            return targetTypeArrayType;
        }
        BMapType targetTypeMapType = new BMapType(targetUnionType, readOnlyTargetType);
        if (TypeChecker.checkIsLikeType(value2, targetTypeMapType)) {
            return targetTypeMapType;
        }
        BTableType targetTypeMapTableType = new BTableType(targetTypeMapType, readOnlyTargetType);
        if (TypeChecker.checkIsLikeType(value2, targetTypeMapTableType)) {
            return targetTypeMapTableType;
        }
        return null;
    }

    private TypeConverter() {
    }

    public static List<Type> getXmlTargetTypes(Type targetType) {
        ArrayList<Type> xmlTargetTypes = new ArrayList<Type>();
        return switch (targetType.getTag()) {
            case 16, 18, 19, 20, 21 -> {
                xmlTargetTypes.add(targetType);
                yield xmlTargetTypes;
            }
            case 53 -> {
                xmlTargetTypes.addAll(TypeConverter.getXmlTargetTypes(((ReferenceType)targetType).getReferredType()));
                yield xmlTargetTypes;
            }
            case 34 -> {
                xmlTargetTypes.addAll(TypeConverter.getXmlTargetTypes(((IntersectionType)targetType).getEffectiveType()));
                yield xmlTargetTypes;
            }
            case 33 -> {
                for (Type memberType : ((UnionType)targetType).getMemberTypes()) {
                    xmlTargetTypes.addAll(TypeConverter.getXmlTargetTypes(memberType));
                }
                yield xmlTargetTypes;
            }
            case 46 -> {
                for (Object o : ((FiniteType)targetType).getValueSpace()) {
                    if (!TypeTags.isXMLTypeTag(TypeChecker.getType(o).getTag())) continue;
                    xmlTargetTypes.add(targetType);
                    yield xmlTargetTypes;
                }
                yield xmlTargetTypes;
            }
            default -> xmlTargetTypes;
        };
    }
}

