/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.configurable.providers.toml;

import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.IntersectableReferenceType;
import io.ballerina.runtime.api.types.IntersectionType;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.ReferenceType;
import io.ballerina.runtime.api.types.TableType;
import io.ballerina.runtime.api.types.TupleType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BListInitialValueEntry;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BMapInitialValueEntry;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTable;
import io.ballerina.runtime.internal.TypeConverter;
import io.ballerina.runtime.internal.commons.TypeValuePair;
import io.ballerina.runtime.internal.configurable.providers.toml.Utils;
import io.ballerina.runtime.internal.types.BIntersectionType;
import io.ballerina.runtime.internal.types.BUnionType;
import io.ballerina.runtime.internal.utils.ValueUtils;
import io.ballerina.runtime.internal.values.ArrayValue;
import io.ballerina.runtime.internal.values.ArrayValueImpl;
import io.ballerina.runtime.internal.values.ListInitialValueEntry;
import io.ballerina.runtime.internal.values.MappingInitialValueEntry;
import io.ballerina.runtime.internal.values.ReadOnlyUtils;
import io.ballerina.runtime.internal.values.TableValueImpl;
import io.ballerina.toml.semantic.TomlType;
import io.ballerina.toml.semantic.ast.TomlArrayValueNode;
import io.ballerina.toml.semantic.ast.TomlBasicValueNode;
import io.ballerina.toml.semantic.ast.TomlInlineTableValueNode;
import io.ballerina.toml.semantic.ast.TomlKeyValueNode;
import io.ballerina.toml.semantic.ast.TomlNode;
import io.ballerina.toml.semantic.ast.TomlTableArrayNode;
import io.ballerina.toml.semantic.ast.TomlTableNode;
import io.ballerina.toml.semantic.ast.TomlValueNode;
import io.ballerina.toml.semantic.ast.TopLevelNode;
import io.ballerina.tools.text.LineRange;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ConfigValueCreator {
    public Object createValue(TomlNode tomlValue, Type type) {
        if (Utils.isSimpleType(TypeUtils.getImpliedType(type).getTag())) {
            return this.createPrimitiveValue(tomlValue, type);
        }
        return this.createStructuredValue(tomlValue, type);
    }

    private Object createPrimitiveValue(TomlNode tomlValue, Type type) {
        TomlValueNode value2 = ((TomlKeyValueNode)tomlValue).value();
        return this.createBalValue(type, value2);
    }

    private Object createStructuredValue(TomlNode tomlValue, Type type) {
        if (tomlValue.kind() == TomlType.INLINE_TABLE) {
            tomlValue = ((TomlInlineTableValueNode)tomlValue).toTable();
        }
        switch (type.getTag()) {
            case 32: {
                return this.createArrayValue(tomlValue, (ArrayType)type);
            }
            case 24: {
                return this.createRecordValue(tomlValue, type);
            }
            case 27: {
                return this.createMapValue(tomlValue, (MapType)type);
            }
            case 17: {
                return this.createTableValue(tomlValue, type);
            }
            case 15: 
            case 23: 
            case 33: {
                return this.createUnionValue(tomlValue, (BUnionType)type);
            }
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 40: {
                return this.createBalValue(type, ((TomlKeyValueNode)tomlValue).value());
            }
            case 44: {
                return this.createTupleValue(tomlValue, (TupleType)type);
            }
            case 53: {
                return this.createValue(tomlValue, ((ReferenceType)type).getReferredType());
            }
        }
        Type effectiveType = ((IntersectionType)type).getEffectiveType();
        if (effectiveType.getTag() == 24) {
            return this.createRecordValue(tomlValue, type);
        }
        if (effectiveType.getTag() == 17) {
            return this.createTableValue(tomlValue, type);
        }
        return this.createStructuredValue(tomlValue, effectiveType);
    }

    private BArray createTupleValue(TomlNode tomlValue, TupleType tupleType) {
        tomlValue = Utils.getValueFromKeyValueNode(tomlValue);
        List<TomlValueNode> elements = ((TomlArrayValueNode)tomlValue).elements();
        int size = elements.size();
        BListInitialValueEntry[] entries = new ListInitialValueEntry.ExpressionEntry[size];
        List<Type> tupleTypes = tupleType.getTupleTypes();
        for (int i = 0; i < size; ++i) {
            Type type = Utils.getTupleElementType(tupleTypes, i, tupleType);
            TomlValueNode valueNode = elements.get(i);
            Object value2 = Utils.isSimpleType(TypeUtils.getImpliedType(type).getTag()) ? this.createBalValue(type, valueNode) : this.createStructuredValue(valueNode, type);
            entries[i] = new ListInitialValueEntry.ExpressionEntry(value2);
        }
        return ValueCreator.createTupleValue(tupleType, size, entries);
    }

    private BArray createArrayValue(TomlNode tomlValue, ArrayType arrayType) {
        Type elementType = arrayType.getElementType();
        if (Utils.isSimpleType(TypeUtils.getImpliedType(elementType).getTag())) {
            tomlValue = Utils.getValueFromKeyValueNode(tomlValue);
            return this.createArrayFromSimpleTomlValue((TomlArrayValueNode)tomlValue, arrayType, elementType);
        }
        return this.getNonSimpleTypeArray(tomlValue, arrayType, elementType);
    }

    private BArray getNonSimpleTypeArray(TomlNode tomlValue, ArrayType arrayType, Type elementType) {
        switch (TypeUtils.getImpliedType(elementType).getTag()) {
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 32: 
            case 40: 
            case 44: {
                tomlValue = Utils.getValueFromKeyValueNode(tomlValue);
                return this.createArrayFromSimpleTomlValue((TomlArrayValueNode)tomlValue, arrayType, elementType);
            }
            case 17: 
            case 24: 
            case 27: {
                return this.getStructuredValueArray(tomlValue, arrayType, elementType);
            }
        }
        if (tomlValue.kind() == TomlType.TABLE_ARRAY) {
            return this.getStructuredValueArray(tomlValue, arrayType, elementType);
        }
        tomlValue = Utils.getValueFromKeyValueNode(tomlValue);
        return this.createArrayFromSimpleTomlValue((TomlArrayValueNode)tomlValue, arrayType, elementType);
    }

    private BArray getStructuredValueArray(TomlNode tomlValue, ArrayType arrayType, Type elementType) {
        BListInitialValueEntry[] entries = this.getListEntries(tomlValue, elementType);
        return new ArrayValueImpl((Type)arrayType, entries);
    }

    private ListInitialValueEntry.ExpressionEntry[] getListEntries(TomlNode tomlValue, Type elementType) {
        return switch (tomlValue.kind()) {
            case TomlType.ARRAY -> this.createInitialValuesFromArrayNode((TomlArrayValueNode)tomlValue, elementType);
            case TomlType.TABLE_ARRAY -> this.createInitialValuesFromTableArrayNode((TomlTableArrayNode)tomlValue, elementType);
            default -> this.getListEntries(((TomlKeyValueNode)tomlValue).value(), elementType);
        };
    }

    private BArray createArrayFromSimpleTomlValue(TomlArrayValueNode tomlValue, ArrayType arrayType, Type elementType) {
        List<TomlValueNode> arrayList = tomlValue.elements();
        int arraySize = arrayList.size();
        BListInitialValueEntry[] arrayEntries = new ListInitialValueEntry.ExpressionEntry[arraySize];
        for (int i = 0; i < arraySize; ++i) {
            TomlNode tomlValueNode = arrayList.get(i);
            Object balValue = this.getElementValue(elementType, tomlValueNode);
            arrayEntries[i] = new ListInitialValueEntry.ExpressionEntry(balValue);
        }
        return new ArrayValueImpl((Type)arrayType, arrayEntries);
    }

    private Object getElementValue(Type elementType, TomlNode tomlValueNode) {
        Type refElementType = TypeUtils.getImpliedType(elementType);
        return switch (refElementType.getTag()) {
            case 32 -> {
                ArrayType arrayType = (ArrayType)refElementType;
                yield this.createArrayFromSimpleTomlValue((TomlArrayValueNode)tomlValueNode, arrayType, TypeUtils.getImpliedType(arrayType.getElementType()));
            }
            case 15, 23, 33 -> this.createUnionValue(tomlValueNode, (BUnionType)refElementType);
            case 44 -> this.createTupleValue(tomlValueNode, (TupleType)refElementType);
            default -> this.createBalValue(elementType, (TomlValueNode)tomlValueNode);
        };
    }

    private BMap<BString, Object> createRecordValue(TomlNode tomlNode, Type type) {
        Optional<IntersectionType> intersectionType = ((IntersectableReferenceType)type).getIntersectionType();
        RecordType mutableType = intersectionType.isPresent() ? (RecordType)ReadOnlyUtils.getMutableType((BIntersectionType)intersectionType.get()) : (type.getTag() == 24 ? (RecordType)type : (RecordType)ReadOnlyUtils.getMutableType((BIntersectionType)type));
        TomlTableNode tomlValue = (TomlTableNode)tomlNode;
        HashMap<String, Object> initialValueEntries = new HashMap<String, Object>();
        for (Map.Entry<String, TopLevelNode> tomlField : tomlValue.entries().entrySet()) {
            String fieldName = tomlField.getKey();
            Field field = mutableType.getFields().get(fieldName);
            TomlNode value2 = tomlField.getValue();
            if (field == null) {
                field = Utils.createAdditionalField(mutableType, fieldName, value2);
            }
            Type fieldType = field.getFieldType();
            Object objectValue = this.createValue(value2, fieldType);
            initialValueEntries.put(fieldName, objectValue);
        }
        return ValueCreator.createReadonlyRecordValue(mutableType.getPackage(), mutableType.getName(), initialValueEntries);
    }

    private BTable<BString, Object> createTableValue(TomlNode tomlValue, Type type) {
        ArrayValue keyNames;
        Type constraintType;
        TableType tableType;
        if (type.getTag() == 34) {
            tableType = (TableType)((BIntersectionType)type).getEffectiveType();
            constraintType = tableType.getConstrainedType();
            if (constraintType.getTag() == 34) {
                constraintType = ((IntersectionType)constraintType).getEffectiveType();
            }
            if (constraintType.getTag() == 24) {
                tableType = (TableType)ReadOnlyUtils.getMutableType((BIntersectionType)type);
            }
        } else {
            tableType = (TableType)type;
        }
        constraintType = tableType.getConstrainedType();
        BListInitialValueEntry[] tableEntries = this.getListEntries(tomlValue, constraintType);
        String[] keys = tableType.getFieldNames();
        ArrayValueImpl tableData = new ArrayValueImpl((Type)TypeCreator.createArrayType(constraintType), tableEntries);
        ArrayValue arrayValue = keyNames = keys == null ? (ArrayValue)ValueCreator.createArrayValue(new BString[0]) : (ArrayValue)StringUtils.fromStringArray(keys);
        if (constraintType.getTag() == 34) {
            constraintType = ((IntersectionType)constraintType).getEffectiveType();
        }
        return new TableValueImpl<BString, Object>(TypeCreator.createTableType(constraintType, keys, true), (ArrayValue)tableData, keyNames);
    }

    private ListInitialValueEntry.ExpressionEntry[] createInitialValuesFromArrayNode(TomlArrayValueNode tomlValue, Type constraintType) {
        List<TomlValueNode> tableNodeList = tomlValue.elements();
        int tableSize = tableNodeList.size();
        ListInitialValueEntry.ExpressionEntry[] tableEntries = new ListInitialValueEntry.ExpressionEntry[tableSize];
        for (int i = 0; i < tableSize; ++i) {
            Object value2 = this.createValue(tableNodeList.get(i), constraintType);
            tableEntries[i] = new ListInitialValueEntry.ExpressionEntry(value2);
        }
        return tableEntries;
    }

    private ListInitialValueEntry.ExpressionEntry[] createInitialValuesFromTableArrayNode(TomlTableArrayNode tomlValue, Type constraintType) {
        List<TomlTableNode> tableNodeList = tomlValue.children();
        int tableSize = tableNodeList.size();
        ListInitialValueEntry.ExpressionEntry[] tableEntries = new ListInitialValueEntry.ExpressionEntry[tableSize];
        for (int i = 0; i < tableSize; ++i) {
            Object value2 = this.createValue(tableNodeList.get(i), constraintType);
            tableEntries[i] = new ListInitialValueEntry.ExpressionEntry(value2);
        }
        return tableEntries;
    }

    private Object createBalValue(Type type, TomlValueNode tomlValueNode) {
        Object tomlValue = ((TomlBasicValueNode)tomlValueNode).getValue();
        return switch (TypeUtils.getImpliedType(type).getTag()) {
            case 2 -> ((Long)tomlValue).intValue();
            case 4 -> ValueCreator.createDecimalValue(BigDecimal.valueOf((Double)tomlValue));
            case 5 -> StringUtils.fromString((String)tomlValue);
            case 16, 18, 19, 20, 21, 40 -> ValueUtils.createReadOnlyXmlValue((String)tomlValue);
            default -> tomlValue;
        };
    }

    private BMap<BString, Object> createMapValue(TomlNode tomlValue, MapType mapType) {
        TomlTableNode tomlTableValue = (TomlTableNode)tomlValue;
        Map<String, TopLevelNode> entries = tomlTableValue.entries();
        BMapInitialValueEntry[] keyValueEntries = new MappingInitialValueEntry.KeyValueEntry[entries.size()];
        int count = 0;
        for (Map.Entry<String, TopLevelNode> field : entries.entrySet()) {
            String fieldName = field.getKey();
            Type constrainedType = mapType.getConstrainedType();
            Object value2 = this.createValue(field.getValue(), constrainedType);
            keyValueEntries[count] = new MappingInitialValueEntry.KeyValueEntry(StringUtils.fromString(fieldName), value2);
            ++count;
        }
        return ValueCreator.createMapValue(mapType, keyValueEntries);
    }

    private Object createUnionValue(TomlNode tomlValue, BUnionType unionType) {
        Object balValue = Utils.getBalValueFromToml(tomlValue, new HashSet<TomlNode>(), unionType, new HashSet<LineRange>(), "");
        Type convertibleType = TypeConverter.getConvertibleType(balValue, unionType, null, new HashSet<TypeValuePair>(), new ArrayList<String>(), false);
        Type type = Utils.getEffectiveType(TypeUtils.getImpliedType(convertibleType));
        if (Utils.isSimpleType(type.getTag()) || type.getTag() == 46 || Utils.isXMLType(type)) {
            return balValue;
        }
        return this.createStructuredValue(tomlValue, convertibleType);
    }
}

