/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.scheduling;

import io.ballerina.runtime.api.values.BFunctionPointer;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.internal.scheduling.Scheduler;
import io.ballerina.runtime.internal.scheduling.Strand;
import io.ballerina.runtime.internal.utils.RuntimeUtils;
import io.ballerina.runtime.internal.values.ObjectValue;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.locks.ReentrantLock;

public class RuntimeRegistry {
    public final Scheduler scheduler;
    public final Deque<BObject> listenerQueue = new ArrayDeque<BObject>();
    private final Deque<BFunctionPointer> stopHandlerQueue = new ArrayDeque<BFunctionPointer>();
    private final ReentrantLock listenerLock = new ReentrantLock();
    private final ReentrantLock stopHandlerLock = new ReentrantLock();

    public RuntimeRegistry(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public void registerListener(BObject listener) {
        try {
            this.listenerLock.lock();
            this.listenerQueue.add(listener);
        }
        finally {
            this.listenerLock.unlock();
        }
    }

    public void deregisterListener(BObject listener) {
        try {
            this.listenerLock.lock();
            this.listenerQueue.remove(listener);
        }
        finally {
            this.listenerLock.unlock();
        }
    }

    public void registerStopHandler(BFunctionPointer stopHandler) {
        try {
            this.stopHandlerLock.lock();
            this.stopHandlerQueue.push(stopHandler);
        }
        finally {
            this.stopHandlerLock.unlock();
        }
    }

    public void gracefulStop(Strand strand) {
        while (!this.listenerQueue.isEmpty()) {
            RuntimeUtils.handleErrorResult(((ObjectValue)this.listenerQueue.pollFirst()).call(strand, "gracefulStop", new Object[0]));
        }
        while (!this.stopHandlerQueue.isEmpty()) {
            RuntimeUtils.handleErrorResult(this.stopHandlerQueue.pollFirst().call(this.scheduler.runtime, new Object[0]));
        }
    }
}

