/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types;

import io.ballerina.runtime.api.flags.TypeFlags;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.IntersectionType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.semtype.BasicTypeBitSet;
import io.ballerina.runtime.api.types.semtype.Builder;
import io.ballerina.runtime.api.types.semtype.Context;
import io.ballerina.runtime.api.types.semtype.Env;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.api.types.semtype.ShapeAnalyzer;
import io.ballerina.runtime.internal.TypeChecker;
import io.ballerina.runtime.internal.types.BType;
import io.ballerina.runtime.internal.types.MayBeDependentType;
import io.ballerina.runtime.internal.types.ShapeSupplier;
import io.ballerina.runtime.internal.types.TypeCheckFlyweightStore;
import io.ballerina.runtime.internal.types.TypeWithShape;
import io.ballerina.runtime.internal.types.semtype.CellAtomicType;
import io.ballerina.runtime.internal.types.semtype.DefinitionContainer;
import io.ballerina.runtime.internal.types.semtype.ListDefinition;
import io.ballerina.runtime.internal.types.semtype.TypeCheckCacheFlyweight;
import io.ballerina.runtime.internal.values.AbstractArrayValue;
import io.ballerina.runtime.internal.values.ArrayValue;
import io.ballerina.runtime.internal.values.ArrayValueImpl;
import io.ballerina.runtime.internal.values.ReadOnlyUtils;
import java.util.Optional;
import java.util.Set;

public class BArrayType
extends BType
implements ArrayType,
TypeWithShape {
    private static final BasicTypeBitSet BASIC_TYPE = Builder.getListType();
    private static final TypeCheckFlyweightStore<ListDefinition> FLYWEIGHT_STORE = new TypeCheckFlyweightStore();
    private static final SemType[] EMPTY_SEMTYPE_ARR = new SemType[0];
    private Type elementType;
    private int dimensions = 1;
    private int size = -1;
    private final boolean hasFillerValue;
    private ArrayType.ArrayState state = ArrayType.ArrayState.OPEN;
    private final boolean readonly;
    private IntersectionType immutableType;
    private IntersectionType intersectionType = null;
    private int typeFlags;
    private final DefinitionContainer<ListDefinition> defn = new DefinitionContainer();
    private final DefinitionContainer<ListDefinition> acceptedTypeDefn = new DefinitionContainer();

    public BArrayType(Type elementType) {
        this(elementType, false);
    }

    public BArrayType(Type elementType, boolean readonly) {
        this(elementType, -1, readonly);
    }

    public BArrayType(Type elemType, int size) {
        this(elemType, size, false);
    }

    public BArrayType(Type elemType, int size, boolean readonly) {
        this(elemType, size, readonly, 0);
    }

    public BArrayType(Type elemType, int size, boolean readonly, int typeFlags) {
        this(typeFlags, size, readonly, TypeChecker.hasFillerValue(elemType));
        this.setElementType(elemType, 1, elemType.isReadOnly());
        this.setFlagsBasedOnElementType();
    }

    public BArrayType(int typeFlags, int size, boolean readonly, boolean hasFillerValue) {
        super(null, null, ArrayValue.class, false);
        this.typeFlags = typeFlags;
        if (size != -1) {
            this.state = ArrayType.ArrayState.CLOSED;
            this.size = size;
        }
        this.readonly = readonly;
        this.hasFillerValue = hasFillerValue;
    }

    public void setElementType(Type elementType, int dimensions, boolean elementRO) {
        if (this.elementType != null) {
            this.resetSemType();
        }
        this.elementType = this.readonly && !elementRO ? ReadOnlyUtils.getReadOnlyType(elementType) : elementType;
        this.dimensions = dimensions;
        if (this.size == -1) {
            TypeCheckCacheFlyweight<ListDefinition> flyweight = this.isReadOnly() ? FLYWEIGHT_STORE.getRO(elementType) : FLYWEIGHT_STORE.getRW(elementType);
            this.typeId = flyweight.typeId();
            this.typeCheckCache = flyweight.typeCheckCache();
        } else {
            this.initializeCache();
        }
    }

    private void setFlagsBasedOnElementType() {
        if (this.elementType.isNilable()) {
            this.typeFlags = TypeFlags.addToMask(this.typeFlags, 1);
        }
        if (this.elementType.isAnydata()) {
            this.typeFlags = TypeFlags.addToMask(this.typeFlags, 2);
        }
        if (this.elementType.isPureType()) {
            this.typeFlags = TypeFlags.addToMask(this.typeFlags, 4);
        }
    }

    @Override
    public Type getElementType() {
        return this.elementType;
    }

    @Override
    public <V> V getZeroValue() {
        return this.getEmptyValue();
    }

    @Override
    public <V> V getEmptyValue() {
        return (V)new ArrayValueImpl(this);
    }

    @Override
    public int getTag() {
        return 32;
    }

    @Override
    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BArrayType) {
            BArrayType other = (BArrayType)obj;
            if ((other.state == ArrayType.ArrayState.CLOSED || this.state == ArrayType.ArrayState.CLOSED) && this.size != other.size) {
                return false;
            }
            return this.elementType.equals(other.elementType) && this.readonly == other.readonly;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        Type tempElementType = this.elementType;
        sb.append(this.getSizeString());
        while (tempElementType.getTag() == 32) {
            BArrayType arrayElement = (BArrayType)tempElementType;
            sb.append(arrayElement.getSizeString());
            tempElementType = arrayElement.elementType;
        }
        sb.insert(0, tempElementType);
        return !this.readonly ? sb.toString() : sb.append(" & readonly").toString();
    }

    private String getSizeString() {
        return this.size != -1 ? "[" + this.size + "]" : "[]";
    }

    public int getDimensions() {
        return this.dimensions;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public boolean hasFillerValue() {
        return this.hasFillerValue;
    }

    @Override
    public ArrayType.ArrayState getState() {
        return this.state;
    }

    @Override
    public boolean isAnydata() {
        return TypeFlags.isFlagOn(this.typeFlags, 2);
    }

    @Override
    public boolean isReadOnly() {
        return this.readonly;
    }

    @Override
    public IntersectionType getImmutableType() {
        return this.immutableType;
    }

    @Override
    public void setImmutableType(IntersectionType immutableType) {
        this.immutableType = immutableType;
    }

    @Override
    public BasicTypeBitSet getBasicType() {
        return BASIC_TYPE;
    }

    @Override
    public Optional<IntersectionType> getIntersectionType() {
        return this.intersectionType == null ? Optional.empty() : Optional.of(this.intersectionType);
    }

    @Override
    public void setIntersectionType(IntersectionType intersectionType) {
        this.intersectionType = intersectionType;
    }

    @Override
    public SemType createSemType(Context cx) {
        Env env = cx.env;
        if (this.defn.isDefinitionReady()) {
            return this.defn.getSemType(env);
        }
        DefinitionContainer.DefinitionUpdateResult<ListDefinition> result = this.defn.trySetDefinition(ListDefinition::new);
        if (!result.updated()) {
            return this.defn.getSemType(env);
        }
        ListDefinition ld = result.definition();
        CellAtomicType.CellMutability mut = this.isReadOnly() ? CellAtomicType.CellMutability.CELL_MUT_NONE : CellAtomicType.CellMutability.CELL_MUT_LIMITED;
        return this.getSemTypePart(env, ld, this.size, BArrayType.tryInto(cx, this.getElementType()), mut);
    }

    private SemType getSemTypePart(Env env, ListDefinition defn, int size, SemType elementType, CellAtomicType.CellMutability mut) {
        if (size == -1) {
            return defn.defineListTypeWrapped(env, EMPTY_SEMTYPE_ARR, 0, elementType, mut);
        }
        SemType[] initial = new SemType[]{elementType};
        return defn.defineListTypeWrapped(env, initial, size, Builder.getNeverType(), mut);
    }

    @Override
    public void resetSemType() {
        this.defn.clear();
        super.resetSemType();
    }

    @Override
    protected boolean isDependentlyTypedInner(Set<MayBeDependentType> visited) {
        MayBeDependentType eType;
        Type type = this.elementType;
        return type instanceof MayBeDependentType && (eType = (MayBeDependentType)((Object)type)).isDependentlyTyped(visited);
    }

    @Override
    public Optional<SemType> inherentTypeOf(Context cx, ShapeSupplier shapeSupplier, Object object) {
        if (!this.couldInherentTypeBeDifferent()) {
            return Optional.of(this.getSemType(cx));
        }
        AbstractArrayValue value2 = (AbstractArrayValue)object;
        SemType cachedShape = value2.shapeOf();
        if (cachedShape != null) {
            return Optional.of(cachedShape);
        }
        SemType semType = this.shapeOfInner(cx, shapeSupplier, value2);
        value2.cacheShape(semType);
        return Optional.of(semType);
    }

    @Override
    public boolean couldInherentTypeBeDifferent() {
        return this.isReadOnly();
    }

    @Override
    public Optional<SemType> shapeOf(Context cx, ShapeSupplier shapeSupplier, Object object) {
        return Optional.of(this.shapeOfInner(cx, shapeSupplier, (AbstractArrayValue)object));
    }

    @Override
    public SemType acceptedTypeOf(Context cx) {
        Env env = cx.env;
        if (this.acceptedTypeDefn.isDefinitionReady()) {
            return this.acceptedTypeDefn.getSemType(cx.env);
        }
        DefinitionContainer.DefinitionUpdateResult<ListDefinition> result = this.acceptedTypeDefn.trySetDefinition(ListDefinition::new);
        if (!result.updated()) {
            return this.acceptedTypeDefn.getSemType(env);
        }
        return this.getSemTypePart(env, result.definition(), this.size, ShapeAnalyzer.acceptedTypeOf(cx, this.getElementType()), CellAtomicType.CellMutability.CELL_MUT_UNLIMITED);
    }

    private SemType shapeOfInner(Context cx, ShapeSupplier shapeSupplier, AbstractArrayValue value2) {
        ListDefinition readonlyShapeDefinition = value2.getReadonlyShapeDefinition();
        if (readonlyShapeDefinition != null) {
            return readonlyShapeDefinition.getSemType(cx.env);
        }
        int size = value2.size();
        SemType[] memberTypes = new SemType[size];
        ListDefinition ld = new ListDefinition();
        value2.setReadonlyShapeDefinition(ld);
        for (int i = 0; i < size; ++i) {
            Optional<SemType> memberType = shapeSupplier.get(cx, value2.get(i));
            assert (memberType.isPresent());
            memberTypes[i] = memberType.get();
        }
        CellAtomicType.CellMutability mut = this.isReadOnly() ? CellAtomicType.CellMutability.CELL_MUT_NONE : CellAtomicType.CellMutability.CELL_MUT_LIMITED;
        SemType semType = ld.defineListTypeWrapped(cx.env, memberTypes, memberTypes.length, Builder.getNeverType(), mut);
        value2.resetReadonlyShapeDefinition();
        return semType;
    }
}

