/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types;

import io.ballerina.identifier.Utils;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.flags.SymbolFlags;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.FunctionType;
import io.ballerina.runtime.api.types.IntersectionType;
import io.ballerina.runtime.api.types.MethodType;
import io.ballerina.runtime.api.types.ObjectType;
import io.ballerina.runtime.api.types.Parameter;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.TypeId;
import io.ballerina.runtime.api.types.TypeIdSet;
import io.ballerina.runtime.api.types.semtype.BasicTypeBitSet;
import io.ballerina.runtime.api.types.semtype.Builder;
import io.ballerina.runtime.api.types.semtype.Context;
import io.ballerina.runtime.api.types.semtype.Core;
import io.ballerina.runtime.api.types.semtype.Env;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.api.types.semtype.ShapeAnalyzer;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.scheduling.Scheduler;
import io.ballerina.runtime.internal.scheduling.Strand;
import io.ballerina.runtime.internal.types.BArrayType;
import io.ballerina.runtime.internal.types.BFunctionType;
import io.ballerina.runtime.internal.types.BMethodType;
import io.ballerina.runtime.internal.types.BNetworkObjectType;
import io.ballerina.runtime.internal.types.BResourceMethodType;
import io.ballerina.runtime.internal.types.BStructureType;
import io.ballerina.runtime.internal.types.BTypeIdSet;
import io.ballerina.runtime.internal.types.DistinctIdSupplier;
import io.ballerina.runtime.internal.types.MayBeDependentType;
import io.ballerina.runtime.internal.types.ShapeSupplier;
import io.ballerina.runtime.internal.types.TypeWithShape;
import io.ballerina.runtime.internal.types.semtype.CellAtomicType;
import io.ballerina.runtime.internal.types.semtype.DefinitionContainer;
import io.ballerina.runtime.internal.types.semtype.FunctionDefinition;
import io.ballerina.runtime.internal.types.semtype.ListDefinition;
import io.ballerina.runtime.internal.types.semtype.Member;
import io.ballerina.runtime.internal.types.semtype.ObjectDefinition;
import io.ballerina.runtime.internal.types.semtype.ObjectQualifiers;
import io.ballerina.runtime.internal.utils.ValueUtils;
import io.ballerina.runtime.internal.values.AbstractObjectValue;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.BiFunction;

public class BObjectType
extends BStructureType
implements ObjectType,
TypeWithShape {
    private static final BasicTypeBitSet BASIC_TYPE = Builder.getObjectType();
    private MethodType[] methodTypes;
    private MethodType initMethod;
    public MethodType generatedInitMethod;
    private final boolean readonly;
    protected IntersectionType immutableType;
    private IntersectionType intersectionType = null;
    public BTypeIdSet typeIdSet;
    private String cachedToString;
    private boolean resolving;
    private final DefinitionContainer<ObjectDefinition> defn = new DefinitionContainer();
    private final DefinitionContainer<ObjectDefinition> acceptedTypeDefn = new DefinitionContainer();
    private volatile DistinctIdSupplier distinctIdSupplier;

    public BObjectType(String typeName, Module pkg, long flags) {
        super(typeName, pkg, flags, Object.class);
        this.readonly = SymbolFlags.isFlagOn(flags, 32L);
    }

    @Override
    public <V> V getZeroValue() {
        return (V)BObjectType.createObjectValueWithDefaultValues(this.pkg, this);
    }

    private static BObject createObjectValueWithDefaultValues(Module packageId, BObjectType objectType) {
        Strand currentStrand = Scheduler.getStrand();
        Map<String, Field> fieldsMap = objectType.getFields();
        Field[] fields = fieldsMap.values().toArray(new Field[0]);
        Object[] fieldValues = new Object[fields.length];
        int j = 0;
        for (int i = 0; i < fields.length; ++i) {
            Type type = fields[i].getFieldType();
            fieldValues[j++] = type.getZeroValue();
        }
        return ValueUtils.createObjectValue(currentStrand, packageId, objectType.getName(), fieldValues);
    }

    @Override
    public String getAnnotationKey() {
        return Utils.decodeIdentifier(this.typeName);
    }

    @Override
    public <V> V getEmptyValue() {
        return null;
    }

    @Override
    public int getTag() {
        return 47;
    }

    @Override
    public MethodType[] getMethods() {
        return this.methodTypes;
    }

    @Override
    public MethodType getInitMethod() {
        return this.initMethod;
    }

    public MethodType getGeneratedInitMethod() {
        return this.generatedInitMethod;
    }

    @Override
    public boolean isIsolated() {
        return SymbolFlags.isFlagOn(this.getFlags(), 0x20000000L);
    }

    @Override
    public boolean isIsolated(String methodName) {
        for (MethodType methodType : this.getMethods()) {
            if (!methodType.getName().equals(methodName)) continue;
            return methodType.isIsolated();
        }
        if (this.getTag() == 31 || (this.flags & 0x10000L) == 65536L) {
            for (MethodType methodType : ((BNetworkObjectType)this).getResourceMethods()) {
                if (!methodType.getName().equals(methodName)) continue;
                return methodType.isIsolated();
            }
        }
        throw ErrorCreator.createError(StringUtils.fromString("No such method: " + methodName));
    }

    @Override
    public void setMethods(MethodType[] methodTypes) {
        this.methodTypes = methodTypes;
    }

    public void setInitMethod(MethodType initMethod) {
        this.initMethod = initMethod;
    }

    public void setGeneratedInitMethod(BMethodType generatedInitMethod) {
        this.generatedInitMethod = generatedInitMethod;
    }

    public void computeStringRepresentation() {
        String name;
        if (this.cachedToString != null) {
            return;
        }
        String string2 = name = this.pkg == null || this.pkg.getName() == null || this.pkg.getName().equals(".") ? this.typeName : this.pkg.getName() + ":" + this.typeName;
        if (!this.typeName.contains("$anon")) {
            this.cachedToString = name;
            return;
        }
        StringJoiner sj = new StringJoiner(",\n\t", name + " {\n\t", "\n}");
        for (Map.Entry<String, Field> field : this.getFields().entrySet()) {
            sj.add(field.getKey() + " : " + String.valueOf(field.getValue().getFieldType()));
        }
        for (MethodType func : this.methodTypes) {
            sj.add(func.toString());
        }
        this.cachedToString = sj.toString();
    }

    @Override
    public String toString() {
        if (this.resolving) {
            return "";
        }
        this.resolving = true;
        this.computeStringRepresentation();
        this.resolving = false;
        return this.cachedToString;
    }

    @Override
    public boolean isReadOnly() {
        return this.readonly;
    }

    @Override
    public IntersectionType getImmutableType() {
        return this.immutableType;
    }

    @Override
    public void setImmutableType(IntersectionType immutableType) {
        this.immutableType = immutableType;
    }

    @Override
    public BasicTypeBitSet getBasicType() {
        return BASIC_TYPE;
    }

    @Override
    public Optional<IntersectionType> getIntersectionType() {
        return this.intersectionType == null ? Optional.empty() : Optional.of(this.intersectionType);
    }

    @Override
    public void setIntersectionType(IntersectionType intersectionType) {
        this.intersectionType = intersectionType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTypeIdSet(BTypeIdSet typeIdSet) {
        this.typeIdSet = typeIdSet;
        BObjectType bObjectType = this;
        synchronized (bObjectType) {
            this.distinctIdSupplier = null;
        }
        this.resetSemType();
    }

    public BObjectType duplicate() {
        BObjectType type = new BObjectType(this.typeName, this.pkg, this.flags);
        type.setFields(this.fields);
        type.setMethods(this.duplicateArray(this.methodTypes));
        type.immutableType = this.immutableType;
        type.typeIdSet = this.typeIdSet;
        return type;
    }

    protected <T extends MethodType> T[] duplicateArray(T[] methodTypes) {
        Class<?> elemType = methodTypes.getClass().getComponentType();
        MethodType[] array2 = (MethodType[])Array.newInstance(elemType, methodTypes.length);
        for (int i = 0; i < methodTypes.length; ++i) {
            BMethodType functionType = (BMethodType)methodTypes[i];
            array2[i] = functionType.duplicate();
        }
        return array2;
    }

    public boolean hasAnnotations() {
        return !this.annotations.isEmpty();
    }

    @Override
    public TypeIdSet getTypeIdSet() {
        if (this.typeIdSet == null) {
            return new BTypeIdSet();
        }
        return new BTypeIdSet(new ArrayList<TypeId>(this.typeIdSet.ids));
    }

    @Override
    public final SemType createSemType(Context cx) {
        SemType innerType;
        CellAtomicType.CellMutability mut;
        Env env = cx.env;
        this.initializeDistinctIdSupplierIfNeeded(env);
        CellAtomicType.CellMutability cellMutability = mut = SymbolFlags.isFlagOn(this.getFlags(), 32L) ? CellAtomicType.CellMutability.CELL_MUT_NONE : CellAtomicType.CellMutability.CELL_MUT_LIMITED;
        if (this.defn.isDefinitionReady()) {
            innerType = this.defn.getSemType(env);
        } else {
            DefinitionContainer.DefinitionUpdateResult<ObjectDefinition> result = this.defn.trySetDefinition(ObjectDefinition::new);
            if (!result.updated()) {
                innerType = this.defn.getSemType(env);
            } else {
                ObjectDefinition od = result.definition();
                innerType = this.semTypeInner(cx, od, mut, SemType::tryInto);
            }
        }
        return this.distinctIdSupplier.get().stream().map(ObjectDefinition::distinct).reduce(innerType, Core::intersect);
    }

    private static boolean skipField(Set<String> seen, String name) {
        if (name.startsWith("$")) {
            return true;
        }
        return !seen.add(name);
    }

    private SemType semTypeInner(Context cx, ObjectDefinition od, CellAtomicType.CellMutability mut, BiFunction<Context, Type, SemType> semTypeSupplier) {
        String name;
        Env env = cx.env;
        ObjectQualifiers qualifiers = this.getObjectQualifiers();
        ArrayList<Member> members = new ArrayList<Member>();
        HashSet<String> seen = new HashSet<String>();
        for (Map.Entry entry : this.fields.entrySet()) {
            name = (String)entry.getKey();
            if (BObjectType.skipField(seen, name)) continue;
            Field field = (Field)entry.getValue();
            boolean isPublic = SymbolFlags.isFlagOn(field.getFlags(), 1L);
            boolean isImmutable = qualifiers.readonly() | SymbolFlags.isFlagOn(field.getFlags(), 32L);
            members.add(new Member(name, semTypeSupplier.apply(cx, field.getFieldType()), Member.Kind.Field, isPublic ? Member.Visibility.Public : Member.Visibility.Private, isImmutable));
        }
        for (MethodData method : this.allMethods(cx)) {
            name = method.name();
            if (BObjectType.skipField(seen, name)) continue;
            boolean isPublic = SymbolFlags.isFlagOn(method.flags(), 1L);
            members.add(new Member(name, method.semType(), Member.Kind.Method, isPublic ? Member.Visibility.Public : Member.Visibility.Private, true));
        }
        return od.define(env, qualifiers, members, mut);
    }

    private ObjectQualifiers getObjectQualifiers() {
        boolean isolated = SymbolFlags.isFlagOn(this.getFlags(), 0x20000000L);
        boolean readonly = SymbolFlags.isFlagOn(this.getFlags(), 32L);
        ObjectQualifiers.NetworkQualifier networkQualifier = SymbolFlags.isFlagOn(this.getFlags(), 262144L) ? ObjectQualifiers.NetworkQualifier.Service : (SymbolFlags.isFlagOn(this.getFlags(), 65536L) ? ObjectQualifiers.NetworkQualifier.Client : ObjectQualifiers.NetworkQualifier.None);
        return new ObjectQualifiers(isolated, readonly, networkQualifier);
    }

    @Override
    public Optional<SemType> inherentTypeOf(Context cx, ShapeSupplier shapeSupplier, Object object) {
        if (!this.couldInherentTypeBeDifferent()) {
            return Optional.of(this.getSemType(cx));
        }
        AbstractObjectValue abstractObjectValue = (AbstractObjectValue)object;
        SemType cachedShape = abstractObjectValue.shapeOf();
        if (cachedShape != null) {
            return Optional.of(cachedShape);
        }
        this.initializeDistinctIdSupplierIfNeeded(cx.env);
        SemType shape = this.distinctIdSupplier.get().stream().map(ObjectDefinition::distinct).reduce(this.valueShape(cx, shapeSupplier, abstractObjectValue), Core::intersect);
        abstractObjectValue.cacheShape(shape);
        return Optional.of(shape);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeDistinctIdSupplierIfNeeded(Env env) {
        if (this.distinctIdSupplier == null) {
            BObjectType bObjectType = this;
            synchronized (bObjectType) {
                if (this.distinctIdSupplier == null) {
                    this.distinctIdSupplier = new DistinctIdSupplier(env, this.typeIdSet);
                }
            }
        }
    }

    @Override
    public Optional<SemType> shapeOf(Context cx, ShapeSupplier shapeSupplierFn, Object object) {
        return Optional.of(this.valueShape(cx, shapeSupplierFn, (AbstractObjectValue)object));
    }

    @Override
    public final SemType acceptedTypeOf(Context cx) {
        SemType innerType;
        Env env = cx.env;
        this.initializeDistinctIdSupplierIfNeeded(cx.env);
        CellAtomicType.CellMutability mut = CellAtomicType.CellMutability.CELL_MUT_UNLIMITED;
        if (this.acceptedTypeDefn.isDefinitionReady()) {
            innerType = this.acceptedTypeDefn.getSemType(env);
        } else {
            DefinitionContainer.DefinitionUpdateResult<ObjectDefinition> result = this.acceptedTypeDefn.trySetDefinition(ObjectDefinition::new);
            if (!result.updated()) {
                innerType = this.acceptedTypeDefn.getSemType(env);
            } else {
                ObjectDefinition od = result.definition();
                innerType = this.semTypeInner(cx, od, mut, ShapeAnalyzer::acceptedTypeOf);
            }
        }
        return this.distinctIdSupplier.get().stream().map(ObjectDefinition::distinct).reduce(innerType, Core::intersect);
    }

    @Override
    public boolean couldInherentTypeBeDifferent() {
        if (SymbolFlags.isFlagOn(this.getFlags(), 32L)) {
            return true;
        }
        return this.fields.values().stream().anyMatch(field -> SymbolFlags.isFlagOn(field.getFlags(), 32L) || SymbolFlags.isFlagOn(field.getFlags(), 4L));
    }

    private SemType valueShape(Context cx, ShapeSupplier shapeSupplier, AbstractObjectValue object) {
        String name;
        ObjectDefinition readonlyShapeDefinition = object.getReadonlyShapeDefinition();
        if (readonlyShapeDefinition != null) {
            return readonlyShapeDefinition.getSemType(cx.env);
        }
        ObjectDefinition od = new ObjectDefinition();
        object.setReadonlyShapeDefinition(od);
        ArrayList<Member> members = new ArrayList<Member>();
        HashSet<String> seen = new HashSet<String>(this.fields.size() + this.methodTypes.length);
        ObjectQualifiers qualifiers = this.getObjectQualifiers();
        for (Map.Entry entry : this.fields.entrySet()) {
            name = (String)entry.getKey();
            if (BObjectType.skipField(seen, name)) continue;
            Field field = (Field)entry.getValue();
            boolean isPublic = SymbolFlags.isFlagOn(field.getFlags(), 1L);
            boolean isImmutable = qualifiers.readonly() | SymbolFlags.isFlagOn(field.getFlags(), 32L) | SymbolFlags.isFlagOn(field.getFlags(), 4L);
            members.add(new Member(name, BObjectType.fieldShape(cx, shapeSupplier, field, object, isImmutable), Member.Kind.Field, isPublic ? Member.Visibility.Public : Member.Visibility.Private, isImmutable));
        }
        for (MethodData method : this.allMethods(cx)) {
            name = method.name();
            if (BObjectType.skipField(seen, name)) continue;
            boolean isPublic = SymbolFlags.isFlagOn(method.flags(), 1L);
            members.add(new Member(name, method.semType(), Member.Kind.Method, isPublic ? Member.Visibility.Public : Member.Visibility.Private, true));
        }
        return od.define(cx.env, qualifiers, members, qualifiers.readonly() ? CellAtomicType.CellMutability.CELL_MUT_NONE : CellAtomicType.CellMutability.CELL_MUT_LIMITED);
    }

    private static SemType fieldShape(Context cx, ShapeSupplier shapeSupplier, Field field, AbstractObjectValue objectValue, boolean isImmutable) {
        if (!isImmutable) {
            return SemType.tryInto(cx, field.getFieldType());
        }
        BString fieldName = StringUtils.fromString(field.getFieldName());
        Optional<SemType> shape = shapeSupplier.get(cx, objectValue.get(fieldName));
        assert (shape.isPresent());
        return shape.get();
    }

    @Override
    public void resetSemType() {
        this.defn.clear();
        super.resetSemType();
    }

    protected Collection<MethodData> allMethods(Context cx) {
        if (this.methodTypes == null) {
            return List.of();
        }
        return Arrays.stream(this.methodTypes).map(type -> MethodData.fromMethod(cx, type)).toList();
    }

    @Override
    protected boolean isDependentlyTypedInner(Set<MayBeDependentType> visited) {
        return this.fields.values().stream().map(Field::getFieldType).filter(each -> each instanceof MayBeDependentType).anyMatch(each -> ((MayBeDependentType)((Object)each)).isDependentlyTyped(visited));
    }

    protected record MethodData(String name, long flags, SemType semType) {
        static MethodData fromMethod(Context cx, MethodType method) {
            return new MethodData(method.getName(), method.getFlags(), SemType.tryInto(cx, method.getType()));
        }

        static MethodData fromRemoteMethod(Context cx, MethodType method) {
            return new MethodData("@remote_" + method.getName(), method.getFlags(), SemType.tryInto(cx, method.getType()));
        }

        static MethodData fromResourceMethod(Context cx, BResourceMethodType method) {
            SemType rest;
            StringBuilder sb = new StringBuilder();
            sb.append(method.getAccessor());
            for (String each : method.getResourcePath()) {
                sb.append(each);
            }
            String methodName = sb.toString();
            Type[] pathSegmentTypes = method.pathSegmentTypes;
            FunctionType innerFn = method.getType();
            ArrayList<SemType> paramTypes = new ArrayList<SemType>();
            for (Type part : pathSegmentTypes) {
                if (part == null) {
                    paramTypes.add(Builder.getAnyType());
                    continue;
                }
                paramTypes.add(SemType.tryInto(cx, part));
            }
            for (Parameter paramType : innerFn.getParameters()) {
                paramTypes.add(SemType.tryInto(cx, paramType.type));
            }
            Type restType = innerFn.getRestType();
            if (restType instanceof BArrayType) {
                BArrayType arrayType = (BArrayType)restType;
                rest = SemType.tryInto(cx, arrayType.getElementType());
            } else {
                rest = Builder.getNeverType();
            }
            SemType returnType = innerFn.getReturnType() != null ? SemType.tryInto(cx, innerFn.getReturnType()) : Builder.getNilType();
            ListDefinition paramListDefinition = new ListDefinition();
            Env env = cx.env;
            SemType paramType = paramListDefinition.defineListTypeWrapped(env, (SemType[])paramTypes.toArray(SemType[]::new), paramTypes.size(), rest, CellAtomicType.CellMutability.CELL_MUT_NONE);
            FunctionDefinition fd = new FunctionDefinition();
            SemType semType = fd.define(env, paramType, returnType, ((BFunctionType)innerFn).getQualifiers());
            return new MethodData(methodName, method.getFlags(), semType);
        }
    }
}

