/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types;

import io.ballerina.identifier.Utils;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.flags.SymbolFlags;
import io.ballerina.runtime.api.flags.TypeFlags;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.IntersectionType;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.semtype.BasicTypeBitSet;
import io.ballerina.runtime.api.types.semtype.Builder;
import io.ballerina.runtime.api.types.semtype.Context;
import io.ballerina.runtime.api.types.semtype.Core;
import io.ballerina.runtime.api.types.semtype.Env;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.api.types.semtype.ShapeAnalyzer;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BFunctionPointer;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.scheduling.Scheduler;
import io.ballerina.runtime.internal.types.BField;
import io.ballerina.runtime.internal.types.BIntersectionType;
import io.ballerina.runtime.internal.types.BStructureType;
import io.ballerina.runtime.internal.types.MayBeDependentType;
import io.ballerina.runtime.internal.types.ShapeSupplier;
import io.ballerina.runtime.internal.types.TypeWithShape;
import io.ballerina.runtime.internal.types.semtype.CellAtomicType;
import io.ballerina.runtime.internal.types.semtype.DefinitionContainer;
import io.ballerina.runtime.internal.types.semtype.MappingDefinition;
import io.ballerina.runtime.internal.values.MapValueImpl;
import io.ballerina.runtime.internal.values.ReadOnlyUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public class BRecordType
extends BStructureType
implements RecordType,
TypeWithShape {
    private static final BasicTypeBitSet BASIC_TYPE_BIT_SET = Builder.getMappingType();
    private final String internalName;
    public boolean sealed;
    public Type restFieldType;
    public int typeFlags;
    private final boolean readonly;
    private IntersectionType immutableType;
    private IntersectionType intersectionType = null;
    private final DefinitionContainer<MappingDefinition> defn = new DefinitionContainer();
    private final DefinitionContainer<MappingDefinition> acceptedTypeDefn = new DefinitionContainer();
    private byte couldInhereTypeBeDifferentCache = 0;
    private final Map<String, BFunctionPointer> defaultValues = new LinkedHashMap<String, BFunctionPointer>();

    public BRecordType(String typeName, String internalName, Module pkg, long flags, boolean sealed, int typeFlags) {
        super(typeName, pkg, flags, MapValueImpl.class);
        this.internalName = internalName;
        this.sealed = sealed;
        this.typeFlags = typeFlags;
        this.readonly = SymbolFlags.isFlagOn(flags, 32L);
        TypeCreator.registerRecordType(this);
    }

    public BRecordType(String typeName, Module pkg, long flags, Map<String, Field> fields, Type restFieldType, boolean sealed, int typeFlags) {
        super(typeName, pkg, flags, MapValueImpl.class);
        this.sealed = sealed;
        this.typeFlags = typeFlags;
        this.readonly = SymbolFlags.isFlagOn(flags, 32L);
        if (this.readonly) {
            this.fields = this.getReadOnlyFields(fields);
            if (restFieldType != null) {
                this.restFieldType = ReadOnlyUtils.getReadOnlyType(restFieldType);
            }
        } else {
            this.restFieldType = restFieldType;
            this.fields = fields;
        }
        this.internalName = typeName;
        TypeCreator.registerRecordType(this);
    }

    private Map<String, Field> getReadOnlyFields(Map<String, Field> fields) {
        HashMap<String, Field> fieldMap = new HashMap<String, Field>(fields.size());
        for (Map.Entry<String, Field> fieldEntry : fields.entrySet()) {
            Field field = fieldEntry.getValue();
            if (!field.getFieldType().isReadOnly()) {
                field = new BField(ReadOnlyUtils.getReadOnlyType(field.getFieldType()), field.getFieldName(), field.getFlags());
            }
            fieldMap.put(fieldEntry.getKey(), field);
        }
        return fieldMap;
    }

    @Override
    public <V> V getZeroValue() {
        String typeName = this.typeName;
        if (this.intersectionType != null) {
            typeName = ReadOnlyUtils.getMutableType((BIntersectionType)this.intersectionType).getName();
        }
        if (this.isReadOnly()) {
            return (V)ValueCreator.createReadonlyRecordValue(this.pkg, typeName, new HashMap<String, Object>());
        }
        BMap<BString, Object> recordValue = ValueCreator.createRecordValue(this.pkg, typeName);
        if (this.defaultValues.isEmpty()) {
            return (V)recordValue;
        }
        for (Map.Entry<String, BFunctionPointer> field : this.defaultValues.entrySet()) {
            recordValue.put(StringUtils.fromString(field.getKey()), field.getValue().call(Scheduler.getStrand().scheduler.runtime, new Object[0]));
        }
        return (V)recordValue;
    }

    @Override
    public <V> V getEmptyValue() {
        MapValueImpl implicitInitValue = new MapValueImpl(this);
        this.fields.entrySet().stream().filter(entry -> !SymbolFlags.isFlagOn(((Field)entry.getValue()).getFlags(), 4096L)).forEach(entry -> {
            Object value2 = ((Field)entry.getValue()).getFieldType().getEmptyValue();
            implicitInitValue.put(StringUtils.fromString((String)entry.getKey()), value2);
        });
        return (V)implicitInitValue;
    }

    @Override
    public int getTag() {
        return 24;
    }

    @Override
    public String getAnnotationKey() {
        return Utils.decodeIdentifier(this.internalName);
    }

    @Override
    public boolean isAnydata() {
        return TypeFlags.isFlagOn(this.typeFlags, 2);
    }

    @Override
    public boolean isPureType() {
        return TypeFlags.isFlagOn(this.typeFlags, 4);
    }

    @Override
    public boolean isReadOnly() {
        return this.readonly;
    }

    @Override
    public IntersectionType getImmutableType() {
        return this.immutableType;
    }

    @Override
    public void setImmutableType(IntersectionType immutableType) {
        this.immutableType = immutableType;
    }

    @Override
    public BasicTypeBitSet getBasicType() {
        return BASIC_TYPE_BIT_SET;
    }

    @Override
    public Optional<IntersectionType> getIntersectionType() {
        return this.intersectionType == null ? Optional.empty() : Optional.of(this.intersectionType);
    }

    @Override
    public void setIntersectionType(IntersectionType intersectionType) {
        this.intersectionType = intersectionType;
    }

    @Override
    public boolean isSealed() {
        return this.sealed;
    }

    @Override
    public Type getRestFieldType() {
        return this.restFieldType;
    }

    @Override
    public int getTypeFlags() {
        return this.typeFlags;
    }

    public void setDefaultValue(String fieldName, BFunctionPointer defaultValue) {
        this.defaultValues.put(fieldName, defaultValue);
    }

    public Map<String, BFunctionPointer> getDefaultValues() {
        return this.defaultValues;
    }

    @Override
    public SemType createSemType(Context cx) {
        Env env = cx.env;
        if (this.defn.isDefinitionReady()) {
            return this.defn.getSemType(env);
        }
        DefinitionContainer.DefinitionUpdateResult<MappingDefinition> result = this.defn.trySetDefinition(MappingDefinition::new);
        if (!result.updated()) {
            return this.defn.getSemType(env);
        }
        MappingDefinition md = result.definition();
        return this.createSemTypeInner(md, env, this.mut(), type -> SemType.tryInto(cx, type));
    }

    private CellAtomicType.CellMutability mut() {
        return this.isReadOnly() ? CellAtomicType.CellMutability.CELL_MUT_NONE : CellAtomicType.CellMutability.CELL_MUT_LIMITED;
    }

    private SemType createSemTypeInner(MappingDefinition md, Env env, CellAtomicType.CellMutability mut, Function<Type, SemType> semTypeFunction) {
        Field[] fields = (Field[])this.getFields().values().toArray(Field[]::new);
        MappingDefinition.Field[] mappingFields = new MappingDefinition.Field[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            boolean isOptional = SymbolFlags.isFlagOn(field.getFlags(), 4096L);
            SemType fieldType = semTypeFunction.apply(field.getFieldType());
            if (!isOptional && Core.isNever(fieldType)) {
                return Builder.getNeverType();
            }
            boolean isReadonly = SymbolFlags.isFlagOn(field.getFlags(), 32L) || Core.isNever(fieldType);
            mappingFields[i] = new MappingDefinition.Field(field.getFieldName(), fieldType, isReadonly, isOptional);
        }
        SemType rest = this.restFieldType != null ? semTypeFunction.apply(this.restFieldType) : Builder.getNeverType();
        return md.defineMappingTypeWrapped(env, mappingFields, rest, mut);
    }

    @Override
    public void resetSemType() {
        this.defn.clear();
        super.resetSemType();
    }

    @Override
    public boolean isDependentlyTypedInner(Set<MayBeDependentType> visited) {
        return this.fields.values().stream().map(Field::getFieldType).filter(each -> each instanceof MayBeDependentType).anyMatch(each -> ((MayBeDependentType)((Object)each)).isDependentlyTyped(visited));
    }

    @Override
    public Optional<SemType> inherentTypeOf(Context cx, ShapeSupplier shapeSupplier, Object object) {
        if (!this.couldInherentTypeBeDifferent()) {
            return Optional.of(this.getSemType(cx));
        }
        MapValueImpl value2 = (MapValueImpl)object;
        SemType cachedSemType = value2.shapeOf();
        if (cachedSemType != null) {
            return Optional.of(cachedSemType);
        }
        SemType semTypePart = this.shapeOfInner(cx, shapeSupplier, value2, this.isReadOnly());
        value2.cacheShape(semTypePart);
        return Optional.of(semTypePart);
    }

    private SemType shapeOfInner(Context cx, ShapeSupplier shapeSupplier, MapValueImpl<?, ?> value2, boolean takeFieldShape) {
        MappingDefinition md;
        Env env = cx.env;
        int nFields = value2.size();
        Map.Entry[] entries = (Map.Entry[])value2.entrySet().toArray(Map.Entry[]::new);
        HashSet<String> handledFields = new HashSet<String>(nFields);
        if (takeFieldShape) {
            MappingDefinition readonlyShapeDefinition = value2.getReadonlyShapeDefinition();
            if (readonlyShapeDefinition != null) {
                return readonlyShapeDefinition.getSemType(env);
            }
            md = new MappingDefinition();
            value2.setReadonlyShapeDefinition(md);
        } else {
            md = new MappingDefinition();
        }
        ArrayList<MappingDefinition.Field> fields = new ArrayList<MappingDefinition.Field>(nFields);
        for (int i = 0; i < nFields; ++i) {
            String fieldName = entries[i].getKey().toString();
            Object fieldValue = entries[i].getValue();
            handledFields.add(fieldName);
            fields.add(this.fieldShape(cx, shapeSupplier, fieldName, fieldValue, takeFieldShape));
        }
        if (!takeFieldShape) {
            this.getFields().values().stream().filter(field -> !handledFields.contains(field.getFieldName())).map(field -> this.fieldShapeWithoutValue(cx, (Field)field, field.getFieldName())).forEach(fields::add);
        }
        MappingDefinition.Field[] fieldsArray = (MappingDefinition.Field[])fields.toArray(MappingDefinition.Field[]::new);
        SemType rest = takeFieldShape ? Builder.getNeverType() : (this.restFieldType != null ? SemType.tryInto(cx, this.restFieldType) : Builder.getNeverType());
        SemType shape = md.defineMappingTypeWrapped(env, fieldsArray, rest, this.mut());
        value2.resetReadonlyShapeDefinition();
        return shape;
    }

    private MappingDefinition.Field fieldShapeWithoutValue(Context cx, Field field, String fieldName) {
        boolean isOptional = this.fieldIsOptional(fieldName);
        boolean isReadonly = this.fieldIsReadonly(fieldName);
        SemType fieldType = SemType.tryInto(cx, field.getFieldType());
        if (isReadonly && isOptional) {
            fieldType = Builder.getUndefType();
        }
        return new MappingDefinition.Field(field.getFieldName(), fieldType, isReadonly, isOptional);
    }

    @Override
    public boolean couldInherentTypeBeDifferent() {
        if (this.couldInhereTypeBeDifferentCache != 0) {
            return this.couldInhereTypeBeDifferentCache == 1;
        }
        boolean result = this.couldShapeBeDifferentInner();
        this.couldInhereTypeBeDifferentCache = (byte)(result ? 1 : 2);
        return result;
    }

    private boolean couldShapeBeDifferentInner() {
        if (this.isReadOnly()) {
            return true;
        }
        return this.fields.values().stream().anyMatch(field -> SymbolFlags.isFlagOn(field.getFlags(), 32L));
    }

    @Override
    public Optional<SemType> shapeOf(Context cx, ShapeSupplier shapeSupplier, Object object) {
        return Optional.of(this.shapeOfInner(cx, shapeSupplier, (MapValueImpl)object, true));
    }

    @Override
    public SemType acceptedTypeOf(Context cx) {
        Env env = cx.env;
        if (this.acceptedTypeDefn.isDefinitionReady()) {
            return this.acceptedTypeDefn.getSemType(env);
        }
        DefinitionContainer.DefinitionUpdateResult<MappingDefinition> result = this.acceptedTypeDefn.trySetDefinition(MappingDefinition::new);
        if (!result.updated()) {
            return this.acceptedTypeDefn.getSemType(env);
        }
        MappingDefinition md = result.definition();
        return this.createSemTypeInner(md, env, CellAtomicType.CellMutability.CELL_MUT_UNLIMITED, type -> ShapeAnalyzer.acceptedTypeOf(cx, type));
    }

    private Type fieldType(String fieldName) {
        Field field = (Field)this.fields.get(fieldName);
        return field == null ? this.restFieldType : field.getFieldType();
    }

    private boolean fieldIsReadonly(String fieldName) {
        Field field = (Field)this.fields.get(fieldName);
        return field != null && SymbolFlags.isFlagOn(field.getFlags(), 32L);
    }

    private boolean fieldIsOptional(String fieldName) {
        Field field = (Field)this.fields.get(fieldName);
        return field != null && SymbolFlags.isFlagOn(field.getFlags(), 4096L);
    }

    private MappingDefinition.Field fieldShape(Context cx, ShapeSupplier shapeSupplier, String fieldName, Object fieldValue, boolean alwaysTakeValueShape) {
        SemType fieldType;
        boolean readonlyField = this.fieldIsReadonly(fieldName);
        boolean optionalField = this.fieldIsOptional(fieldName);
        if (alwaysTakeValueShape || readonlyField) {
            optionalField = false;
            fieldType = shapeSupplier.get(cx, fieldValue).orElseThrow();
        } else {
            fieldType = SemType.tryInto(cx, this.fieldType(fieldName));
        }
        return new MappingDefinition.Field(fieldName, fieldType, readonlyField, optionalField);
    }
}

