/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types;

import io.ballerina.runtime.api.types.IntersectionType;
import io.ballerina.runtime.api.types.TableType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.semtype.BasicTypeBitSet;
import io.ballerina.runtime.api.types.semtype.Builder;
import io.ballerina.runtime.api.types.semtype.Context;
import io.ballerina.runtime.api.types.semtype.Core;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.api.types.semtype.ShapeAnalyzer;
import io.ballerina.runtime.api.values.BTable;
import io.ballerina.runtime.internal.types.BType;
import io.ballerina.runtime.internal.types.MayBeDependentType;
import io.ballerina.runtime.internal.types.ShapeSupplier;
import io.ballerina.runtime.internal.types.TypeWithShape;
import io.ballerina.runtime.internal.types.semtype.TableUtils;
import io.ballerina.runtime.internal.values.ReadOnlyUtils;
import io.ballerina.runtime.internal.values.TableValue;
import io.ballerina.runtime.internal.values.TableValueImpl;
import java.util.Optional;
import java.util.Set;

public class BTableType
extends BType
implements TableType,
TypeWithShape {
    private static final BasicTypeBitSet BASIC_TYPE = Builder.getTableType();
    private final Type constraint;
    private Type keyType;
    private String[] fieldNames = new String[0];
    private final boolean readonly;
    private IntersectionType immutableType;
    private IntersectionType intersectionType = null;

    public BTableType(Type constraint, String[] fieldNames, boolean readonly) {
        this(constraint, readonly);
        this.fieldNames = fieldNames;
    }

    public BTableType(Type constraint, Type keyType, boolean readonly) {
        this(constraint, readonly);
        this.keyType = keyType;
    }

    public BTableType(Type constraint, boolean readonly) {
        super("table", null, TableValue.class, true);
        this.constraint = readonly ? ReadOnlyUtils.getReadOnlyType(constraint) : constraint;
        this.readonly = readonly;
    }

    @Override
    public Type getConstrainedType() {
        return this.constraint;
    }

    public Type getKeyType() {
        return this.keyType;
    }

    @Override
    public String[] getFieldNames() {
        return this.fieldNames;
    }

    @Override
    public <V> V getZeroValue() {
        return (V)new TableValueImpl(new BTableType(this.constraint, this.readonly));
    }

    @Override
    public <V> V getEmptyValue() {
        return this.getZeroValue();
    }

    @Override
    public int getTag() {
        return 17;
    }

    @Override
    public String toString() {
        String stringRep;
        if (this.constraint == null) {
            return this.readonly ? super.toString().concat(" & readonly") : super.toString();
        }
        StringBuilder keyStringBuilder = new StringBuilder();
        if (this.fieldNames.length > 0) {
            for (String fieldName : this.fieldNames) {
                if (!keyStringBuilder.toString().isEmpty()) {
                    keyStringBuilder.append(", ");
                }
                keyStringBuilder.append(fieldName);
            }
            stringRep = super.toString() + "<" + String.valueOf(this.constraint) + "> key(" + keyStringBuilder.toString() + ")";
        } else {
            stringRep = super.toString() + "<" + String.valueOf(this.constraint) + ">" + (String)(this.keyType != null ? " key<" + String.valueOf(this.keyType) + ">" : "");
        }
        return this.readonly ? stringRep.concat(" & readonly") : stringRep;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj) || !(obj instanceof BTableType)) {
            return false;
        }
        BTableType other = (BTableType)obj;
        if (this.constraint == other.constraint && this.keyType == other.keyType) {
            return true;
        }
        if (this.constraint == null || other.constraint == null) {
            return false;
        }
        if (this.keyType == null || other.keyType == null) {
            return false;
        }
        return this.constraint.equals(other.constraint) && this.keyType.equals(other.keyType);
    }

    @Override
    public boolean isReadOnly() {
        return this.readonly;
    }

    @Override
    public IntersectionType getImmutableType() {
        return this.immutableType;
    }

    @Override
    public void setImmutableType(IntersectionType immutableType) {
        this.immutableType = immutableType;
    }

    @Override
    public BasicTypeBitSet getBasicType() {
        return BASIC_TYPE;
    }

    @Override
    public Optional<IntersectionType> getIntersectionType() {
        return this.intersectionType == null ? Optional.empty() : Optional.of(this.intersectionType);
    }

    @Override
    public void setIntersectionType(IntersectionType intersectionType) {
        this.intersectionType = intersectionType;
    }

    @Override
    public boolean isAnydata() {
        return this.constraint.isAnydata();
    }

    @Override
    public SemType createSemType(Context cx) {
        return this.createSemTypeWithConstraint(cx, BTableType.tryInto(cx, this.constraint));
    }

    private SemType createSemTypeWithConstraint(Context cx, SemType constraintType) {
        SemType semType = this.fieldNames.length > 0 ? TableUtils.tableContainingKeySpecifier(cx, constraintType, this.fieldNames) : (this.keyType != null ? TableUtils.tableContainingKeyConstraint(cx, constraintType, BTableType.tryInto(cx, this.keyType)) : TableUtils.tableContaining(cx.env, constraintType));
        if (this.isReadOnly()) {
            semType = Core.intersect(semType, Builder.getReadonlyType());
        }
        return semType;
    }

    @Override
    public Optional<SemType> inherentTypeOf(Context cx, ShapeSupplier shapeSupplier, Object object) {
        if (!this.couldInherentTypeBeDifferent()) {
            return Optional.of(this.getSemType(cx));
        }
        BTable table2 = (BTable)object;
        SemType cachedShape = table2.shapeOf();
        if (cachedShape != null) {
            return Optional.of(cachedShape);
        }
        SemType semtype = this.valueShape(cx, shapeSupplier, table2);
        return Optional.of(semtype);
    }

    @Override
    public boolean couldInherentTypeBeDifferent() {
        return this.isReadOnly();
    }

    @Override
    public Optional<SemType> shapeOf(Context cx, ShapeSupplier shapeSupplierFn, Object object) {
        return Optional.of(this.valueShape(cx, shapeSupplierFn, (BTable)object));
    }

    @Override
    public SemType acceptedTypeOf(Context cx) {
        SemType constraintType = ShapeAnalyzer.acceptedTypeOf(cx, this.constraint);
        if (this.fieldNames.length > 0) {
            return TableUtils.acceptedTypeContainingKeySpecifier(cx, constraintType, this.fieldNames);
        }
        if (this.keyType != null) {
            SemType keyAcceptedType = ShapeAnalyzer.acceptedTypeOf(cx, this.keyType);
            return TableUtils.acceptedTypeContainingKeyConstraint(cx, constraintType, keyAcceptedType);
        }
        return TableUtils.acceptedType(cx.env, constraintType);
    }

    private SemType valueShape(Context cx, ShapeSupplier shapeSupplier, BTable<?, ?> table2) {
        SemType constraintType = Builder.getNeverType();
        for (Object value2 : table2.values()) {
            SemType valueShape = shapeSupplier.get(cx, value2).orElse(SemType.tryInto(cx, this.constraint));
            constraintType = Core.union(constraintType, valueShape);
        }
        return this.createSemTypeWithConstraint(cx, constraintType);
    }

    @Override
    protected boolean isNamedType() {
        return false;
    }

    @Override
    protected boolean isDependentlyTypedInner(Set<MayBeDependentType> visited) {
        MayBeDependentType constraintType;
        Type type = this.constraint;
        return type instanceof MayBeDependentType && (constraintType = (MayBeDependentType)((Object)type)).isDependentlyTyped(visited);
    }
}

