/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.types.IntersectionType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.TypeIdentifier;
import io.ballerina.runtime.api.types.semtype.CacheableTypeDescriptor;
import io.ballerina.runtime.api.types.semtype.Context;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.api.types.semtype.TypeCheckCache;
import io.ballerina.runtime.api.types.semtype.TypeCheckCacheFactory;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.internal.TypeChecker;
import io.ballerina.runtime.internal.types.MayBeDependentType;
import io.ballerina.runtime.internal.types.TypeIdSupplier;
import io.ballerina.runtime.internal.types.semtype.MutableSemType;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public abstract non-sealed class BType
extends SemType
implements Type,
MutableSemType,
Cloneable,
CacheableTypeDescriptor,
MayBeDependentType {
    protected String typeName;
    protected Module pkg;
    protected Class<? extends Object> valueClass;
    private int hashCode;
    private Type cachedReferredType = null;
    private Type cachedImpliedType = null;
    private volatile SemType cachedSemType = null;
    protected TypeCheckCache typeCheckCache;
    protected int typeId;

    protected BType(String typeName, Module pkg, Class<? extends Object> valueClass, boolean initializeCache) {
        this.typeName = typeName;
        this.pkg = pkg;
        this.valueClass = valueClass;
        if (pkg != null && typeName != null) {
            this.hashCode = Objects.hash(pkg, typeName);
        }
        if (initializeCache) {
            this.initializeCache();
        }
    }

    protected void initializeCache() {
        if (this.isNamedType()) {
            TypeIdentifier identifier = new TypeIdentifier(this.pkg, this.typeName);
            this.typeCheckCache = TypeCheckCacheFactory.get(identifier);
            this.typeId = TypeIdSupplier.namedId(identifier);
        } else {
            this.typeCheckCache = TypeCheckCacheFactory.create();
            this.typeId = TypeIdSupplier.getAnonId();
        }
    }

    public <V> Class<V> getValueClass() {
        return this.valueClass;
    }

    @Override
    public abstract <V> V getZeroValue();

    @Override
    public abstract <V> V getEmptyValue();

    @Override
    public abstract int getTag();

    @Override
    public String toString() {
        return this.pkg == null || this.pkg.getName() == null || this.pkg.getName().equals(".") ? this.typeName : this.pkg.getName() + ":" + this.typeName;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BType) {
            BType other = (BType)obj;
            if (!this.typeName.equals(other.getName())) {
                return false;
            }
            Module thisModule = this.pkg;
            Module otherModule = other.pkg;
            if (thisModule == null) {
                return otherModule == null;
            }
            if (otherModule == null) {
                return false;
            }
            if (this.hasAllNullConstituents(thisModule)) {
                return this.hasAllNullConstituents(otherModule);
            }
            if (this.hasAllNullConstituents(otherModule)) {
                return false;
            }
            if (thisModule.getMajorVersion() == null || otherModule.getMajorVersion() == null) {
                return thisModule.getOrg().equals(otherModule.getOrg()) && thisModule.getName().equals(otherModule.getName());
            }
            return thisModule.equals(otherModule);
        }
        return false;
    }

    @Override
    public boolean isNilable() {
        return false;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public String getName() {
        return this.typeName == null ? "" : this.typeName;
    }

    @Override
    public final String getQualifiedName() {
        String name = this.getName();
        if (name.isEmpty()) {
            return "";
        }
        return this.pkg == null ? name : this.pkg.toString() + ":" + name;
    }

    @Override
    public Module getPackage() {
        return this.pkg;
    }

    @Override
    public boolean isPublic() {
        return false;
    }

    @Override
    public boolean isNative() {
        return false;
    }

    @Override
    public boolean isAnydata() {
        return this.getTag() <= 23;
    }

    @Override
    public boolean isPureType() {
        return this.getTag() == 42 || this.isAnydata();
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public Type getImmutableType() {
        if (TypeChecker.isInherentlyImmutableType(this)) {
            return this;
        }
        throw ErrorCreator.createError(StringUtils.fromString(this.typeName + " cannot be immutable"));
    }

    @Override
    public void setImmutableType(IntersectionType immutableType) {
    }

    private boolean hasAllNullConstituents(Module module) {
        return module.getOrg() == null && module.getName() == null && module.getMajorVersion() == null;
    }

    @Override
    public Module getPkg() {
        return this.pkg;
    }

    @Override
    public long getFlags() {
        return 0L;
    }

    @Override
    public void setCachedReferredType(Type type) {
        this.cachedReferredType = type;
    }

    @Override
    public Type getCachedReferredType() {
        return this.cachedReferredType;
    }

    @Override
    public void setCachedImpliedType(Type type) {
        this.cachedImpliedType = type;
    }

    @Override
    public Type getCachedImpliedType() {
        return this.cachedImpliedType;
    }

    @Override
    public SemType createSemType(Context cx) {
        throw new IllegalStateException("Child that are used for type checking must implement this method");
    }

    @Override
    public void updateInnerSemTypeIfNeeded(Context cx) {
        if (this.cachedSemType == null) {
            SemType ty = this.createSemType(cx);
            this.setAll(ty.all());
            this.setSome(ty.some(), ty.subTypeData());
            this.cachedSemType = ty;
        }
    }

    protected SemType getSemType(Context cx) {
        this.updateInnerSemTypeIfNeeded(cx);
        return this.cachedSemType;
    }

    @Override
    public void resetSemType() {
        this.cachedSemType = null;
    }

    public BType clone() {
        try {
            BType clone = (BType)super.clone();
            clone.cachedSemType = null;
            clone.setCachedImpliedType(null);
            clone.setCachedReferredType(null);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    protected boolean isNamedType() {
        return this.pkg != null && this.typeName != null && !this.typeName.isEmpty() && !this.typeName.contains("$anon");
    }

    @Override
    public final Boolean cachedTypeCheckResult(Context cx, CacheableTypeDescriptor other) {
        return this.typeCheckCache.cachedTypeCheckResult(other);
    }

    @Override
    public final void cacheTypeCheckResult(CacheableTypeDescriptor other, boolean result) {
        this.typeCheckCache.cacheTypeCheckResult(other, result);
    }

    @Override
    public final boolean isDependentlyTyped() {
        return this.isDependentlyTyped(new HashSet<MayBeDependentType>());
    }

    @Override
    public final boolean isDependentlyTyped(Set<MayBeDependentType> visited) {
        if (!visited.add(this)) {
            return false;
        }
        return this.isDependentlyTypedInner(visited);
    }

    protected boolean isDependentlyTypedInner(Set<MayBeDependentType> visited) {
        return false;
    }

    @Override
    public int typeId() {
        return this.typeId;
    }
}

