/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types.semtype;

import io.ballerina.runtime.api.constants.RuntimeConstants;
import io.ballerina.runtime.api.types.semtype.Context;
import io.ballerina.runtime.api.types.semtype.SubType;
import io.ballerina.runtime.internal.types.semtype.AllOrNothing;
import io.ballerina.runtime.internal.types.semtype.SubTypeData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class BIntSubType
extends SubType {
    final SubTypeData data;
    private static final BIntSubType ALL = new BIntSubType(AllOrNothing.ALL);
    private static final BIntSubType NOTHING = new BIntSubType(AllOrNothing.NOTHING);

    private BIntSubType(SubTypeData data) {
        super(data == AllOrNothing.ALL, data == AllOrNothing.NOTHING);
        this.data = data;
    }

    public static BIntSubType createIntSubType(List<Long> values) {
        long start;
        Collections.sort(values);
        ArrayList<Range> ranges = new ArrayList<Range>();
        long end = start = values.get(0).longValue();
        for (int i = 1; i < values.size(); ++i) {
            long value2 = values.get(i);
            if (value2 == end + 1L) {
                end = value2;
                continue;
            }
            ranges.add(new Range(start, end));
            start = value2;
            end = value2;
        }
        ranges.add(new Range(start, end));
        return new BIntSubType(new IntSubTypeData((Range[])ranges.toArray(Range[]::new)));
    }

    public static BIntSubType createIntSubType(long min, long max) {
        assert (min < max) : "Invalid range";
        Range range2 = new Range(min, max);
        Range[] ranges = new Range[]{range2};
        return new BIntSubType(new IntSubTypeData(ranges));
    }

    @Override
    public SubType union(SubType otherSubType) {
        BIntSubType other = (BIntSubType)otherSubType;
        if (this.data instanceof AllOrNothing) {
            if (this.data == AllOrNothing.ALL) {
                return this;
            }
            return other;
        }
        if (other.data instanceof AllOrNothing) {
            if (other.data == AllOrNothing.ALL) {
                return other;
            }
            return this;
        }
        IntSubTypeData thisData = (IntSubTypeData)this.data;
        IntSubTypeData otherData = (IntSubTypeData)other.data;
        IntSubTypeData v = thisData.union(otherData);
        Range[] resultRanges = v.ranges;
        if (resultRanges.length == 1 && resultRanges[0].min == RuntimeConstants.INT_MAX_VALUE && resultRanges[0].max == RuntimeConstants.INT_MAX_VALUE) {
            return ALL;
        }
        return new BIntSubType(v);
    }

    @Override
    public SubType intersect(SubType otherSubType) {
        BIntSubType other = (BIntSubType)otherSubType;
        if (this.data instanceof AllOrNothing) {
            if (this.data == AllOrNothing.ALL) {
                return other;
            }
            return NOTHING;
        }
        if (other.data instanceof AllOrNothing) {
            if (other.data == AllOrNothing.ALL) {
                return this;
            }
            return NOTHING;
        }
        IntSubTypeData thisData = (IntSubTypeData)this.data;
        IntSubTypeData otherData = (IntSubTypeData)other.data;
        IntSubTypeData v = thisData.intersect(otherData);
        Range[] resultRanges = v.ranges;
        if (resultRanges.length == 0) {
            return NOTHING;
        }
        return new BIntSubType(v);
    }

    @Override
    public SubType complement() {
        if (this.data == AllOrNothing.ALL) {
            return NOTHING;
        }
        if (this.data == AllOrNothing.NOTHING) {
            return ALL;
        }
        IntSubTypeData intData = (IntSubTypeData)this.data;
        return new BIntSubType(intData.complement());
    }

    @Override
    public boolean isEmpty(Context cx) {
        return this.data == AllOrNothing.NOTHING;
    }

    @Override
    public SubTypeData data() {
        return this.data;
    }

    public static boolean intSubtypeContains(SubTypeData d, long n) {
        if (!(d instanceof IntSubTypeData)) {
            return d == AllOrNothing.ALL;
        }
        IntSubTypeData intSubTypeData = (IntSubTypeData)d;
        return intSubTypeData.contains(n);
    }

    public record Range(long min, long max) {
    }

    public static final class IntSubTypeData
    implements SubTypeData {
        final Range[] ranges;

        private IntSubTypeData(Range range2) {
            this.ranges = new Range[]{range2};
        }

        private IntSubTypeData(Range[] ranges) {
            this.ranges = ranges;
        }

        public List<Long> values() {
            ArrayList<Long> values = new ArrayList<Long>();
            for (Range range2 : this.ranges) {
                for (long i = range2.min; i <= range2.max; ++i) {
                    values.add(i);
                }
            }
            return values;
        }

        public long max() {
            return this.ranges[this.ranges.length - 1].max;
        }

        boolean isRangeOverlap(Range range2) {
            IntSubTypeData subTypeData = this.intersect(new IntSubTypeData(range2));
            return subTypeData.ranges.length != 0;
        }

        private boolean contains(long n) {
            for (Range r : this.ranges) {
                if (r.min > n || n > r.max) continue;
                return true;
            }
            return false;
        }

        private IntSubTypeData union(IntSubTypeData other) {
            ArrayList<Range> result = new ArrayList<Range>();
            int i1 = 0;
            int i2 = 0;
            Range[] v1 = this.ranges;
            Range[] v2 = other.ranges;
            int len1 = this.ranges.length;
            int len2 = other.ranges.length;
            while (true) {
                if (i1 >= len1) {
                    if (i2 >= len2) break;
                    IntSubTypeData.rangeUnionPush(result, v2[i2]);
                    ++i2;
                    continue;
                }
                if (i2 >= len2) {
                    IntSubTypeData.rangeUnionPush(result, v1[i1]);
                    ++i1;
                    continue;
                }
                Range r1 = v1[i1];
                Range r2 = v2[i2];
                RangeOpResult combined = IntSubTypeData.rangeUnion(r1, r2);
                switch (combined.tag.ordinal()) {
                    case 1: {
                        IntSubTypeData.rangeUnionPush(result, combined.range);
                        ++i1;
                        ++i2;
                        break;
                    }
                    case 0: {
                        IntSubTypeData.rangeUnionPush(result, r1);
                        ++i1;
                        break;
                    }
                    case 2: {
                        IntSubTypeData.rangeUnionPush(result, r2);
                        ++i2;
                    }
                }
            }
            return new IntSubTypeData((Range[])result.toArray(Range[]::new));
        }

        IntSubTypeData intersect(IntSubTypeData other) {
            ArrayList<Range> result = new ArrayList<Range>();
            int i1 = 0;
            int i2 = 0;
            Range[] v1 = this.ranges;
            Range[] v2 = other.ranges;
            int len1 = this.ranges.length;
            int len2 = other.ranges.length;
            while (i1 < len1 && i2 < len2) {
                Range r1 = v1[i1];
                Range r2 = v2[i2];
                RangeOpResult combined = IntSubTypeData.rangeIntersect(r1, r2);
                switch (combined.tag.ordinal()) {
                    case 1: {
                        IntSubTypeData.rangeUnionPush(result, combined.range);
                        ++i1;
                        ++i2;
                        break;
                    }
                    case 0: {
                        ++i1;
                        break;
                    }
                    case 2: {
                        ++i2;
                    }
                }
            }
            return new IntSubTypeData((Range[])result.toArray(Range[]::new));
        }

        IntSubTypeData complement() {
            ArrayList<Range> result = new ArrayList<Range>();
            Range[] v = this.ranges;
            int len = v.length;
            long min = v[0].min;
            if (min > RuntimeConstants.INT_MIN_VALUE) {
                result.add(new Range(RuntimeConstants.INT_MIN_VALUE, min - 1L));
            }
            for (int i = 1; i < len; ++i) {
                result.add(new Range(v[i - 1].max + 1L, v[i].min - 1L));
            }
            long max = v[v.length - 1].max;
            if (max < RuntimeConstants.INT_MAX_VALUE) {
                result.add(new Range(max + 1L, RuntimeConstants.INT_MAX_VALUE));
            }
            return new IntSubTypeData((Range[])result.toArray(Range[]::new));
        }

        private static void rangeUnionPush(List<Range> ranges, Range next2) {
            int lastIndex = ranges.size() - 1;
            if (lastIndex < 0) {
                ranges.add(next2);
                return;
            }
            RangeOpResult result = IntSubTypeData.rangeUnion(ranges.get(lastIndex), next2);
            if (result.tag == RangeOpResultTag.OVERLAP) {
                ranges.set(lastIndex, result.range);
            } else {
                ranges.add(next2);
            }
        }

        private static RangeOpResult rangeIntersect(Range r1, Range r2) {
            if (r1.max < r2.min) {
                return new RangeOpResult(RangeOpResultTag.BEFORE, null);
            }
            if (r2.max < r1.min) {
                return new RangeOpResult(RangeOpResultTag.AFTER, null);
            }
            return new RangeOpResult(RangeOpResultTag.OVERLAP, new Range(Math.max(r1.min, r2.min), Math.min(r1.max, r2.max)));
        }

        private static RangeOpResult rangeUnion(Range r1, Range r2) {
            if (r1.max < r2.min && r1.max + 1L != r2.min) {
                return new RangeOpResult(RangeOpResultTag.BEFORE, null);
            }
            if (r2.max < r1.min && r1.max + 1L != r2.min) {
                return new RangeOpResult(RangeOpResultTag.AFTER, null);
            }
            return new RangeOpResult(RangeOpResultTag.OVERLAP, new Range(Math.min(r1.min, r2.min), Math.max(r1.max, r2.max)));
        }

        record RangeOpResult(RangeOpResultTag tag, Range range) {
        }

        static enum RangeOpResultTag {
            BEFORE,
            OVERLAP,
            AFTER;

        }
    }
}

