/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types.semtype;

import io.ballerina.runtime.api.types.semtype.Definition;
import io.ballerina.runtime.api.types.semtype.Env;
import io.ballerina.runtime.api.types.semtype.SemType;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

public class DefinitionContainer<E extends Definition> {
    private final AtomicReference<E> definition = new AtomicReference();

    public boolean isDefinitionReady() {
        return this.definition.get() != null;
    }

    public SemType getSemType(Env env) {
        return ((Definition)this.definition.get()).getSemType(env);
    }

    public DefinitionUpdateResult<E> trySetDefinition(Supplier<E> supplier) {
        if (this.isDefinitionReady()) {
            return new DefinitionUpdateResult<Definition>((Definition)this.definition.get(), false);
        }
        boolean updated = this.definition.compareAndSet(null, (Definition)supplier.get());
        return new DefinitionUpdateResult<Definition>((Definition)this.definition.get(), updated);
    }

    public void clear() {
        this.definition.set(null);
    }

    public record DefinitionUpdateResult<E>(E definition, boolean updated) {
    }
}

