/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.utils;

import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BString;

public final class FloatUtils {
    private FloatUtils() {
    }

    public static BString getBStringIfInfiniteOrNaN(double x) {
        if (Double.isInfinite(x) || Double.isNaN(x)) {
            return StringUtils.fromString(StringUtils.getStringValue(x));
        }
        return null;
    }

    public static boolean checkFractionDigitsWithinRange(long noOfFractionDigits) {
        return noOfFractionDigits > Integer.MAX_VALUE || noOfFractionDigits * (long)Long.bitCount(noOfFractionDigits) > Integer.MAX_VALUE;
    }
}

