/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.utils;

import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.types.MethodType;
import io.ballerina.runtime.api.types.ObjectType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BLink;
import io.ballerina.runtime.api.values.BRefValue;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BValue;
import io.ballerina.runtime.internal.TypeChecker;
import io.ballerina.runtime.internal.regexp.RegExpFactory;
import io.ballerina.runtime.internal.scheduling.Scheduler;
import io.ballerina.runtime.internal.utils.BalStringUtils;
import io.ballerina.runtime.internal.utils.CycleUtils;
import io.ballerina.runtime.internal.values.AbstractObjectValue;
import io.ballerina.runtime.internal.values.ArrayValue;
import io.ballerina.runtime.internal.values.DecimalValue;
import io.ballerina.runtime.internal.values.MapValueImpl;
import io.ballerina.runtime.internal.values.ObjectValue;

public final class StringUtils {
    public static final String STR_CYCLE = "...";
    public static final String TO_STRING = "toString";

    private StringUtils() {
    }

    public static String getStringVal(Object value2, BLink parent) {
        if (value2 == null) {
            return "";
        }
        Type type = TypeUtils.getImpliedType(TypeChecker.getType(value2));
        if (type.getTag() == 5) {
            return ((BString)value2).getValue();
        }
        if (type.getTag() < 14) {
            return String.valueOf(value2);
        }
        CycleUtils.Node node = new CycleUtils.Node(value2, parent);
        if (node.hasCyclesSoFar()) {
            return STR_CYCLE;
        }
        if (type.getTag() == 27 || type.getTag() == 24) {
            MapValueImpl mapValue = (MapValueImpl)value2;
            return mapValue.stringValue(parent);
        }
        if (type.getTag() == 32 || type.getTag() == 44) {
            ArrayValue arrayValue = (ArrayValue)value2;
            return arrayValue.stringValue(parent);
        }
        if (type.getTag() == 17) {
            return ((BRefValue)value2).informalStringValue(parent);
        }
        if (type.getTag() == 47) {
            ObjectValue objectValue = (ObjectValue)value2;
            ObjectType objectType = (ObjectType)TypeUtils.getImpliedType(objectValue.getType());
            for (MethodType func : objectType.getMethods()) {
                if (!func.getName().equals(TO_STRING) || func.getParameters().length != 0 || func.getType().getReturnType().getTag() != 5) continue;
                return objectValue.call(Scheduler.getStrand(), TO_STRING, new Object[0]).toString();
            }
        }
        BValue bValue = (BValue)value2;
        return bValue.stringValue(parent);
    }

    public static String getExpressionStringVal(Object value2, BLink parent) {
        if (value2 == null) {
            return "()";
        }
        Type type = TypeUtils.getImpliedType(TypeChecker.getType(value2));
        if (type.getTag() == 5) {
            return "\"" + ((BString)value2).getValue() + "\"";
        }
        if (type.getTag() == 4) {
            DecimalValue decimalValue = (DecimalValue)value2;
            return decimalValue.expressionStringValue(parent);
        }
        if (type.getTag() == 3) {
            if (Double.isNaN((Double)value2)) {
                return "float:" + String.valueOf(value2);
            }
            if (Double.isInfinite((Double)value2)) {
                return "float:" + String.valueOf(value2);
            }
        }
        if (type.getTag() < 14) {
            return String.valueOf(value2);
        }
        CycleUtils.Node node = new CycleUtils.Node(value2, parent);
        if (node.hasCyclesSoFar()) {
            return "...[" + node.getIndex() + "]";
        }
        if (type.getTag() == 27 || type.getTag() == 24) {
            MapValueImpl mapValue = (MapValueImpl)value2;
            return mapValue.expressionStringValue(parent);
        }
        if (type.getTag() == 32 || type.getTag() == 44) {
            ArrayValue arrayValue = (ArrayValue)value2;
            return arrayValue.expressionStringValue(parent);
        }
        if (type.getTag() == 17) {
            return ((BRefValue)value2).expressionStringValue(parent);
        }
        if (type.getTag() == 47) {
            AbstractObjectValue objectValue = (AbstractObjectValue)value2;
            ObjectType objectType = (ObjectType)TypeUtils.getImpliedType(objectValue.getType());
            for (MethodType func : objectType.getMethods()) {
                if (!func.getName().equals(TO_STRING) || func.getParameters().length != 0 || func.getType().getReturnType().getTag() != 5) continue;
                return "object " + objectValue.call(Scheduler.getStrand(), TO_STRING, new Object[0]).toString();
            }
        }
        BRefValue refValue = (BRefValue)value2;
        return refValue.expressionStringValue(parent);
    }

    public static Object parseExpressionStringVal(String value2, BLink parent) throws BError {
        String exprValue = value2.trim();
        int endIndex = exprValue.length() - 1;
        if (exprValue.equals("()")) {
            return null;
        }
        if (exprValue.startsWith("\"") && exprValue.endsWith("\"")) {
            return io.ballerina.runtime.api.utils.StringUtils.fromString(exprValue.substring(1, endIndex));
        }
        if (exprValue.matches("[+-]?[0-9][0-9]*")) {
            return Long.parseLong(exprValue);
        }
        if (exprValue.equals("float:Infinity") || exprValue.equals("float:NaN")) {
            return Double.parseDouble(exprValue.substring(6));
        }
        if (exprValue.matches("[+-]?[0-9]+([.][0-9]+)?([Ee][+-]?[0-9]+)?")) {
            return Double.parseDouble(exprValue);
        }
        if (exprValue.matches("[+-]?[0-9]+(.[0-9]+)?([Ee][+-]?[0-9]+)?[d]")) {
            return new DecimalValue(exprValue.substring(0, endIndex));
        }
        if (exprValue.equals("true") || exprValue.equals("false")) {
            return Boolean.parseBoolean(exprValue);
        }
        if (exprValue.startsWith("[") && exprValue.endsWith("]")) {
            return BalStringUtils.parseArrayExpressionStringValue(exprValue, parent);
        }
        if (exprValue.startsWith("{") && exprValue.endsWith("}")) {
            return BalStringUtils.parseMapExpressionStringValue(exprValue, parent);
        }
        if (exprValue.startsWith("table key")) {
            return BalStringUtils.parseTableExpressionStringValue(exprValue, parent);
        }
        if (exprValue.startsWith("xml")) {
            String xml2 = exprValue.substring(exprValue.indexOf(96) + 1, exprValue.lastIndexOf(96)).trim();
            return BalStringUtils.parseXmlExpressionStringValue(xml2);
        }
        if (exprValue.startsWith("re")) {
            String regexp2 = exprValue.substring(exprValue.indexOf(96) + 1, exprValue.lastIndexOf(96)).trim();
            return RegExpFactory.parse(regexp2);
        }
        if (exprValue.startsWith(STR_CYCLE)) {
            return BalStringUtils.parseCycleDetectedExpressionStringValue(exprValue, parent);
        }
        throw ErrorCreator.createError(io.ballerina.runtime.api.utils.StringUtils.fromString("invalid expression style string value"));
    }
}

