/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.utils;

import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BIterator;
import io.ballerina.runtime.api.values.BRefValue;
import io.ballerina.runtime.internal.TypeChecker;
import io.ballerina.runtime.internal.errors.ErrorCodes;
import io.ballerina.runtime.internal.errors.ErrorHelper;
import io.ballerina.runtime.internal.errors.ErrorReasons;
import io.ballerina.runtime.internal.utils.CycleUtils;
import io.ballerina.runtime.internal.values.ArrayValue;
import io.ballerina.runtime.internal.values.MapValue;
import io.ballerina.runtime.internal.values.RegExpValue;
import io.ballerina.runtime.internal.values.TableValue;
import java.util.Map;

public final class TableUtils {
    private TableUtils() {
    }

    public static Long hash(Object obj, CycleUtils.Node parent) {
        long result = 0L;
        if (obj == null) {
            return 0L;
        }
        if (obj instanceof BRefValue) {
            BRefValue refValue = (BRefValue)obj;
            CycleUtils.Node node = new CycleUtils.Node(obj, parent);
            if (node.hasCyclesSoFar()) {
                throw ErrorCreator.createError(ErrorReasons.TABLE_KEY_CYCLIC_VALUE_REFERENCE_ERROR, ErrorHelper.getErrorDetails(ErrorCodes.CYCLIC_VALUE_REFERENCE, TypeChecker.getType(obj)));
            }
            Type refType = TypeUtils.getImpliedType(refValue.getType());
            if (refType.getTag() == 27 || refType.getTag() == 24) {
                MapValue mapValue = (MapValue)refValue;
                for (Map.Entry entry : mapValue.entrySet()) {
                    result = 31L * result + TableUtils.hash(entry.getKey(), node) + (entry.getValue() == null ? 0L : TableUtils.hash(entry.getValue(), node));
                }
                return result;
            }
            if (refType.getTag() == 32 || refType.getTag() == 44) {
                ArrayValue arrayValue = (ArrayValue)refValue;
                BIterator arrayIterator = arrayValue.getIterator();
                while (arrayIterator.hasNext()) {
                    result = 31L * result + TableUtils.hash(arrayIterator.next(), node);
                }
                return result;
            }
            if (refType.getTag() == 16 || refType.getTag() == 18 || refType.getTag() == 21 || refType.getTag() == 40 || refType.getTag() == 20 || refType.getTag() == 19 || refType.getTag() == 38) {
                return refValue.toString().hashCode();
            }
            if (refType.getTag() == 17) {
                TableValue tableValue = (TableValue)refValue;
                BIterator tableIterator = tableValue.getIterator();
                while (tableIterator.hasNext()) {
                    result = 31L * result + TableUtils.hash(tableIterator.next(), node);
                }
                return result;
            }
            if (refValue instanceof RegExpValue) {
                return refValue.toString().hashCode();
            }
            return obj.hashCode();
        }
        if (obj instanceof Long) {
            Long l = (Long)obj;
            return l;
        }
        return obj.hashCode();
    }

    public static void handleTableStore(TableValue<Object, Object> tableValue, Object key, Object value2) {
        tableValue.put(key, value2);
    }
}

