/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.utils;

import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.TypeTags;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.internal.TypeChecker;
import io.ballerina.runtime.internal.utils.ErrorUtils;
import io.ballerina.runtime.internal.values.DecimalValue;
import io.ballerina.runtime.internal.values.DecimalValueKind;
import io.ballerina.runtime.internal.values.TupleValueImpl;
import java.util.PrimitiveIterator;

public final class ValueComparisonUtils {
    private ValueComparisonUtils() {
    }

    public static boolean compareValueLessThan(Object lhsValue, Object rhsValue) {
        try {
            return ValueComparisonUtils.compareValues(lhsValue, rhsValue) < 0;
        }
        catch (BError error2) {
            return false;
        }
    }

    public static boolean compareValueLessThanOrEqual(Object lhsValue, Object rhsValue) {
        try {
            return ValueComparisonUtils.compareValues(lhsValue, rhsValue) <= 0;
        }
        catch (BError error2) {
            return false;
        }
    }

    public static boolean compareValueGreaterThan(Object lhsValue, Object rhsValue) {
        try {
            return ValueComparisonUtils.compareValues(lhsValue, rhsValue) > 0;
        }
        catch (BError error2) {
            return false;
        }
    }

    public static boolean compareValueGreaterThanOrEqual(Object lhsValue, Object rhsValue) {
        try {
            return ValueComparisonUtils.compareValues(lhsValue, rhsValue) >= 0;
        }
        catch (BError error2) {
            return false;
        }
    }

    public static boolean compareValueLessThan(double lhsValue, double rhsValue) {
        try {
            return ValueComparisonUtils.compareFloatValues(lhsValue, rhsValue) < 0;
        }
        catch (BError error2) {
            return false;
        }
    }

    public static boolean compareValueLessThanOrEqual(double lhsValue, double rhsValue) {
        try {
            return ValueComparisonUtils.compareFloatValues(lhsValue, rhsValue) <= 0;
        }
        catch (BError error2) {
            return false;
        }
    }

    public static boolean compareValueGreaterThan(double lhsValue, double rhsValue) {
        try {
            return ValueComparisonUtils.compareFloatValues(lhsValue, rhsValue) > 0;
        }
        catch (BError error2) {
            return false;
        }
    }

    public static boolean compareValueGreaterThanOrEqual(double lhsValue, double rhsValue) {
        try {
            return ValueComparisonUtils.compareFloatValues(lhsValue, rhsValue) >= 0;
        }
        catch (BError error2) {
            return false;
        }
    }

    private static int compareValues(Object lhsValue, Object rhsValue) {
        return ValueComparisonUtils.compareValues(lhsValue, rhsValue, "");
    }

    private static int compareFloatValues(double lhsValue, double rhsValue) {
        return ValueComparisonUtils.compareFloatValues(lhsValue, rhsValue, true, true);
    }

    public static int compareValues(Object lhsValue, Object rhsValue, String direction) {
        int lhsTypeTag = TypeUtils.getImpliedType(TypeChecker.getType(lhsValue)).getTag();
        int rhsTypeTag = TypeUtils.getImpliedType(TypeChecker.getType(rhsValue)).getTag();
        boolean inRelationalExpr = false;
        if (direction.isEmpty()) {
            inRelationalExpr = true;
        }
        boolean isAscending = direction.equals("ascending");
        if (lhsValue == null) {
            if (rhsValue == null) {
                return 0;
            }
            if (inRelationalExpr) {
                throw ErrorUtils.createUnorderedTypesError(PredefinedTypes.TYPE_NULL, rhsValue);
            }
            if (isAscending) {
                return 1;
            }
            return -1;
        }
        if (rhsValue == null) {
            if (inRelationalExpr) {
                throw ErrorUtils.createUnorderedTypesError(lhsValue, PredefinedTypes.TYPE_NULL);
            }
            if (isAscending) {
                return -1;
            }
            return 1;
        }
        if (TypeTags.isStringTypeTag(lhsTypeTag) && TypeTags.isStringTypeTag(rhsTypeTag)) {
            return ValueComparisonUtils.codePointCompare(lhsValue.toString(), rhsValue.toString());
        }
        if (lhsTypeTag == rhsTypeTag) {
            switch (lhsTypeTag) {
                case 6: {
                    return Boolean.compare((Boolean)lhsValue, (Boolean)rhsValue);
                }
                case 2: {
                    return Integer.compare((Integer)lhsValue, (Integer)rhsValue);
                }
                case 3: {
                    return ValueComparisonUtils.compareFloatValues((Double)lhsValue, (Double)rhsValue, inRelationalExpr, isAscending);
                }
                case 4: {
                    if (TypeChecker.checkDecimalEqual((DecimalValue)lhsValue, (DecimalValue)rhsValue)) {
                        return 0;
                    }
                    if (ValueComparisonUtils.checkDecimalGreaterThan((DecimalValue)lhsValue, (DecimalValue)rhsValue)) {
                        return 1;
                    }
                    return -1;
                }
            }
        }
        if (2 == lhsTypeTag && TypeTags.isIntegerTypeTag(rhsTypeTag)) {
            return Long.compare(((Integer)lhsValue).intValue(), (Long)rhsValue);
        }
        if (TypeTags.isIntegerTypeTag(lhsTypeTag) && 2 == rhsTypeTag) {
            return Long.compare((Long)lhsValue, ((Integer)rhsValue).intValue());
        }
        if (TypeTags.isIntegerTypeTag(lhsTypeTag) && TypeTags.isIntegerTypeTag(rhsTypeTag)) {
            return Long.compare((Long)lhsValue, (Long)rhsValue);
        }
        if (!(lhsTypeTag != 32 && lhsTypeTag != 44 || rhsTypeTag != 32 && rhsTypeTag != 44)) {
            return ValueComparisonUtils.compareArrayValues(lhsValue, rhsValue, lhsTypeTag, rhsTypeTag, direction);
        }
        throw ErrorUtils.createOperationNotSupportedError(TypeChecker.getType(lhsValue), TypeChecker.getType(rhsValue));
    }

    private static int codePointCompare(String str1, String str2) {
        PrimitiveIterator.OfInt iterator1 = str1.codePoints().iterator();
        PrimitiveIterator.OfInt iterator2 = str2.codePoints().iterator();
        while (iterator1.hasNext()) {
            Integer codePoint2;
            if (!iterator2.hasNext()) {
                return 1;
            }
            Integer codePoint1 = iterator1.next();
            int cmp = codePoint1.compareTo(codePoint2 = iterator2.next());
            if (cmp == 0) continue;
            return cmp;
        }
        if (iterator2.hasNext()) {
            return -1;
        }
        return 0;
    }

    private static int compareFloatValues(double lhsValue, double rhsValue, boolean inRelationalExpr, boolean isAscending) {
        if (Double.isNaN(lhsValue)) {
            if (inRelationalExpr) {
                throw ErrorUtils.createUnorderedTypesError(lhsValue, rhsValue);
            }
            if (Double.isNaN(rhsValue)) {
                return 0;
            }
            if (isAscending) {
                return 1;
            }
            return -1;
        }
        if (Double.isNaN(rhsValue)) {
            if (inRelationalExpr) {
                throw ErrorUtils.createUnorderedTypesError(lhsValue, rhsValue);
            }
            if (isAscending) {
                return -1;
            }
            return 1;
        }
        if (lhsValue == 0.0 && rhsValue == 0.0) {
            return 0;
        }
        return Double.compare(lhsValue, rhsValue);
    }

    private static boolean checkDecimalGreaterThan(DecimalValue lhsValue, DecimalValue rhsValue) {
        switch (lhsValue.valueKind) {
            default: {
                throw new MatchException(null, null);
            }
            case ZERO: 
            case OTHER: 
        }
        return ValueComparisonUtils.isDecimalRealNumber(rhsValue) && lhsValue.decimalValue().compareTo(rhsValue.decimalValue()) > 0;
    }

    private static boolean isDecimalRealNumber(DecimalValue decimalValue) {
        return decimalValue.valueKind == DecimalValueKind.ZERO || decimalValue.valueKind == DecimalValueKind.OTHER;
    }

    private static int compareArrayValues(Object lhsValue, Object rhsValue, int lhsTypeTag, int rhsTypeTag, String direction) {
        int lengthVal1 = lhsTypeTag == 32 ? ((BArray)lhsValue).size() : ((TupleValueImpl)lhsValue).size();
        int lengthVal2 = rhsTypeTag == 32 ? ((BArray)rhsValue).size() : ((TupleValueImpl)rhsValue).size();
        if (lengthVal1 == 0) {
            if (lengthVal2 == 0) {
                return 0;
            }
            return -1;
        }
        if (lengthVal2 == 0) {
            return 1;
        }
        int len = Math.min(lengthVal1, lengthVal2);
        int c = 0;
        for (int i = 0; i < len; ++i) {
            c = lhsTypeTag == 32 ? (rhsTypeTag == 32 ? ValueComparisonUtils.compareValues(((BArray)lhsValue).get(i), ((BArray)rhsValue).get(i), direction) : ValueComparisonUtils.compareValues(((BArray)lhsValue).get(i), ((TupleValueImpl)rhsValue).get(i), direction)) : (rhsTypeTag == 32 ? ValueComparisonUtils.compareValues(((TupleValueImpl)lhsValue).get(i), ((BArray)rhsValue).get(i), direction) : ValueComparisonUtils.compareValues(((TupleValueImpl)lhsValue).get(i), ((TupleValueImpl)rhsValue).get(i), direction));
            if (c != 0) break;
            if (i != len - 1) continue;
            return Long.compare(lengthVal1, lengthVal2);
        }
        return c;
    }
}

