/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.utils;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.flags.SymbolFlags;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BFunctionPointer;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.runtime.api.values.BValue;
import io.ballerina.runtime.api.values.BXml;
import io.ballerina.runtime.internal.TypeConverter;
import io.ballerina.runtime.internal.scheduling.Scheduler;
import io.ballerina.runtime.internal.scheduling.Strand;
import io.ballerina.runtime.internal.types.BRecordType;
import io.ballerina.runtime.internal.values.MapValue;
import io.ballerina.runtime.internal.values.MapValueImpl;
import io.ballerina.runtime.internal.values.TypedescValueImpl;
import io.ballerina.runtime.internal.values.ValueCreator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ValueUtils {
    public static BMap<BString, Object> createRecordValue(Module packageId, String recordTypeName) {
        return ValueUtils.createRecordValue(packageId, recordTypeName, new HashSet<String>());
    }

    public static BMap<BString, Object> createRecordValueWithDefaultValues(Module packageId, String recordTypeName, List<String> notProvidedFields) {
        ValueCreator valueCreator = ValueCreator.getValueCreator(ValueCreator.getLookupKey(packageId, false));
        try {
            return ValueUtils.getPopulatedRecordValue(valueCreator, recordTypeName, notProvidedFields);
        }
        catch (BError e) {
            String testLookupKey = ValueCreator.getLookupKey(packageId, true);
            if (ValueCreator.containsValueCreator(testLookupKey)) {
                return ValueUtils.getPopulatedRecordValue(ValueCreator.getValueCreator(testLookupKey), recordTypeName, notProvidedFields);
            }
            throw e;
        }
    }

    public static BMap<BString, Object> createRecordValue(Module packageId, String recordTypeName, Set<String> providedFields) {
        ValueCreator valueCreator = ValueCreator.getValueCreator(ValueCreator.getLookupKey(packageId, false));
        try {
            return ValueUtils.getPopulatedRecordValue(valueCreator, recordTypeName, providedFields);
        }
        catch (BError e) {
            String testLookupKey = ValueCreator.getLookupKey(packageId, true);
            if (ValueCreator.containsValueCreator(testLookupKey)) {
                return ValueUtils.getPopulatedRecordValue(ValueCreator.getValueCreator(testLookupKey), recordTypeName, providedFields);
            }
            throw e;
        }
    }

    private static BMap<BString, Object> getPopulatedRecordValue(ValueCreator valueCreator, String recordTypeName, Set<String> providedFields) {
        MapValue<BString, Object> recordValue = valueCreator.createRecordValue(recordTypeName);
        BRecordType type = (BRecordType)TypeUtils.getImpliedType(recordValue.getType());
        return ValueUtils.populateDefaultValues(valueCreator, recordValue, type, providedFields);
    }

    private static BMap<BString, Object> getPopulatedRecordValue(ValueCreator valueCreator, String recordTypeName, List<String> notProvidedFields) {
        MapValue<BString, Object> recordValue = valueCreator.createRecordValue(recordTypeName);
        BRecordType type = (BRecordType)TypeUtils.getImpliedType(recordValue.getType());
        return ValueUtils.populateDefaultValues(valueCreator, recordValue, type, notProvidedFields);
    }

    public static BMap<BString, Object> populateDefaultValues(ValueCreator valueCreator, BMap<BString, Object> recordValue, BRecordType type, Set<String> providedFields) {
        Map<String, BFunctionPointer> defaultValues = type.getDefaultValues();
        if (defaultValues.isEmpty()) {
            return recordValue;
        }
        defaultValues = ValueUtils.getNonProvidedDefaultValues(defaultValues, providedFields);
        return ValueUtils.populateRecordDefaultValues(valueCreator, recordValue, defaultValues);
    }

    public static BMap<BString, Object> populateDefaultValues(ValueCreator valueCreator, BMap<BString, Object> recordValue, BRecordType type, List<String> notProvidedFieldNames) {
        Map<String, BFunctionPointer> defaultValues = type.getDefaultValues();
        if (defaultValues.isEmpty()) {
            return recordValue;
        }
        defaultValues = ValueUtils.getNonProvidedDefaultValues(defaultValues, notProvidedFieldNames);
        return ValueUtils.populateRecordDefaultValues(valueCreator, recordValue, defaultValues);
    }

    private static BMap<BString, Object> populateRecordDefaultValues(ValueCreator valueCreator, BMap<BString, Object> recordValue, Map<String, BFunctionPointer> defaultValues) {
        for (Map.Entry<String, BFunctionPointer> field : defaultValues.entrySet()) {
            recordValue.populateInitialValue(StringUtils.fromString(field.getKey()), field.getValue().call(valueCreator.runtime, new Object[0]));
        }
        return recordValue;
    }

    private static Map<String, BFunctionPointer> getNonProvidedDefaultValues(Map<String, BFunctionPointer> defaultValues, Set<String> providedFields) {
        HashMap<String, BFunctionPointer> result = new HashMap<String, BFunctionPointer>();
        for (Map.Entry<String, BFunctionPointer> entry : defaultValues.entrySet()) {
            if (providedFields.contains(entry.getKey())) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    private static Map<String, BFunctionPointer> getNonProvidedDefaultValues(Map<String, BFunctionPointer> defaultValues, List<String> notProvidedFieldNames) {
        HashMap<String, BFunctionPointer> result = new HashMap<String, BFunctionPointer>();
        for (String notProvidedFieldName : notProvidedFieldNames) {
            result.put(notProvidedFieldName, defaultValues.get(notProvidedFieldName));
        }
        return result;
    }

    public static BMap<BString, Object> createRecordValue(Module packageId, String recordTypeName, Map<String, Object> valueMap) {
        BMap<BString, Object> recordValue = ValueUtils.createRecordValue(packageId, recordTypeName, valueMap.keySet());
        for (Map.Entry<String, Object> fieldEntry : valueMap.entrySet()) {
            Object val2 = fieldEntry.getValue();
            if (val2 instanceof String) {
                String s = (String)val2;
                val2 = StringUtils.fromString(s);
            }
            recordValue.populateInitialValue(StringUtils.fromString(fieldEntry.getKey()), val2);
        }
        return recordValue;
    }

    public static BMap<BString, Object> createRecordValue(Module packageId, String recordTypeName, BMap<BString, Object> valueMap) {
        HashSet<String> keySet = new HashSet<String>();
        for (BString key : valueMap.getKeys()) {
            keySet.add(key.getValue());
        }
        BMap<BString, Object> recordValue = ValueUtils.createRecordValue(packageId, recordTypeName, keySet);
        for (Map.Entry<BString, Object> fieldEntry : valueMap.entrySet()) {
            recordValue.populateInitialValue(fieldEntry.getKey(), fieldEntry.getValue());
        }
        return recordValue;
    }

    public static BMap<BString, Object> createRecordValue(BMap<BString, Object> recordValue, Object ... values) {
        BRecordType recordType = (BRecordType)recordValue.getType();
        MapValueImpl<BString, Object> mapValue = new MapValueImpl<BString, Object>(recordType);
        int i = 0;
        for (Map.Entry<String, Field> fieldEntry : recordType.getFields().entrySet()) {
            Object value2 = values[i++];
            if (SymbolFlags.isFlagOn(fieldEntry.getValue().getFlags(), 4096L) && value2 == null) continue;
            mapValue.put(StringUtils.fromString(fieldEntry.getKey()), value2 instanceof String ? StringUtils.fromString((String)value2) : value2);
        }
        return mapValue;
    }

    public static BObject createObjectValue(Module packageId, String objectTypeName, Object ... fieldValues) {
        Strand currentStrand = Scheduler.getStrand();
        Object[] fields = new Object[fieldValues.length];
        int j = 0;
        for (int i = 0; i < fieldValues.length; ++i) {
            fields[j++] = fieldValues[i];
        }
        return ValueUtils.createObjectValue(currentStrand, packageId, objectTypeName, fields);
    }

    public static BObject createObjectValue(Strand currentStrand, Module packageId, String objectTypeName, Object[] fieldValues) {
        ValueCreator valueCreator = ValueCreator.getValueCreator(ValueCreator.getLookupKey(packageId, false));
        try {
            return valueCreator.createObjectValue(objectTypeName, currentStrand, fieldValues);
        }
        catch (BError e) {
            String testLookupKey = ValueCreator.getLookupKey(packageId, true);
            if (ValueCreator.containsValueCreator(testLookupKey)) {
                valueCreator = ValueCreator.getValueCreator(testLookupKey);
                return valueCreator.createObjectValue(objectTypeName, currentStrand, fieldValues);
            }
            throw e;
        }
    }

    private ValueUtils() {
    }

    public static BXml createReadOnlyXmlValue(String value2) {
        BXml xml2 = TypeConverter.stringToXml(value2);
        xml2.freezeDirect();
        return xml2;
    }

    public static BTypedesc createSingletonTypedesc(BValue value2) {
        return io.ballerina.runtime.api.creators.ValueCreator.createTypedescValue(TypeCreator.createFiniteType(null, Set.of(value2), 0));
    }

    public static BTypedesc getTypedescValue(Type type, BValue value2) {
        if (type.isReadOnly()) {
            return ValueUtils.createSingletonTypedesc(value2);
        }
        return new TypedescValueImpl(type);
    }

    public static BTypedesc getTypedescValue(boolean readOnly, BValue value2, TypedescValueImpl inherentType) {
        if (readOnly) {
            TypedescValueImpl typedesc2 = (TypedescValueImpl)ValueUtils.createSingletonTypedesc(value2);
            typedesc2.annotations = inherentType.annotations;
            return typedesc2;
        }
        return inherentType;
    }
}

