/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.values;

import io.ballerina.identifier.Utils;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.TypeId;
import io.ballerina.runtime.api.types.semtype.BasicTypeBitSet;
import io.ballerina.runtime.api.types.semtype.Builder;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BLink;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BRefValue;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.runtime.api.values.BValue;
import io.ballerina.runtime.internal.TypeChecker;
import io.ballerina.runtime.internal.types.BErrorType;
import io.ballerina.runtime.internal.types.BTypeIdSet;
import io.ballerina.runtime.internal.utils.CycleUtils;
import io.ballerina.runtime.internal.utils.StringUtils;
import io.ballerina.runtime.internal.values.MapValue;
import io.ballerina.runtime.internal.values.MapValueImpl;
import io.ballerina.runtime.internal.values.RefValue;
import io.ballerina.runtime.internal.values.StringValue;
import io.ballerina.runtime.internal.values.TypedescValueImpl;
import io.ballerina.runtime.internal.values.ValuePair;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;

public class ErrorValue
extends BError
implements RefValue {
    private static final BasicTypeBitSet BASIC_TYPE = Builder.getErrorType();
    private static final PrintStream outStream = System.err;
    private final Type type;
    private BTypedesc typedesc;
    private final BString message;
    private final BError cause;
    private final BMap<BString, Object> details;
    private static final String GENERATED_CLASS_TEXTS_REGEX = "\\$value\\$|\\$split\\$\\d|lambdas.\\$_generated\\d*";
    private static final String GENERATE_PKG_INIT = "___init_";
    private static final String GENERATE_PKG_START = "___start_";
    private static final String GENERATE_PKG_STOP = "___stop_";
    private static final String INIT_FUNCTION_SUFFIX = "..<init>";
    private static final String START_FUNCTION_SUFFIX = ".<start>";
    private static final String STOP_FUNCTION_SUFFIX = ".<stop>";

    public ErrorValue(BString message) {
        this(new BErrorType("error", PredefinedTypes.TYPE_ERROR.getPackage(), PredefinedTypes.TYPE_DETAIL), message, null, new MapValueImpl<BString, Object>(PredefinedTypes.TYPE_ERROR_DETAIL));
    }

    public ErrorValue(BString message, BMap<BString, Object> details) {
        this(new BErrorType("error", PredefinedTypes.TYPE_ERROR.getPackage(), TypeChecker.getType(details)), message, null, details);
    }

    public ErrorValue(BString message, BError cause) {
        this(new BErrorType("error", PredefinedTypes.TYPE_ERROR.getPackage(), PredefinedTypes.TYPE_MAP), message, cause, null);
    }

    public ErrorValue(Type type, BString message, BError cause, BMap<BString, Object> details) {
        super(message);
        this.type = type;
        this.message = message;
        this.cause = cause;
        this.details = details;
    }

    public ErrorValue(Type type, BString message, BError cause, BMap<BString, Object> details, String typeIdName, Module typeIdPkg) {
        super(message);
        this.type = type;
        this.message = message;
        this.cause = cause;
        this.details = details;
        BTypeIdSet typeIdSet = new BTypeIdSet();
        typeIdSet.add(typeIdPkg, typeIdName, true);
        ((BErrorType)TypeUtils.getImpliedType(type)).setTypeIdSet(typeIdSet);
    }

    @Override
    public String stringValue(BLink parent) {
        CycleUtils.Node linkParent = new CycleUtils.Node(this, parent);
        BString errMessage = Objects.requireNonNullElse(this.message, io.ballerina.runtime.api.utils.StringUtils.fromString(""));
        if (this.isEmptyDetail()) {
            return "error" + this.getModuleNameToString() + "(" + ((StringValue)errMessage).informalStringValue(linkParent) + this.getCauseToString(linkParent) + ")";
        }
        return "error" + this.getModuleNameToString() + "(" + ((StringValue)errMessage).informalStringValue(linkParent) + this.getCauseToString(linkParent) + this.getDetailsToString(linkParent) + ")";
    }

    @Override
    public String expressionStringValue(BLink parent) {
        CycleUtils.Node linkParent = new CycleUtils.Node(this, parent);
        if (this.isEmptyDetail()) {
            return "error" + this.getModuleNameToBalString() + "(" + ((StringValue)this.message).informalStringValue(linkParent) + this.getCauseToBalString(linkParent) + ")";
        }
        return "error" + this.getModuleNameToBalString() + "(" + ((StringValue)this.message).expressionStringValue(linkParent) + this.getCauseToBalString(linkParent) + this.getDetailsToBalString(linkParent) + ")";
    }

    private String getCauseToString(BLink parent) {
        if (this.cause != null) {
            return "," + this.cause.informalStringValue(parent);
        }
        return "";
    }

    private String getDetailsToString(BLink parent) {
        StringJoiner sj = new StringJoiner(",");
        block3: for (Object key : ((MapValue)this.details).getKeys()) {
            Object value2 = ((MapValue)this.details).get(key);
            if (value2 == null) {
                sj.add(String.valueOf(key) + "=null");
                continue;
            }
            Type type = TypeChecker.getType(value2);
            switch (TypeUtils.getImpliedType(type).getTag()) {
                case 5: 
                case 16: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 38: 
                case 40: {
                    sj.add(String.valueOf(key) + "=" + ((BValue)value2).informalStringValue(parent));
                    continue block3;
                }
                default: {
                    sj.add(String.valueOf(key) + "=" + StringUtils.getStringVal(value2, parent));
                }
            }
        }
        return "," + String.valueOf(sj);
    }

    private String getModuleNameToString() {
        return this.type.getPackage().getName() == null ? "" : " " + this.type.getName() + " ";
    }

    private String getDetailsToBalString(BLink parent) {
        StringJoiner sj = new StringJoiner(",");
        for (Object key : ((MapValue)this.details).getKeys()) {
            Object value2 = ((MapValue)this.details).get(key);
            sj.add(String.valueOf(key) + "=" + StringUtils.getExpressionStringVal(value2, parent));
        }
        return "," + String.valueOf(sj);
    }

    private String getCauseToBalString(BLink parent) {
        if (this.cause != null) {
            return "," + this.cause.expressionStringValue(parent);
        }
        return "";
    }

    private String getModuleNameToBalString() {
        Type type = TypeUtils.getImpliedType(this.type);
        if (((BErrorType)type).typeIdSet == null) {
            return "";
        }
        StringJoiner sj = new StringJoiner("&");
        List<TypeId> typeIds = ((BErrorType)type).typeIdSet.getIds();
        for (TypeId typeId : typeIds) {
            String pkg = typeId.getPkg().toString();
            if (".".equals(pkg)) {
                sj.add(typeId.getName());
                continue;
            }
            sj.add("{" + pkg + "}" + typeId.getName());
        }
        return " " + String.valueOf(sj) + " ";
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public BasicTypeBitSet getBasicType() {
        return BASIC_TYPE;
    }

    @Override
    public Object copy(Map<Object, Object> refs) {
        return this;
    }

    @Override
    public Object frozenCopy(Map<Object, Object> refs) {
        return this;
    }

    @Override
    public BTypedesc getTypedesc() {
        if (this.typedesc == null) {
            this.typedesc = new TypedescValueImpl(this.type);
        }
        return this.typedesc;
    }

    @Override
    public void freezeDirect() {
    }

    @Override
    public String toString() {
        return this.stringValue(null);
    }

    @Override
    public BString getErrorMessage() {
        return this.message;
    }

    @Override
    public Object getDetails() {
        BMap<BString, Object> bMap = this.details;
        if (bMap instanceof BRefValue) {
            BMap<BString, Object> bRefValue = bMap;
            return bRefValue.frozenCopy(new HashMap<Object, Object>());
        }
        return this.details;
    }

    @Override
    public BError getCause() {
        return this.cause;
    }

    @Override
    public void printStackTrace() {
        outStream.println("error: " + this.getPrintableStackTrace());
    }

    @Override
    public void printStackTrace(PrintWriter printWriter) {
        outStream.println("error: " + this.getPrintableStackTrace());
    }

    @Override
    public StackTraceElement[] getStackTrace() {
        StackTraceElement[] stackTrace = super.getStackTrace();
        LinkedList filteredStack = new LinkedList();
        int index = 0;
        for (StackTraceElement stackFrame : stackTrace) {
            Optional<StackTraceElement> stackTraceElement = this.filterStackTraceElement(stackFrame, index++);
            stackTraceElement.ifPresent(filteredStack::add);
        }
        StackTraceElement[] filteredStackArray = new StackTraceElement[filteredStack.size()];
        return filteredStack.toArray(filteredStackArray);
    }

    @Override
    public String getPrintableStackTrace() {
        String errorMsg = this.getPrintableError();
        StringBuilder sb = new StringBuilder();
        sb.append(errorMsg);
        this.addPrintableStackTrace(sb, this, new StackTraceElement[0]);
        StackTraceElement[] enclosingTrace = this.getStackTrace();
        for (BError cause = this.getCause(); cause != null; cause = cause.getCause()) {
            sb.append("\ncause: ").append(cause.getMessage());
            this.addPrintableStackTrace(sb, cause, enclosingTrace);
            enclosingTrace = cause.getStackTrace();
        }
        return sb.toString();
    }

    private void addPrintableStackTrace(StringBuilder sb, BError error2, StackTraceElement[] enclosingTrace) {
        StackTraceElement[] stackTrace = error2.getStackTrace();
        if (stackTrace.length == 0) {
            return;
        }
        int index = stackTrace.length - 1;
        for (int n = enclosingTrace.length - 1; index >= 0 && n >= 0 && stackTrace[index].equals(enclosingTrace[n]); --index, --n) {
        }
        sb.append("\n\tat ");
        this.printStackElement(sb, stackTrace[0], "");
        for (int i = 1; i <= index; ++i) {
            this.printStackElement(sb, stackTrace[i], "\n\t   ");
        }
        int framesInCommon = stackTrace.length - 1 - index;
        if (framesInCommon != 0) {
            sb.append("\n\t   ... ").append(framesInCommon).append(" more");
        }
    }

    @Override
    public List<StackTraceElement> getCallStack() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        LinkedList<StackTraceElement> filteredStack = new LinkedList<StackTraceElement>();
        int index = 0;
        for (StackTraceElement stackFrame : stackTrace) {
            Optional<StackTraceElement> stackTraceElement = this.filterStackTraceElement(stackFrame, index++);
            stackTraceElement.ifPresent(filteredStack::add);
        }
        return filteredStack;
    }

    private void printStackElement(StringBuilder sb, StackTraceElement stackTraceElement, String tab) {
        String pkgName = Utils.decodeIdentifier(stackTraceElement.getClassName());
        String fileName = stackTraceElement.getFileName();
        fileName = fileName.replace(".bal", "");
        int index = pkgName.lastIndexOf("." + (fileName = fileName.replace("/", "-")));
        if (index != -1) {
            pkgName = pkgName.substring(0, index);
        }
        sb.append(tab);
        if (!pkgName.equals("$_init")) {
            sb.append(pkgName).append(":");
        }
        sb.append(Utils.decodeIdentifier(stackTraceElement.getMethodName()));
        sb.append("(").append(stackTraceElement.getFileName());
        sb.append(":").append(stackTraceElement.getLineNumber()).append(")");
    }

    public String getPrintableError() {
        StringJoiner joiner = new StringJoiner(" ");
        joiner.add(this.message.getValue());
        if (!this.isEmptyDetail()) {
            joiner.add(this.details.toString());
        }
        return joiner.toString();
    }

    private boolean isEmptyDetail() {
        MapValue mapValue;
        if (this.details == null) {
            return true;
        }
        BMap<BString, Object> bMap = this.details;
        return bMap instanceof MapValue && (mapValue = (MapValue)bMap).isEmpty();
    }

    private Optional<StackTraceElement> filterStackTraceElement(StackTraceElement stackFrame, int currentIndex) {
        String fileName = stackFrame.getFileName();
        int lineNo = stackFrame.getLineNumber();
        if (lineNo < 0) {
            return Optional.empty();
        }
        String className = stackFrame.getClassName();
        String methodName = stackFrame.getMethodName();
        if (className.equals("$_init")) {
            if (currentIndex == 0) {
                return Optional.empty();
            }
            switch (methodName) {
                case "___init_": {
                    methodName = INIT_FUNCTION_SUFFIX;
                    break;
                }
                case "___start_": {
                    methodName = START_FUNCTION_SUFFIX;
                    break;
                }
                case "___stop_": {
                    methodName = STOP_FUNCTION_SUFFIX;
                    break;
                }
                default: {
                    return Optional.empty();
                }
            }
            return Optional.of(new StackTraceElement(this.cleanupClassName(className), methodName, fileName, stackFrame.getLineNumber()));
        }
        if (fileName != null && !fileName.endsWith(".bal") || this.isCompilerAddedName(methodName)) {
            return Optional.empty();
        }
        return Optional.of(new StackTraceElement(this.cleanupClassName(className), methodName, fileName, stackFrame.getLineNumber()));
    }

    private String cleanupClassName(String className) {
        return className.replaceAll(GENERATED_CLASS_TEXTS_REGEX, "");
    }

    private boolean isCompilerAddedName(String name) {
        return name != null && name.startsWith("$") && name.endsWith("$");
    }

    @Override
    public boolean equals(Object o, Set<ValuePair> visitedValues) {
        if (!(o instanceof ErrorValue)) {
            return false;
        }
        ErrorValue errorValue = (ErrorValue)o;
        return TypeChecker.isEqual(this.getMessage(), errorValue.getMessage(), visitedValues) && ((MapValueImpl)this.getDetails()).equals(errorValue.getDetails(), visitedValues) && TypeChecker.isEqual(this.getCause(), errorValue.getCause(), visitedValues);
    }
}

