/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.values;

import io.ballerina.identifier.Utils;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.IntersectableReferenceType;
import io.ballerina.runtime.api.types.IntersectionType;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.ReferenceType;
import io.ballerina.runtime.api.types.SelectivelyImmutableReferenceType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BFunctionPointer;
import io.ballerina.runtime.internal.TypeChecker;
import io.ballerina.runtime.internal.errors.ErrorCodes;
import io.ballerina.runtime.internal.errors.ErrorHelper;
import io.ballerina.runtime.internal.errors.ErrorReasons;
import io.ballerina.runtime.internal.types.BArrayType;
import io.ballerina.runtime.internal.types.BField;
import io.ballerina.runtime.internal.types.BIntersectionType;
import io.ballerina.runtime.internal.types.BMapType;
import io.ballerina.runtime.internal.types.BObjectType;
import io.ballerina.runtime.internal.types.BRecordType;
import io.ballerina.runtime.internal.types.BTableType;
import io.ballerina.runtime.internal.types.BTupleType;
import io.ballerina.runtime.internal.types.BTypeReferenceType;
import io.ballerina.runtime.internal.types.BUnionType;
import io.ballerina.runtime.internal.types.BXmlType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ReadOnlyUtils {
    static void handleInvalidUpdate(String moduleName) {
        throw ErrorCreator.createError(ErrorReasons.getModulePrefixedReason(moduleName, "InvalidUpdate"), ErrorHelper.getErrorMessage(ErrorCodes.INVALID_READONLY_VALUE_UPDATE, new Object[0]));
    }

    public static Type getReadOnlyType(Type type) {
        if (type.isReadOnly()) {
            return type;
        }
        if (!TypeChecker.isSelectivelyImmutableType(type, new HashSet<Type>())) {
            throw new IllegalArgumentException(type.getName() + " cannot be a readonly type.");
        }
        return ReadOnlyUtils.setImmutableTypeAndGetEffectiveType(type);
    }

    public static Type getReadOnlyType(Type type, Set<Type> unresolvedTypes) {
        if (type.isReadOnly()) {
            return type;
        }
        if (!TypeChecker.isSelectivelyImmutableType(type, new HashSet<Type>())) {
            throw new IllegalArgumentException(type.getName() + " cannot be a readonly type.");
        }
        return ReadOnlyUtils.setImmutableTypeAndGetEffectiveType(type, unresolvedTypes);
    }

    public static Type setImmutableTypeAndGetEffectiveType(Type type) {
        Type immutableType = ReadOnlyUtils.getAvailableImmutableType(type);
        if (immutableType != null) {
            return immutableType;
        }
        return ReadOnlyUtils.setImmutableIntersectionType(type, new HashSet<Type>()).getEffectiveType();
    }

    public static Type setImmutableTypeAndGetEffectiveType(Type type, Set<Type> unresolvedTypes) {
        Type immutableType = ReadOnlyUtils.getAvailableImmutableType(type);
        if (immutableType != null) {
            return immutableType;
        }
        return ReadOnlyUtils.setImmutableIntersectionType(type, unresolvedTypes).getEffectiveType();
    }

    private static Type getAvailableImmutableType(Type type) {
        if (type.isReadOnly() || TypeChecker.isInherentlyImmutableType(type)) {
            return type;
        }
        if (type.getTag() == 53) {
            return ReadOnlyUtils.getAvailableImmutableType(((ReferenceType)type).getReferredType());
        }
        if (type.getTag() == 34 && type.isReadOnly()) {
            return ((BIntersectionType)type).getEffectiveType();
        }
        if (type.getTag() == 53) {
            return ReadOnlyUtils.getAvailableImmutableType(((ReferenceType)type).getReferredType());
        }
        IntersectionType immutableType = ((SelectivelyImmutableReferenceType)type).getImmutableType();
        if (immutableType != null) {
            return immutableType.getEffectiveType();
        }
        return null;
    }

    private static Type getImmutableType(Type type, Set<Type> unresolvedTypes) {
        if (type.isReadOnly() || TypeChecker.isInherentlyImmutableType(type)) {
            return type;
        }
        if (!unresolvedTypes.add(type)) {
            return type;
        }
        return ReadOnlyUtils.setImmutableIntersectionType(type, unresolvedTypes);
    }

    private static BIntersectionType setImmutableIntersectionType(Type type, Set<Type> unresolvedTypes) {
        IntersectionType immutableType;
        IntersectionType intersectionType = immutableType = type.getTag() == 53 ? null : ((SelectivelyImmutableReferenceType)type).getImmutableType();
        if (immutableType != null) {
            return (BIntersectionType)immutableType;
        }
        switch (type.getTag()) {
            case 20: {
                BXmlType readonlyCommentType = new BXmlType("Comment & readonly", new Module("ballerina", "lang.xml", null), 20, true);
                return ReadOnlyUtils.createAndSetImmutableIntersectionType(type, readonlyCommentType);
            }
            case 18: {
                BXmlType readonlyElementType = new BXmlType("Element & readonly", new Module("ballerina", "lang.xml", null), 18, true);
                return ReadOnlyUtils.createAndSetImmutableIntersectionType(type, readonlyElementType);
            }
            case 19: {
                BXmlType readonlyPI = new BXmlType("ProcessingInstruction & readonly", new Module("ballerina", "lang.xml", null), 19, true);
                return ReadOnlyUtils.createAndSetImmutableIntersectionType(type, readonlyPI);
            }
            case 16: {
                BXmlType origXmlType = (BXmlType)type;
                BXmlType immutableXmlType = new BXmlType("xml & readonly", ReadOnlyUtils.getImmutableType(origXmlType.constraint, unresolvedTypes), origXmlType.getPackage(), origXmlType.getTag(), true);
                return ReadOnlyUtils.createAndSetImmutableIntersectionType(origXmlType, immutableXmlType);
            }
            case 32: {
                BArrayType origArrayType = (BArrayType)type;
                BArrayType immutableArrayType = new BArrayType(ReadOnlyUtils.getImmutableType(origArrayType.getElementType(), unresolvedTypes), origArrayType.getSize(), true);
                return ReadOnlyUtils.createAndSetImmutableIntersectionType(origArrayType, immutableArrayType);
            }
            case 44: {
                BTupleType origTupleType = (BTupleType)type;
                List<Type> origTupleMemTypes = origTupleType.getTupleTypes();
                ArrayList<Type> immutableMemTypes = new ArrayList<Type>(origTupleMemTypes.size());
                for (Type origTupleMemType : origTupleMemTypes) {
                    immutableMemTypes.add(ReadOnlyUtils.getImmutableType(origTupleMemType, unresolvedTypes));
                }
                Type origTupleRestType = origTupleType.getRestType();
                BTupleType immutableTupleType = new BTupleType(immutableMemTypes, origTupleRestType == null ? null : ReadOnlyUtils.getImmutableType(origTupleRestType, unresolvedTypes), origTupleType.getTypeFlags(), origTupleType.isCyclic, true);
                return ReadOnlyUtils.createAndSetImmutableIntersectionType(origTupleType, immutableTupleType);
            }
            case 27: {
                MapType origMapType = (MapType)type;
                BMapType immutableMapType = new BMapType(ReadOnlyUtils.getImmutableType(origMapType.getConstrainedType(), unresolvedTypes), true);
                return ReadOnlyUtils.createAndSetImmutableIntersectionType(origMapType, immutableMapType);
            }
            case 24: {
                BRecordType origRecordType = (BRecordType)type;
                Map<String, Field> originalFields = origRecordType.getFields();
                HashMap<String, Field> fields = new HashMap<String, Field>(originalFields.size());
                for (Map.Entry<String, Field> entry : originalFields.entrySet()) {
                    Field field = entry.getValue();
                    fields.put(entry.getKey(), new BField(ReadOnlyUtils.getImmutableType(field.getFieldType(), unresolvedTypes), field.getFieldName(), field.getFlags() | 0x20L));
                }
                BRecordType immutableRecordType = new BRecordType(Utils.decodeIdentifier(origRecordType.getName().concat(" & readonly")), origRecordType.getPackage(), origRecordType.flags |= 0x20L, fields, null, origRecordType.sealed, origRecordType.typeFlags);
                for (Map.Entry<String, BFunctionPointer> entry : origRecordType.getDefaultValues().entrySet()) {
                    immutableRecordType.setDefaultValue(entry.getKey(), entry.getValue());
                }
                BIntersectionType bIntersectionType = ReadOnlyUtils.createAndSetImmutableIntersectionType(origRecordType, immutableRecordType);
                Type type2 = origRecordType.restFieldType;
                if (type2 != null) {
                    immutableRecordType.restFieldType = ReadOnlyUtils.getImmutableType(type2, unresolvedTypes);
                }
                return bIntersectionType;
            }
            case 17: {
                BTableType origTableType = (BTableType)type;
                Type origKeyType = origTableType.getKeyType();
                BTableType immutableTableType = origKeyType != null ? new BTableType(ReadOnlyUtils.getImmutableType(origTableType.getConstrainedType(), unresolvedTypes), ReadOnlyUtils.getImmutableType(origKeyType, unresolvedTypes), true) : new BTableType(ReadOnlyUtils.getImmutableType(origTableType.getConstrainedType(), unresolvedTypes), origTableType.getFieldNames(), true);
                return ReadOnlyUtils.createAndSetImmutableIntersectionType(origTableType, immutableTableType);
            }
            case 47: {
                BObjectType origObjectType = (BObjectType)type;
                Map<String, Field> originalObjectFields = origObjectType.getFields();
                HashMap<String, Field> immutableObjectFields = new HashMap<String, Field>(originalObjectFields.size());
                BObjectType immutableObjectType = new BObjectType(Utils.decodeIdentifier(origObjectType.getName().concat(" & readonly")), origObjectType.getPackage(), origObjectType.flags |= 0x20L);
                immutableObjectType.setFields(immutableObjectFields);
                immutableObjectType.generatedInitMethod = origObjectType.getGeneratedInitMethod();
                immutableObjectType.setInitMethod(origObjectType.getInitMethod());
                immutableObjectType.setMethods(origObjectType.getMethods());
                BIntersectionType objectIntersectionType = ReadOnlyUtils.createAndSetImmutableIntersectionType(origObjectType, immutableObjectType);
                for (Map.Entry<String, Field> entry : originalObjectFields.entrySet()) {
                    Field originalField = entry.getValue();
                    immutableObjectFields.put(entry.getKey(), new BField(ReadOnlyUtils.getImmutableType(originalField.getFieldType(), unresolvedTypes), originalField.getFieldName(), originalField.getFlags()));
                }
                return objectIntersectionType;
            }
            case 53: {
                BTypeReferenceType bType = (BTypeReferenceType)type;
                BTypeReferenceType refType = new BTypeReferenceType(bType.getName(), bType.getPkg(), bType.getTypeFlags(), true);
                refType.setReferredType(ReadOnlyUtils.getImmutableType(bType.getReferredType(), unresolvedTypes));
                return ReadOnlyUtils.createAndSetImmutableIntersectionType(bType, refType);
            }
            case 15: 
            case 23: 
            case 29: {
                return (BIntersectionType)type.getImmutableType();
            }
        }
        BUnionType origUnionType = (BUnionType)type;
        ArrayList<Type> readOnlyMemTypes = new ArrayList<Type>();
        for (Type memberType : origUnionType.getMemberTypes()) {
            if (TypeChecker.isInherentlyImmutableType(memberType)) {
                readOnlyMemTypes.add(memberType);
                continue;
            }
            if (!TypeChecker.isSelectivelyImmutableType(memberType, unresolvedTypes)) continue;
            readOnlyMemTypes.add(ReadOnlyUtils.getImmutableType(memberType, unresolvedTypes));
        }
        Type resultantImmutableType = readOnlyMemTypes.size() == 1 ? (Type)readOnlyMemTypes.iterator().next() : (!unresolvedTypes.add(type) ? origUnionType : new BUnionType(readOnlyMemTypes, true, origUnionType.isCyclic));
        return ReadOnlyUtils.createAndSetImmutableIntersectionType(origUnionType, resultantImmutableType);
    }

    private static BIntersectionType createAndSetImmutableIntersectionType(Type originalType, Type effectiveType) {
        return ReadOnlyUtils.createAndSetImmutableIntersectionType(originalType.getPackage(), originalType, effectiveType);
    }

    private static BIntersectionType createAndSetImmutableIntersectionType(Module pkg, Type originalType, Type effectiveType) {
        int typeFlags = 0;
        if (effectiveType.isAnydata()) {
            typeFlags |= 2;
        }
        if (effectiveType.isPureType()) {
            typeFlags |= 4;
        }
        if (effectiveType.isNilable()) {
            typeFlags |= 1;
        }
        BIntersectionType intersectionType = new BIntersectionType(pkg, new Type[]{originalType, PredefinedTypes.TYPE_READONLY}, (IntersectableReferenceType)effectiveType, typeFlags, true);
        originalType.setImmutableType(intersectionType);
        return intersectionType;
    }

    public static Type getMutableType(BIntersectionType intersectionType) {
        for (Type type : intersectionType.getConstituentTypes()) {
            Type referredType = TypeUtils.getImpliedType(type);
            if (TypeUtils.getImpliedType(intersectionType.getEffectiveType()).getTag() != referredType.getTag()) continue;
            return referredType;
        }
        throw new IllegalStateException("Unsupported intersection type found: " + String.valueOf(intersectionType));
    }

    private ReadOnlyUtils() {
    }
}

