/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.values;

import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.semtype.BasicTypeBitSet;
import io.ballerina.runtime.api.types.semtype.Builder;
import io.ballerina.runtime.api.values.BLink;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BStream;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.runtime.internal.types.BStreamType;
import io.ballerina.runtime.internal.utils.IteratorUtils;
import io.ballerina.runtime.internal.values.RefValue;
import io.ballerina.runtime.internal.values.TypedescValueImpl;
import java.util.Map;
import java.util.UUID;

public class StreamValue
implements RefValue,
BStream {
    private static final BasicTypeBitSet BASIC_TYPE = Builder.getStreamType();
    private BTypedesc typedesc;
    private final Type type;
    private final Type constraintType;
    private final Type completionType;
    private Type iteratorNextReturnType;
    private final BObject iteratorObj;
    public String streamId;

    @Deprecated
    public StreamValue(Type type) {
        this.constraintType = ((BStreamType)type).getConstrainedType();
        this.completionType = ((BStreamType)type).getCompletionType();
        this.type = new BStreamType(this.constraintType, this.completionType);
        this.streamId = UUID.randomUUID().toString();
        this.iteratorObj = null;
    }

    public StreamValue(Type type, BObject iteratorObj) {
        this.constraintType = ((BStreamType)type).getConstrainedType();
        this.completionType = ((BStreamType)type).getCompletionType();
        this.type = new BStreamType(this.constraintType, this.completionType);
        this.streamId = UUID.randomUUID().toString();
        this.iteratorObj = iteratorObj;
    }

    public String getStreamId() {
        return this.streamId;
    }

    @Override
    public BObject getIteratorObj() {
        return this.iteratorObj;
    }

    public Type getIteratorNextReturnType() {
        if (this.iteratorNextReturnType == null) {
            this.iteratorNextReturnType = IteratorUtils.createIteratorNextReturnType(this.constraintType);
        }
        return this.iteratorNextReturnType;
    }

    @Override
    public String stringValue(BLink parent) {
        return this.getType().toString();
    }

    @Override
    public String expressionStringValue(BLink parent) {
        return this.stringValue(parent);
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public BasicTypeBitSet getBasicType() {
        return BASIC_TYPE;
    }

    @Override
    public Object copy(Map<Object, Object> refs) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object frozenCopy(Map<Object, Object> refs) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BTypedesc getTypedesc() {
        if (this.typedesc == null) {
            this.typedesc = new TypedescValueImpl(this.type);
        }
        return this.typedesc;
    }

    @Override
    public Type getConstraintType() {
        return this.constraintType;
    }

    @Override
    public Type getCompletionType() {
        return this.completionType;
    }

    public String toString() {
        return this.stringValue(null);
    }
}

