/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.values;

import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.types.TupleType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BIterator;
import io.ballerina.runtime.api.values.BLink;
import io.ballerina.runtime.api.values.BListInitialValueEntry;
import io.ballerina.runtime.api.values.BRefValue;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.runtime.api.values.BValue;
import io.ballerina.runtime.internal.TypeChecker;
import io.ballerina.runtime.internal.errors.ErrorCodes;
import io.ballerina.runtime.internal.errors.ErrorHelper;
import io.ballerina.runtime.internal.errors.ErrorReasons;
import io.ballerina.runtime.internal.utils.CycleUtils;
import io.ballerina.runtime.internal.utils.StringUtils;
import io.ballerina.runtime.internal.utils.ValueConverter;
import io.ballerina.runtime.internal.utils.ValueUtils;
import io.ballerina.runtime.internal.values.AbstractArrayValue;
import io.ballerina.runtime.internal.values.IteratorValue;
import io.ballerina.runtime.internal.values.ListInitialValueEntry;
import io.ballerina.runtime.internal.values.ReadOnlyUtils;
import io.ballerina.runtime.internal.values.TypedescValueImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.IntStream;

public class TupleValueImpl
extends AbstractArrayValue {
    protected TupleType tupleType;
    protected Type type;
    Object[] refValues;
    private final int minSize;
    private final boolean hasRestElement;
    private BTypedesc typedesc;
    private TypedescValueImpl inherentType;
    private SemType shape;

    public TupleValueImpl(Object[] values, TupleType type) {
        this.refValues = values;
        this.tupleType = type;
        this.type = this.tupleType;
        this.hasRestElement = this.tupleType.getRestType() != null;
        List<Type> memTypes = type.getTupleTypes();
        int memCount = memTypes.size();
        if (values.length < memCount) {
            this.refValues = Arrays.copyOf(this.refValues, memCount);
            for (int i = values.length; i < memCount; ++i) {
                this.refValues[i] = memTypes.get(i).getZeroValue();
            }
        }
        this.minSize = memTypes.size();
        this.size = this.refValues.length;
    }

    public TupleValueImpl(TupleType type) {
        int memTypeCount;
        this.tupleType = type;
        this.type = this.tupleType;
        List<Type> memTypes = this.tupleType.getTupleTypes();
        this.minSize = this.size = (memTypeCount = memTypes.size());
        boolean bl = this.hasRestElement = this.tupleType.getRestType() != null;
        if (type.getRestType() == null) {
            this.maxSize = this.size;
            this.refValues = new Object[this.size];
        } else {
            this.refValues = new Object[100];
        }
        for (int i = 0; i < memTypeCount; ++i) {
            Type memType = memTypes.get(i);
            if (!TypeChecker.hasFillerValue(memType)) continue;
            this.refValues[i] = memType.getZeroValue();
        }
    }

    public TupleValueImpl(TupleType type, long size, BListInitialValueEntry[] initialValues) {
        this(type, initialValues);
    }

    public TupleValueImpl(Type type, BListInitialValueEntry[] initialValues) {
        this.type = type;
        this.tupleType = (TupleType)TypeUtils.getImpliedType(type);
        List<Type> memTypes = this.tupleType.getTupleTypes();
        int memCount = memTypes.size();
        if (this.tupleType.getRestType() != null) {
            int valueCount = 0;
            for (BListInitialValueEntry listEntry : initialValues) {
                if (listEntry instanceof ListInitialValueEntry.ExpressionEntry) {
                    ++valueCount;
                    continue;
                }
                BArray values = ((ListInitialValueEntry.SpreadEntry)listEntry).values;
                valueCount += values.size();
            }
            this.size = Math.max(valueCount, memCount);
        } else {
            this.size = memCount;
        }
        this.minSize = memCount;
        boolean bl = this.hasRestElement = this.tupleType.getRestType() != null;
        if (this.tupleType.getRestType() == null) {
            this.maxSize = this.size;
            this.refValues = new Object[this.size];
        } else {
            this.refValues = new Object[100];
        }
        int index = 0;
        for (BListInitialValueEntry listEntry : initialValues) {
            if (listEntry instanceof ListInitialValueEntry.ExpressionEntry) {
                ListInitialValueEntry.ExpressionEntry expressionEntry = (ListInitialValueEntry.ExpressionEntry)listEntry;
                this.addRefValue(index++, expressionEntry.value);
                continue;
            }
            BArray values = ((ListInitialValueEntry.SpreadEntry)listEntry).values;
            BIterator<?> iterator2 = values.getIterator();
            while (iterator2.hasNext()) {
                this.addRefValue(index++, iterator2.next());
            }
        }
        if (index >= memCount) {
            return;
        }
        for (int i = index; i < memCount; ++i) {
            Type memType = memTypes.get(i);
            if (!TypeChecker.hasFillerValue(memType)) continue;
            this.refValues[i] = memType.getZeroValue();
        }
    }

    public TupleValueImpl(Type type, BListInitialValueEntry[] initialValues, TypedescValueImpl inherentType) {
        this(type, initialValues);
        this.inherentType = inherentType;
    }

    @Override
    public BTypedesc getTypedesc() {
        if (this.typedesc == null) {
            this.typedesc = this.inherentType != null ? ValueUtils.getTypedescValue(this.type.isReadOnly(), this, this.inherentType) : ValueUtils.getTypedescValue(this.type, this);
        }
        return this.typedesc;
    }

    @Override
    public Object get(long index) {
        this.rangeCheckForGet(index, this.size);
        return this.refValues[(int)index];
    }

    @Override
    public Object getRefValue(long index) {
        return this.get(index);
    }

    @Override
    public Object fillAndGetRefValue(long index) {
        if (index >= (long)this.size && this.hasRestElement) {
            this.handleImmutableArrayValue();
            this.fillRead(index, this.refValues.length);
            return this.refValues[(int)index];
        }
        return this.get(index);
    }

    @Override
    public long getInt(long index) {
        return (Long)this.get(index);
    }

    @Override
    public boolean getBoolean(long index) {
        return (Boolean)this.get(index);
    }

    @Override
    public byte getByte(long index) {
        Object value2 = this.get(index);
        if (value2 instanceof Long) {
            Long l = (Long)value2;
            return l.byteValue();
        }
        return (Byte)value2;
    }

    @Override
    public double getFloat(long index) {
        return (Double)this.get(index);
    }

    @Override
    public String getString(long index) {
        return this.get(index).toString();
    }

    @Override
    public BString getBString(long index) {
        return (BString)this.get(index);
    }

    @Override
    public void add(long index, Object value2) {
        this.handleImmutableArrayValue();
        this.addRefValue(index, value2);
    }

    public void addRefValue(long index, Object value2) {
        this.prepareForAdd(index, value2, this.refValues.length);
        this.refValues[(int)index] = value2;
    }

    public void convertStringAndAddRefValue(long index, BString value2) {
        this.rangeCheck(index, this.size);
        int intIndex = (int)index;
        Type elemType = index >= (long)this.minSize ? this.tupleType.getRestType() : this.tupleType.getTupleTypes().get(intIndex);
        Object val2 = ValueConverter.getConvertedStringValue(value2, elemType);
        this.prepareForAddWithoutTypeCheck(this.refValues.length, intIndex);
        this.refValues[intIndex] = val2;
    }

    public void addRefValueForcefully(int index, Object value2) {
        this.prepareForAddForcefully(index, this.refValues.length);
        this.refValues[index] = value2;
    }

    @Override
    public void add(long index, long value2) {
        this.add(index, (Object)value2);
    }

    @Override
    public void add(long index, boolean value2) {
        this.add(index, (Object)value2);
    }

    @Override
    public void add(long index, byte value2) {
        this.add(index, (Object)value2);
    }

    @Override
    public void add(long index, double value2) {
        this.add(index, (Object)value2);
    }

    @Override
    public void add(long index, String value2) {
        this.add(index, (Object)value2);
    }

    @Override
    public void add(long index, BString value2) {
        this.add(index, (Object)value2);
    }

    @Override
    public void append(Object value2) {
        this.add((long)this.size, value2);
    }

    @Override
    public Object shift(long index) {
        return this.shift(index, "shift");
    }

    @Override
    public Object pop(long index) {
        return this.shift(index, "pop");
    }

    @Override
    public Object remove(long index) {
        return this.shift(index, "remove");
    }

    public Object shift(long index, String operation) {
        this.handleImmutableArrayValue();
        this.validateTupleSizeAndInherentType((int)index, operation);
        Object val2 = this.get(index);
        this.shiftArray((int)index);
        return val2;
    }

    @Override
    public Object shift() {
        return this.shift(0L);
    }

    @Override
    public void unshift(Object[] values) {
        this.unshift(0L, values);
    }

    @Override
    public String stringValue(BLink parent) {
        StringJoiner sj = new StringJoiner(",");
        block4: for (int i = 0; i < this.size; ++i) {
            Object value2 = this.refValues[i];
            Type type = TypeChecker.getType(value2);
            CycleUtils.Node parentNode = new CycleUtils.Node(this, parent);
            switch (type.getTag()) {
                case 5: 
                case 16: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 38: 
                case 40: {
                    sj.add(((BValue)value2).informalStringValue(parentNode));
                    continue block4;
                }
                case 14: {
                    sj.add("null");
                    continue block4;
                }
                default: {
                    sj.add(StringUtils.getStringVal(value2, new CycleUtils.Node(this, parentNode)));
                }
            }
        }
        return "[" + String.valueOf(sj) + "]";
    }

    @Override
    public String expressionStringValue(BLink parent) {
        StringJoiner sj = new StringJoiner(",");
        for (int i = 0; i < this.size; ++i) {
            sj.add(StringUtils.getExpressionStringVal(this.refValues[i], new CycleUtils.Node(this, parent)));
        }
        return "[" + String.valueOf(sj) + "]";
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public BArray slice(long startIndex, long endIndex) {
        return null;
    }

    @Override
    public Object copy(Map<Object, Object> refs) {
        if (this.isFrozen()) {
            return this;
        }
        if (refs.containsKey(this)) {
            return refs.get(this);
        }
        Object[] values = new Object[this.size];
        TupleValueImpl refValueArray = new TupleValueImpl(values, this.tupleType);
        refs.put(this, refValueArray);
        IntStream.range(0, this.size).forEach(i -> {
            Object value2 = this.refValues[i];
            if (value2 instanceof BRefValue) {
                BRefValue bRefValue = (BRefValue)value2;
                values[i] = bRefValue.copy(refs);
            } else {
                values[i] = value2;
            }
        });
        return refValueArray;
    }

    @Override
    public Object[] getValues() {
        return this.refValues;
    }

    @Override
    public byte[] getBytes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String[] getStringArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long[] getIntArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean[] getBooleanArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] getByteArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double[] getFloatArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void serialize(OutputStream outputStream) {
        try {
            outputStream.write(this.toString().getBytes(Charset.defaultCharset()));
        }
        catch (IOException e) {
            throw ErrorCreator.createError(io.ballerina.runtime.api.utils.StringUtils.fromString("error occurred while serializing data"), e);
        }
    }

    @Override
    public void freezeDirect() {
        if (this.tupleType.isReadOnly()) {
            return;
        }
        this.type = ReadOnlyUtils.setImmutableTypeAndGetEffectiveType(this.type);
        this.tupleType = (TupleType)TypeUtils.getImpliedType(this.type);
        for (int i = 0; i < this.size; ++i) {
            Object value2 = this.get(i);
            if (!(value2 instanceof BRefValue)) continue;
            BRefValue bRefValue = (BRefValue)value2;
            bRefValue.freezeDirect();
        }
        this.typedesc = null;
    }

    @Override
    public IteratorValue<Object> getIterator() {
        return new AbstractArrayValue.ArrayIterator(this);
    }

    @Override
    public Type getElementType() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void resizeInternalArray(int newLength) {
        this.refValues = Arrays.copyOf(this.refValues, newLength);
    }

    @Override
    protected void fillValues(int index) {
        if (index <= this.size) {
            return;
        }
        Type restType = this.tupleType.getRestType();
        if (restType != null) {
            for (int i = this.size; i < index; ++i) {
                this.refValues[i] = restType.getZeroValue();
            }
        }
    }

    @Override
    protected void rangeCheckForGet(long index, int size) {
        this.rangeCheck(index, size);
        if (index < 0L || index >= (long)size) {
            throw ErrorHelper.getRuntimeException(ErrorReasons.getModulePrefixedReason("lang.array", "IndexOutOfRange"), ErrorCodes.TUPLE_INDEX_OUT_OF_RANGE, index, size);
        }
    }

    @Override
    protected void rangeCheck(long index, int size) {
        if (index > Integer.MAX_VALUE || index < Integer.MIN_VALUE) {
            throw ErrorHelper.getRuntimeException(ErrorReasons.getModulePrefixedReason("lang.array", "IndexOutOfRange"), ErrorCodes.INDEX_NUMBER_TOO_LARGE, index);
        }
        if (this.tupleType.getRestType() == null && index >= (long)this.maxSize || (int)index < 0) {
            throw ErrorHelper.getRuntimeException(ErrorReasons.getModulePrefixedReason("lang.array", "IndexOutOfRange"), ErrorCodes.TUPLE_INDEX_OUT_OF_RANGE, index, size);
        }
    }

    @Override
    protected void fillerValueCheck(int index, int size, int expectedLength) {
        if (this.size >= index) {
            return;
        }
        if (!TypeChecker.hasFillerValue(this.tupleType.getRestType()) && index > size) {
            throw ErrorHelper.getRuntimeException(ErrorReasons.ILLEGAL_LIST_INSERTION_ERROR, ErrorCodes.ILLEGAL_TUPLE_INSERTION, size, expectedLength);
        }
    }

    @Override
    protected void prepareForConsecutiveMultiAdd(long index, int currentArraySize) {
        int intIndex = (int)index;
        this.rangeCheck(index, this.size);
        this.ensureCapacity(intIndex + 1, currentArraySize);
        this.resetSize(intIndex);
    }

    @Override
    protected void ensureCapacity(int requestedCapacity, int currentArraySize) {
        if (requestedCapacity <= currentArraySize) {
            return;
        }
        int newArraySize = currentArraySize + (currentArraySize >> 1);
        newArraySize = Math.max(newArraySize, requestedCapacity);
        newArraySize = Math.min(newArraySize, this.maxSize);
        this.resizeInternalArray(newArraySize);
    }

    @Override
    protected void checkFixedLength(long length) {
        if (this.tupleType.getRestType() == null) {
            throw ErrorHelper.getRuntimeException(ErrorReasons.getModulePrefixedReason("lang.array", "InherentTypeViolation"), ErrorCodes.ILLEGAL_TUPLE_SIZE, this.size, length);
        }
        if ((long)this.tupleType.getTupleTypes().size() > length) {
            throw ErrorHelper.getRuntimeException(ErrorReasons.getModulePrefixedReason("lang.array", "InherentTypeViolation"), ErrorCodes.ILLEGAL_TUPLE_WITH_REST_TYPE_SIZE, this.tupleType.getTupleTypes().size(), length);
        }
    }

    @Override
    protected void unshift(long index, Object[] vals) {
        this.handleImmutableArrayValue();
        this.validateInherentTypeOfExistingMembers((int)index, vals.length);
        this.unshiftArray(index, vals.length, this.getCurrentArrayLength());
        this.addToRefArray(vals, (int)index);
    }

    private void prepareForAdd(long index, Object value2, int currentArraySize) {
        int intIndex = (int)index;
        this.rangeCheck(index, this.size);
        Type elemType = index >= (long)this.minSize ? this.tupleType.getRestType() : this.tupleType.getTupleTypes().get((int)index);
        if (!TypeChecker.checkIsType(value2, elemType)) {
            throw ErrorCreator.createError(ErrorReasons.getModulePrefixedReason("lang.array", "InherentTypeViolation"), ErrorHelper.getErrorDetails(ErrorCodes.INCOMPATIBLE_TYPE, elemType, TypeChecker.getType(value2)));
        }
        this.prepareForAddWithoutTypeCheck(currentArraySize, intIndex);
    }

    private void prepareForAddWithoutTypeCheck(int currentArraySize, int intIndex) {
        this.fillerValueCheck(intIndex, this.size, intIndex + 1);
        this.ensureCapacity(intIndex + 1, currentArraySize);
        this.fillValues(intIndex);
        this.resetSize(intIndex);
    }

    private void fillRead(long index, int currentArraySize) {
        Type restType = this.tupleType.getRestType();
        if (!TypeChecker.hasFillerValue(restType)) {
            throw ErrorHelper.getRuntimeException(ErrorReasons.ILLEGAL_LIST_INSERTION_ERROR, ErrorCodes.ILLEGAL_TUPLE_INSERTION, this.size, index + 1L);
        }
        int intIndex = (int)index;
        this.rangeCheck(index, this.size);
        this.ensureCapacity(intIndex + 1, currentArraySize);
        int i = this.size;
        while ((long)i <= index) {
            this.refValues[i] = restType.getZeroValue();
            ++i;
        }
        this.resetSize(intIndex);
    }

    private void shiftArray(int index) {
        int nElemsToBeMoved = this.size - 1 - index;
        if (nElemsToBeMoved >= 0) {
            System.arraycopy(this.refValues, index + 1, this.refValues, index, nElemsToBeMoved);
        }
        --this.size;
    }

    private void addToRefArray(Object[] vals, int startIndex) {
        int endIndex = startIndex + vals.length;
        int i = startIndex;
        int j = 0;
        while (i < endIndex) {
            this.add((long)i, vals[j]);
            ++i;
            ++j;
        }
    }

    private void unshiftArray(long index, int unshiftByN, int arrLength) {
        int currSize = this.size();
        int lastIndex = currSize + unshiftByN - 1;
        this.prepareForConsecutiveMultiAdd(lastIndex, arrLength);
        if (index > (long)lastIndex) {
            throw ErrorHelper.getRuntimeException(ErrorReasons.getModulePrefixedReason("lang.array", "IndexOutOfRange"), ErrorCodes.INDEX_NUMBER_TOO_LARGE, index);
        }
        int i = (int)index;
        System.arraycopy(this.refValues, i, this.refValues, i + unshiftByN, currSize - i);
    }

    private int getCurrentArrayLength() {
        return this.refValues.length;
    }

    private void resetSize(int index) {
        if (index >= this.size) {
            this.size = index + 1;
        }
    }

    private void validateTupleSizeAndInherentType(int index, String operation) {
        List<Type> tupleTypesList = this.tupleType.getTupleTypes();
        int numOfMandatoryTypes = tupleTypesList.size();
        if ((long)numOfMandatoryTypes >= this.getLength()) {
            throw ErrorHelper.getRuntimeException(ErrorReasons.getModulePrefixedReason("lang.array", "OperationNotSupported"), ErrorCodes.INVALID_TUPLE_MEMBER_SIZE, operation);
        }
        for (int i = index + 1; i <= numOfMandatoryTypes; ++i) {
            if (TypeChecker.checkIsType(this.getRefValue(i), tupleTypesList.get(i - 1))) continue;
            throw ErrorHelper.getRuntimeException(ErrorReasons.getModulePrefixedReason("lang.array", "InherentTypeViolation"), ErrorCodes.INCOMPATIBLE_TYPE, tupleTypesList.get(i - 1), i == numOfMandatoryTypes ? this.tupleType.getRestType() : tupleTypesList.get(i));
        }
    }

    private void validateInherentTypeOfExistingMembers(int index, int offset) {
        for (int i = index; i < this.size; ++i) {
            Type targetType;
            Type type = targetType = i + offset >= this.tupleType.getTupleTypes().size() ? this.tupleType.getRestType() : this.tupleType.getTupleTypes().get(i + offset);
            if (TypeChecker.checkIsType(this.getRefValue(i), targetType)) continue;
            throw ErrorHelper.getRuntimeException(ErrorReasons.getModulePrefixedReason("lang.array", "InherentTypeViolation"), ErrorCodes.INCOMPATIBLE_TYPE, TypeChecker.getType(this.getRefValue(i)), targetType);
        }
    }

    @Override
    public void cacheShape(SemType semType) {
        this.shape = semType;
    }

    @Override
    public SemType shapeOf() {
        return this.shape;
    }
}

