/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.observability.metrics;

import io.ballerina.runtime.observability.metrics.DefaultMetricRegistry;
import io.ballerina.runtime.observability.metrics.Metric;
import io.ballerina.runtime.observability.metrics.MetricId;
import io.ballerina.runtime.observability.metrics.MetricRegistry;
import io.ballerina.runtime.observability.metrics.Snapshot;
import io.ballerina.runtime.observability.metrics.StatisticConfig;
import io.ballerina.runtime.observability.metrics.Tag;
import io.ballerina.runtime.observability.metrics.Tags;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface Gauge
extends Metric {
    public static Builder builder(String name) {
        return new Builder(name);
    }

    @Override
    default public Gauge register() {
        return DefaultMetricRegistry.getInstance().register(this);
    }

    @Override
    default public void unregister() {
        DefaultMetricRegistry.getInstance().unregister(this);
    }

    default public void increment() {
        this.increment(1.0);
    }

    public void increment(double var1);

    default public void decrement() {
        this.decrement(1.0);
    }

    public void decrement(double var1);

    public void setValue(double var1);

    public double getValue();

    public long getCount();

    public double getSum();

    public Snapshot[] getSnapshots();

    public StatisticConfig[] getStatisticsConfig();

    public static class Builder
    implements Metric.Builder<Builder, Gauge> {
        private final String name;
        private final Set<Tag> tags = new HashSet<Tag>(10);
        private String description;
        private final List<StatisticConfig> statisticConfigs = new ArrayList<StatisticConfig>();

        private Builder(String name) {
            this.name = name;
        }

        @Override
        public Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder tags(String ... keyValues) {
            Tags.tags(this.tags, keyValues);
            return this;
        }

        @Override
        public Builder tags(Iterable<Tag> tags) {
            Tags.tags(this.tags, tags);
            return this;
        }

        @Override
        public Builder tag(String key, String value2) {
            Tags.tags(this.tags, key, value2);
            return this;
        }

        @Override
        public Builder tags(Map<String, String> tags) {
            Tags.tags(this.tags, tags);
            return this;
        }

        public Builder summarize(StatisticConfig statisticConfig) {
            this.statisticConfigs.add(statisticConfig);
            return this;
        }

        @Override
        public Gauge register() {
            return this.register(DefaultMetricRegistry.getInstance());
        }

        @Override
        public Gauge register(MetricRegistry registry) {
            return registry.gauge(new MetricId(this.name, this.description, this.tags), this.statisticConfigs.toArray(new StatisticConfig[this.statisticConfigs.size()]));
        }

        @Override
        public Gauge build() {
            return DefaultMetricRegistry.getInstance().getMetricProvider().newGauge(new MetricId(this.name, this.description, this.tags), this.statisticConfigs.toArray(new StatisticConfig[this.statisticConfigs.size()]));
        }
    }
}

