/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.observability.tracer;

import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BMapInitialValueEntry;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.values.MappingInitialValueEntry;
import io.ballerina.runtime.observability.tracer.TraceConstants;
import io.ballerina.runtime.observability.tracer.TracersStore;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.context.propagation.TextMapSetter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class BSpan {
    private final Tracer tracer;
    private final Span span;
    private BMap<BString, Object> bSpanContext;
    private static final MapType IMMUTABLE_STRING_MAP_TYPE = TypeCreator.createMapType(PredefinedTypes.TYPE_STRING, true);
    private static final PropagatingParentContextGetter GETTER = new PropagatingParentContextGetter();
    private static final PropagatingParentContextSetter SETTER = new PropagatingParentContextSetter();

    private BSpan(Tracer tracer, Span span) {
        this.tracer = tracer;
        this.span = span;
    }

    private static BSpan start(Tracer tracer, Context parentContext, String operationName, boolean isClient) {
        SpanBuilder builder = tracer.spanBuilder(operationName);
        if (parentContext != null) {
            builder.setParent(parentContext);
        }
        builder.setAttribute("span.kind", isClient ? "client" : "server");
        builder.setSpanKind(isClient ? SpanKind.CLIENT : SpanKind.SERVER);
        Span span = builder.startSpan();
        return new BSpan(tracer, span);
    }

    public static BSpan start(String serviceName, String operationName, boolean isClient) {
        Tracer tracer = TracersStore.getInstance().getTracer(serviceName);
        return BSpan.start(tracer, null, operationName, isClient);
    }

    public static BSpan start(BSpan parentSpan, String serviceName, String operationName, boolean isClient) {
        Tracer tracer = TracersStore.getInstance().getTracer(serviceName);
        Context parentContext = Context.current().with(parentSpan.span);
        return BSpan.start(tracer, parentContext, operationName, isClient);
    }

    public static BSpan start(Map<String, String> parentTraceContext, String serviceName, String operationName, boolean isClient) {
        Tracer tracer = TracersStore.getInstance().getTracer(serviceName);
        Context parentContext = TracersStore.getInstance().getPropagators().getTextMapPropagator().extract(Context.current(), parentTraceContext, GETTER);
        return BSpan.start(tracer, parentContext, operationName, isClient);
    }

    public void finishSpan() {
        this.span.end();
    }

    public void addEvent(String eventName, Attributes attributes) {
        this.span.addEvent(eventName, attributes);
    }

    public void setStatus(StatusCode statusCode) {
        this.span.setStatus(statusCode);
    }

    public void addTags(Map<String, String> tags) {
        for (Map.Entry<String, String> entry : tags.entrySet()) {
            this.span.setAttribute(entry.getKey(), entry.getValue());
        }
    }

    public void addTag(String tagKey, String tagValue) {
        this.span.setAttribute(tagKey, tagValue);
    }

    public Map<String, String> extractContextAsHttpHeaders() {
        Map<String, String> carrierMap;
        if (this.span != null) {
            carrierMap = new HashMap();
            TextMapPropagator propagator = TracersStore.getInstance().getPropagators().getTextMapPropagator();
            propagator.inject(Context.current().with(this.span), carrierMap, SETTER);
        } else {
            carrierMap = Collections.emptyMap();
        }
        return carrierMap;
    }

    public BMap<BString, Object> getBSpanContext() {
        if (this.bSpanContext == null) {
            SpanContext spanContext = this.span.getSpanContext();
            BMapInitialValueEntry[] values = new BMapInitialValueEntry[]{new MappingInitialValueEntry.KeyValueEntry(TraceConstants.SPAN_CONTEXT_MAP_KEY_TRACE_ID, StringUtils.fromString(spanContext.getTraceId())), new MappingInitialValueEntry.KeyValueEntry(TraceConstants.SPAN_CONTEXT_MAP_KEY_SPAN_ID, StringUtils.fromString(spanContext.getSpanId()))};
            this.bSpanContext = ValueCreator.createMapValue(IMMUTABLE_STRING_MAP_TYPE, values);
        }
        return this.bSpanContext;
    }

    static class PropagatingParentContextGetter
    implements TextMapGetter<Map<String, String>> {
        PropagatingParentContextGetter() {
        }

        @Override
        public String get(Map<String, String> carrier, String key) {
            return carrier.get(key);
        }

        @Override
        public Iterable<String> keys(Map<String, String> carrier) {
            return carrier.keySet();
        }
    }

    static class PropagatingParentContextSetter
    implements TextMapSetter<Map<String, String>> {
        PropagatingParentContextSetter() {
        }

        @Override
        public void set(Map<String, String> carrier, String key, String value2) {
            carrier.put(key, value2);
        }
    }
}

