/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.transactions;

import io.ballerina.runtime.transactions.XATransactionID;
import java.security.SecureRandom;
import java.util.concurrent.atomic.AtomicInteger;

public final class XIDGenerator {
    private static final SecureRandom secureRand = new SecureRandom();
    private static final AtomicInteger formatIdIdGenerator = new AtomicInteger();

    private static byte[] randomBytes() {
        byte[] bytes = new byte[48];
        secureRand.nextBytes(bytes);
        return bytes;
    }

    static XATransactionID createXID() {
        byte[] branchQualifier = XIDGenerator.randomBytes();
        byte[] globalTransactionId = XIDGenerator.randomBytes();
        return new XATransactionID(formatIdIdGenerator.incrementAndGet(), branchQualifier, globalTransactionId);
    }

    private XIDGenerator() {
    }
}

