/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.internal.diagnostics;

import io.ballerina.toml.internal.diagnostics.DiagnosticMessageHelper;
import io.ballerina.toml.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.toml.syntax.tree.NodeLocation;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticCode;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticProperty;
import java.util.List;

public class SyntaxDiagnostic
extends Diagnostic {
    private final STNodeDiagnostic nodeDiagnostic;
    private final NodeLocation location;
    private DiagnosticInfo diagnosticInfo;

    private SyntaxDiagnostic(STNodeDiagnostic nodeDiagnostic, NodeLocation location) {
        this.nodeDiagnostic = nodeDiagnostic;
        this.location = location;
    }

    public static SyntaxDiagnostic from(STNodeDiagnostic nodeDiagnostic, NodeLocation location) {
        return new SyntaxDiagnostic(nodeDiagnostic, location);
    }

    @Override
    public NodeLocation location() {
        return this.location;
    }

    @Override
    public DiagnosticInfo diagnosticInfo() {
        if (this.diagnosticInfo != null) {
            return this.diagnosticInfo;
        }
        DiagnosticCode diagnosticCode = this.nodeDiagnostic.diagnosticCode();
        this.diagnosticInfo = new DiagnosticInfo(diagnosticCode.diagnosticId(), diagnosticCode.toString(), diagnosticCode.severity());
        return this.diagnosticInfo;
    }

    @Override
    public String message() {
        return DiagnosticMessageHelper.getDiagnosticMessage(this.nodeDiagnostic.diagnosticCode(), this.nodeDiagnostic.args());
    }

    @Override
    public List<DiagnosticProperty<?>> properties() {
        return null;
    }

    @Override
    public String toString() {
        return this.diagnosticInfo().severity().toString() + " [" + this.location().lineRange().fileName() + ":" + String.valueOf(this.location().lineRange()) + "] " + this.message();
    }
}

