/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.internal.parser;

import io.ballerina.toml.internal.parser.AbstractParser;
import io.ballerina.toml.internal.parser.AbstractTokenReader;
import io.ballerina.toml.internal.parser.ParserRuleContext;
import io.ballerina.toml.internal.parser.SyntaxErrors;
import io.ballerina.toml.internal.parser.TomlParserErrorHandler;
import io.ballerina.toml.internal.parser.tree.STNode;
import io.ballerina.toml.internal.parser.tree.STNodeFactory;
import io.ballerina.toml.internal.parser.tree.STToken;
import io.ballerina.toml.syntax.tree.SyntaxKind;
import java.util.ArrayList;
import java.util.List;

public class TomlParser
extends AbstractParser {
    public TomlParser(AbstractTokenReader tokenReader) {
        super(tokenReader, new TomlParserErrorHandler(tokenReader));
    }

    @Override
    public STNode parse() {
        STNode decl;
        ArrayList<STNode> topLevelNodes = new ArrayList<STNode>();
        STToken token = this.peek();
        while (token.kind != SyntaxKind.EOF_TOKEN && (decl = this.parseTopLevelNode()) != null) {
            topLevelNodes.add(decl);
            token = this.peek();
        }
        STToken eof = this.consume();
        return STNodeFactory.createDocumentNode(STNodeFactory.createNodeList(topLevelNodes), eof);
    }

    private STNode parseTopLevelNode() {
        this.startContext(ParserRuleContext.TOP_LEVEL_NODE);
        STToken nextToken = this.peek();
        switch (nextToken.kind) {
            case EOF_TOKEN: {
                return null;
            }
            case NEWLINE: {
                this.consume();
                return this.parseTopLevelNode();
            }
            case OPEN_BRACKET_TOKEN: {
                if (this.peek((int)2).kind == SyntaxKind.OPEN_BRACKET_TOKEN) {
                    return this.parseArrayOfTables();
                }
                return this.parseTable();
            }
            case IDENTIFIER_LITERAL: 
            case SINGLE_QUOTE_TOKEN: 
            case DOUBLE_QUOTE_TOKEN: 
            case TRUE_KEYWORD: 
            case FALSE_KEYWORD: 
            case DECIMAL_INT_TOKEN: 
            case DECIMAL_FLOAT_TOKEN: {
                int lookahead = 1;
                STToken peekToken = this.peek(lookahead);
                while (!this.isEndOfStatement(peekToken)) {
                    if (peekToken.kind == SyntaxKind.CLOSE_BRACKET_TOKEN) {
                        if (this.peek((int)(lookahead + 1)).kind == SyntaxKind.CLOSE_BRACKET_TOKEN) {
                            return this.parseArrayOfTables();
                        }
                        return this.parseTable();
                    }
                    peekToken = this.peek(++lookahead);
                }
                return this.parseKeyValue(false);
            }
        }
        this.recover(nextToken, ParserRuleContext.TOP_LEVEL_NODE, new Object[0]);
        return this.parseTopLevelNode();
    }

    private boolean isEndOfStatement(STToken nextToken) {
        return nextToken.kind == SyntaxKind.EQUAL_TOKEN || nextToken.kind == SyntaxKind.NEWLINE || nextToken.kind == SyntaxKind.EOF_TOKEN;
    }

    private STNode parseArrayOfTables() {
        this.startContext(ParserRuleContext.TOML_TABLE_ARRAY);
        STNode firstOpenBracket = this.parseOpenBracket(ParserRuleContext.ARRAY_TABLE_FIRST_START);
        STNode secondOpenBracket = this.parseOpenBracket(ParserRuleContext.ARRAY_TABLE_SECOND_START);
        STNode identifierToken = STNodeFactory.createKeyNode(this.parseKeys());
        STNode firstCloseBracket = this.parseCloseBracket(ParserRuleContext.ARRAY_TABLE_FIRST_END);
        STNode secondCloesBracket = this.parseCloseBracket(ParserRuleContext.ARRAY_TABLE_SECOND_END);
        STNode newline = this.parseNewlines();
        if (newline.hasDiagnostics()) {
            secondCloesBracket = SyntaxErrors.addSyntaxDiagnostics(secondCloesBracket, newline.diagnostics());
        }
        List<STNode> fields = this.parseTableEntries();
        this.endContext();
        return STNodeFactory.createTableArrayNode(firstOpenBracket, secondOpenBracket, identifierToken, firstCloseBracket, secondCloesBracket, STNodeFactory.createNodeList(fields));
    }

    private STNode parseInlineTable() {
        STNode openBrace = this.parseOpenBrace();
        STNode keyValuePairs = this.parseInlineKeyValuePairs();
        STNode endBrace = this.parseCloseBrace();
        return STNodeFactory.createInlineTableNode(openBrace, keyValuePairs, endBrace);
    }

    private STNode parseInlineKeyValuePairs() {
        STNode valueEnd;
        this.startContext(ParserRuleContext.INLINE_TABLE_LIST);
        STToken nextToken = this.peek();
        if (this.isEndOfInlineTable(nextToken)) {
            STNode values = STNodeFactory.createEmptyNodeList();
            this.endContext();
            return values;
        }
        ArrayList<STNode> keyValuePairList = new ArrayList<STNode>();
        STNode keyValuePair = this.parseInlineKeyValuePair();
        keyValuePairList.add(keyValuePair);
        nextToken = this.peek();
        while (!this.isEndOfInlineTable(nextToken) && (valueEnd = this.parseInlineTableEntryEnd()) != null) {
            keyValuePairList.add(valueEnd);
            keyValuePair = this.parseInlineKeyValuePair();
            keyValuePairList.add(keyValuePair);
            nextToken = this.peek();
        }
        this.endContext();
        return STNodeFactory.createNodeList(keyValuePairList);
    }

    private STNode parseInlineKeyValuePair() {
        STToken nextToken = this.peek();
        return switch (nextToken.kind) {
            case SyntaxKind.IDENTIFIER_LITERAL, SyntaxKind.SINGLE_QUOTE_TOKEN, SyntaxKind.DOUBLE_QUOTE_TOKEN, SyntaxKind.TRUE_KEYWORD, SyntaxKind.FALSE_KEYWORD, SyntaxKind.DECIMAL_INT_TOKEN, SyntaxKind.DECIMAL_FLOAT_TOKEN -> this.parseKeyValue(true);
            default -> {
                this.recover(this.peek(), ParserRuleContext.INLINE_TABLE_ENTRY_START, new Object[0]);
                yield this.parseInlineKeyValuePair();
            }
        };
    }

    private boolean isEndOfInlineTable(STToken token) {
        return token.kind == SyntaxKind.CLOSE_BRACE_TOKEN || token.kind == SyntaxKind.EOF_TOKEN;
    }

    private STNode parseInlineTableEntryEnd() {
        return switch (this.peek().kind) {
            case SyntaxKind.COMMA_TOKEN -> this.consume();
            case SyntaxKind.CLOSE_BRACE_TOKEN -> null;
            default -> {
                this.recover(this.peek(), ParserRuleContext.INLINE_TABLE_ENTRY_END, new Object[0]);
                yield this.parseInlineTableEntryEnd();
            }
        };
    }

    private STNode parseOpenBrace() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.OPEN_BRACE_TOKEN) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.INLINE_TABLE_START, new Object[0]);
        return this.parseOpenBrace();
    }

    private STNode parseCloseBrace() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.CLOSE_BRACE_TOKEN) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.INLINE_TABLE_END, new Object[0]);
        return this.parseCloseBrace();
    }

    private STNode parseTable() {
        this.startContext(ParserRuleContext.TOML_TABLE);
        STNode openBracket = this.parseOpenBracket(ParserRuleContext.TABLE_START);
        STNode identifierToken = STNodeFactory.createKeyNode(this.parseKeys());
        STNode closedBracket = this.parseCloseBracket(ParserRuleContext.TABLE_END);
        STNode newLine = this.parseNewlines();
        if (newLine.hasDiagnostics()) {
            closedBracket = SyntaxErrors.addSyntaxDiagnostics(closedBracket, newLine.diagnostics());
        }
        List<STNode> fields = this.parseTableEntries();
        this.endContext();
        return STNodeFactory.createTableNode(openBracket, identifierToken, closedBracket, STNodeFactory.createNodeList(fields));
    }

    private List<STNode> parseTableEntries() {
        ArrayList<STNode> fields = new ArrayList<STNode>();
        STToken nextNode = this.peek();
        while (!this.isNextTokenArray(nextNode)) {
            STNode stNode = this.parseKeyValue(false);
            fields.add(stNode);
            nextNode = this.peek();
        }
        return fields;
    }

    private boolean isNextTokenArray(STToken nextNode) {
        return nextNode.kind == SyntaxKind.OPEN_BRACKET_TOKEN || nextNode.kind == SyntaxKind.EOF_TOKEN;
    }

    private STNode parseOpenBracket(ParserRuleContext ctx) {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.OPEN_BRACKET_TOKEN) {
            return this.consume();
        }
        this.recover(token, ctx, new Object[0]);
        return this.parseOpenBracket(ctx);
    }

    private STNode parseCloseBracket(ParserRuleContext ctx) {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.CLOSE_BRACKET_TOKEN) {
            return this.consume();
        }
        this.recover(token, ctx, new Object[0]);
        return this.parseCloseBracket(ctx);
    }

    private STNode parseKeyValue(boolean isInlineTable) {
        STNode newLine;
        this.startContext(ParserRuleContext.KEY_VALUE_PAIR);
        STNode identifier = STNodeFactory.createKeyNode(this.parseKeys());
        STNode equals = this.parseEquals();
        STNode value2 = this.parseValue();
        if (!isInlineTable && (newLine = this.parseNewlines()).hasDiagnostics()) {
            value2 = SyntaxErrors.addSyntaxDiagnostics(value2, newLine.diagnostics());
        }
        this.endContext();
        return STNodeFactory.createKeyValueNode(identifier, equals, value2);
    }

    private STNode parseNewlines() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.EOF_TOKEN) {
            return token;
        }
        if (!this.isNewline(token.kind)) {
            this.recover(this.peek(), ParserRuleContext.NEWLINE, new Object[0]);
            return this.parseNewlines();
        }
        STToken recentNewline = token;
        while (this.isNewline(token.kind)) {
            recentNewline = this.consume();
            token = this.peek();
        }
        return recentNewline;
    }

    private boolean isNewline(SyntaxKind kind) {
        return kind == SyntaxKind.NEWLINE;
    }

    private STNode parseKeys() {
        this.startContext(ParserRuleContext.KEY_LIST);
        STNode firstKey = this.parseSingleKey();
        if (firstKey == null) {
            this.recover(this.peek(), ParserRuleContext.KEY_VALUE_PAIR, new Object[0]);
            firstKey = this.parseIdentifierLiteral();
        }
        return this.parseKeyList(firstKey);
    }

    private boolean isEndOfKeyList(STToken token) {
        return token.kind == SyntaxKind.EQUAL_TOKEN || token.kind == SyntaxKind.EOF_TOKEN || token.kind == SyntaxKind.CLOSE_BRACKET_TOKEN;
    }

    private STNode parseIdentifierLiteral() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.IDENTIFIER_LITERAL) {
            return STNodeFactory.createIdentifierLiteralNode(this.consume());
        }
        this.recover(token, ParserRuleContext.IDENTIFIER_LITERAL, new Object[0]);
        return this.parseIdentifierLiteral();
    }

    private STNode parseSingleKey() {
        STToken nextToken = this.peek();
        return switch (nextToken.kind) {
            case SyntaxKind.DECIMAL_INT_TOKEN, SyntaxKind.DECIMAL_FLOAT_TOKEN -> this.parseNumericalNode();
            case SyntaxKind.TRUE_KEYWORD, SyntaxKind.FALSE_KEYWORD -> this.parseBoolean();
            case SyntaxKind.IDENTIFIER_LITERAL -> this.parseIdentifierLiteral();
            case SyntaxKind.DOUBLE_QUOTE_TOKEN -> this.parseStringValue();
            case SyntaxKind.SINGLE_QUOTE_TOKEN -> this.parseLiteralStringValue();
            case SyntaxKind.EQUAL_TOKEN -> null;
            default -> {
                this.recover(this.peek(), ParserRuleContext.KEY_START, new Object[0]);
                yield this.parseSingleKey();
            }
        };
    }

    private STNode parseKeyList(STNode firstKey) {
        STNode keysEnd;
        ArrayList<STNode> keyList = new ArrayList<STNode>();
        keyList.add(firstKey);
        STToken nextToken = this.peek();
        while (!this.isEndOfKeyList(nextToken) && (keysEnd = this.parseKeyEnd()) != null) {
            STNode curKey = this.parseSingleKey();
            if (curKey != null) {
                keyList.add(keysEnd);
                keyList.add(curKey);
            }
            nextToken = this.peek();
        }
        this.endContext();
        return STNodeFactory.createNodeList(keyList);
    }

    private STNode parseKeyEnd() {
        STToken token = this.peek();
        return switch (token.kind) {
            case SyntaxKind.DOT_TOKEN -> this.consume();
            case SyntaxKind.EQUAL_TOKEN, SyntaxKind.CLOSE_BRACKET_TOKEN -> null;
            default -> {
                this.recover(token, ParserRuleContext.KEY_END, new Object[0]);
                yield this.parseKeyEnd();
            }
        };
    }

    private STNode parseEquals() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.EQUAL_TOKEN) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.ASSIGN_OP, new Object[0]);
        return this.parseEquals();
    }

    private STNode parseValue() {
        STToken token = this.peek();
        return switch (token.kind) {
            case SyntaxKind.DOUBLE_QUOTE_TOKEN -> this.parseStringValue();
            case SyntaxKind.TRIPLE_DOUBLE_QUOTE_TOKEN -> this.parseMultilineStringValue();
            case SyntaxKind.SINGLE_QUOTE_TOKEN -> this.parseLiteralStringValue();
            case SyntaxKind.TRIPLE_SINGLE_QUOTE_TOKEN -> this.parseMultilineLiteralStringValue();
            case SyntaxKind.DECIMAL_INT_TOKEN, SyntaxKind.DECIMAL_FLOAT_TOKEN, SyntaxKind.HEX_INTEGER_LITERAL_TOKEN, SyntaxKind.OCTAL_INTEGER_LITERAL_TOKEN, SyntaxKind.BINARY_INTEGER_LITERAL_TOKEN, SyntaxKind.PLUS_TOKEN, SyntaxKind.MINUS_TOKEN -> this.parseNumericalNode();
            case SyntaxKind.TRUE_KEYWORD, SyntaxKind.FALSE_KEYWORD -> this.parseBoolean();
            case SyntaxKind.OPEN_BRACKET_TOKEN -> this.parseArray();
            case SyntaxKind.OPEN_BRACE_TOKEN -> this.parseInlineTable();
            default -> {
                this.recover(token, ParserRuleContext.VALUE, new Object[0]);
                yield this.parseValue();
            }
        };
    }

    private STNode parseNumericalNode() {
        STNode sign = this.parseSign();
        STNode token = this.parseNumericalToken();
        SyntaxKind kind = this.getNumericLiteralKind(token.kind);
        return STNodeFactory.createNumericLiteralNode(kind, sign, token);
    }

    private SyntaxKind getNumericLiteralKind(SyntaxKind tokenKind) {
        return switch (tokenKind) {
            case SyntaxKind.DECIMAL_INT_TOKEN -> SyntaxKind.DEC_INT;
            case SyntaxKind.HEX_INTEGER_LITERAL_TOKEN -> SyntaxKind.HEX_INT;
            case SyntaxKind.OCTAL_INTEGER_LITERAL_TOKEN -> SyntaxKind.OCT_INT;
            case SyntaxKind.BINARY_INTEGER_LITERAL_TOKEN -> SyntaxKind.BINARY_INT;
            default -> SyntaxKind.FLOAT;
        };
    }

    private STNode parseNumericalToken() {
        STToken token = this.peek();
        if (this.isNumericalLiteral(token)) {
            return this.consume();
        }
        this.recover(token, ParserRuleContext.NUMERICAL_LITERAL, new Object[0]);
        return this.parseNumericalToken();
    }

    private boolean isNumericalLiteral(STToken token) {
        return switch (token.kind) {
            case SyntaxKind.DECIMAL_INT_TOKEN, SyntaxKind.DECIMAL_FLOAT_TOKEN, SyntaxKind.HEX_INTEGER_LITERAL_TOKEN, SyntaxKind.OCTAL_INTEGER_LITERAL_TOKEN, SyntaxKind.BINARY_INTEGER_LITERAL_TOKEN -> true;
            default -> false;
        };
    }

    private STNode parseSign() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.MINUS_TOKEN || token.kind == SyntaxKind.PLUS_TOKEN) {
            return this.consume();
        }
        return STNodeFactory.createEmptyNode();
    }

    private STNode parseBoolean() {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.TRUE_KEYWORD || token.kind == SyntaxKind.FALSE_KEYWORD) {
            return STNodeFactory.createBoolLiteralNode(this.consume());
        }
        this.recover(token, ParserRuleContext.BOOLEAN_LITERAL, new Object[0]);
        return this.parseBoolean();
    }

    private STNode parseStringValue() {
        STNode startingDoubleQuote = this.parseDoubleQuoteToken(ParserRuleContext.STRING_START);
        STNode content = this.parseStringContent();
        STNode endingDoubleQuote = this.parseDoubleQuoteToken(ParserRuleContext.STRING_END);
        return STNodeFactory.createStringLiteralNode(startingDoubleQuote, content, endingDoubleQuote);
    }

    private STNode parseMultilineStringValue() {
        STNode startingDoubleQuote = this.parseTripleDoubleQuoteToken(ParserRuleContext.MULTILINE_STRING_START);
        STNode content = this.parseMultilineStringContent();
        STNode endingDoubleQuote = this.parseTripleDoubleQuoteToken(ParserRuleContext.MULTILINE_STRING_END);
        return STNodeFactory.createStringLiteralNode(startingDoubleQuote, content, endingDoubleQuote);
    }

    private STNode parseMultilineStringContent() {
        STToken nextToken = this.peek();
        if (nextToken.kind == SyntaxKind.IDENTIFIER_LITERAL) {
            return this.consume();
        }
        if (nextToken.kind == SyntaxKind.TRIPLE_DOUBLE_QUOTE_TOKEN) {
            return STNodeFactory.createEmptyNode();
        }
        this.recover(nextToken, ParserRuleContext.MULTILINE_STRING_CONTENT, new Object[0]);
        return this.parseMultilineStringContent();
    }

    private STNode parseLiteralStringValue() {
        STNode startingDoubleQuote = this.parseSingleQuoteToken(ParserRuleContext.LITERAL_STRING_START);
        STNode content = this.parseLiteralStringContent();
        STNode endingDoubleQuote = this.parseSingleQuoteToken(ParserRuleContext.LITERAL_STRING_END);
        return STNodeFactory.createLiteralStringLiteralNode(startingDoubleQuote, content, endingDoubleQuote);
    }

    private STNode parseLiteralStringContent() {
        STToken nextToken = this.peek();
        if (nextToken.kind == SyntaxKind.IDENTIFIER_LITERAL) {
            return this.consume();
        }
        if (nextToken.kind == SyntaxKind.SINGLE_QUOTE_TOKEN) {
            return STNodeFactory.createEmptyNode();
        }
        this.recover(nextToken, ParserRuleContext.LITERAL_STRING_CONTENT, new Object[0]);
        return this.parseLiteralStringContent();
    }

    private STNode parseMultilineLiteralStringValue() {
        STNode startingDoubleQuote = this.parseTripleSingleQuoteToken(ParserRuleContext.MULTILINE_LITERAL_STRING_START);
        STNode content = this.parseMultilineLiteralStringContent();
        STNode endingDoubleQuote = this.parseTripleSingleQuoteToken(ParserRuleContext.MULTILINE_LITERAL_STRING_END);
        return STNodeFactory.createLiteralStringLiteralNode(startingDoubleQuote, content, endingDoubleQuote);
    }

    private STNode parseMultilineLiteralStringContent() {
        STToken nextToken = this.peek();
        if (nextToken.kind == SyntaxKind.IDENTIFIER_LITERAL) {
            return this.consume();
        }
        if (nextToken.kind == SyntaxKind.TRIPLE_SINGLE_QUOTE_TOKEN) {
            return STNodeFactory.createEmptyNode();
        }
        this.recover(nextToken, ParserRuleContext.MULTILINE_LITERAL_STRING_CONTENT, new Object[0]);
        return this.parseMultilineLiteralStringContent();
    }

    private STNode parseSingleQuoteToken(ParserRuleContext ctx) {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.SINGLE_QUOTE_TOKEN) {
            return this.consume();
        }
        this.recover(token, ctx, new Object[0]);
        return this.parseSingleQuoteToken(ctx);
    }

    private STNode parseTripleSingleQuoteToken(ParserRuleContext ctx) {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.TRIPLE_SINGLE_QUOTE_TOKEN) {
            return this.consume();
        }
        this.recover(token, ctx, new Object[0]);
        return this.parseTripleSingleQuoteToken(ctx);
    }

    private STNode parseDoubleQuoteToken(ParserRuleContext ctx) {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.DOUBLE_QUOTE_TOKEN) {
            return this.consume();
        }
        this.recover(token, ctx, new Object[0]);
        return this.parseDoubleQuoteToken(ctx);
    }

    private STNode parseTripleDoubleQuoteToken(ParserRuleContext ctx) {
        STToken token = this.peek();
        if (token.kind == SyntaxKind.TRIPLE_DOUBLE_QUOTE_TOKEN) {
            return this.consume();
        }
        this.recover(token, ctx, new Object[0]);
        return this.parseTripleDoubleQuoteToken(ctx);
    }

    private STNode parseStringContent() {
        STToken nextToken = this.peek();
        if (nextToken.kind == SyntaxKind.IDENTIFIER_LITERAL) {
            return this.consume();
        }
        if (nextToken.kind == SyntaxKind.DOUBLE_QUOTE_TOKEN) {
            return STNodeFactory.createEmptyNode();
        }
        this.recover(nextToken, ParserRuleContext.STRING_CONTENT, new Object[0]);
        return this.parseStringContent();
    }

    private STNode parseArray() {
        STNode openBracket = this.parseOpenBracket(ParserRuleContext.ARRAY_VALUE_LIST_START);
        STNode values = this.parseArrayValues();
        STNode closeBracket = this.parseCloseBracket(ParserRuleContext.ARRAY_VALUE_LIST_END);
        return STNodeFactory.createArrayNode(openBracket, values, closeBracket);
    }

    private STNode parseArrayValues() {
        this.startContext(ParserRuleContext.ARRAY_VALUE_LIST);
        STToken token = this.peek();
        if (this.isEndOfArray(token)) {
            STNode values = STNodeFactory.createEmptyNodeList();
            this.endContext();
            return values;
        }
        STNode firstValue = this.parseArrayValue();
        if (firstValue == null) {
            return STNodeFactory.createEmptyNodeList();
        }
        return this.parseArrayValues(firstValue);
    }

    private boolean isEndOfArray(STToken token) {
        return token.kind == SyntaxKind.CLOSE_BRACKET_TOKEN || token.kind == SyntaxKind.EOF_TOKEN;
    }

    private STNode parseArrayValues(STNode firstValue) {
        STNode valueEnd;
        ArrayList<STNode> valuesList = new ArrayList<STNode>();
        valuesList.add(firstValue);
        STToken nextToken = this.peek();
        while (!this.isEndOfArray(nextToken) && (valueEnd = this.parseValueEnd()) != null) {
            STNode curValue = this.parseArrayValue();
            if (curValue != null) {
                valuesList.add(valueEnd);
                valuesList.add(curValue);
            }
            nextToken = this.peek();
        }
        this.endContext();
        return STNodeFactory.createNodeList(valuesList);
    }

    private STNode parseValueEnd() {
        return switch (this.peek().kind) {
            case SyntaxKind.COMMA_TOKEN -> this.consume();
            case SyntaxKind.CLOSE_BRACKET_TOKEN -> null;
            case SyntaxKind.NEWLINE -> {
                this.consume();
                yield this.parseValueEnd();
            }
            default -> {
                this.recover(this.peek(), ParserRuleContext.ARRAY_VALUE_END, new Object[0]);
                yield this.parseValueEnd();
            }
        };
    }

    private STNode parseArrayValue() {
        STToken nextToken = this.peek();
        return switch (nextToken.kind) {
            case SyntaxKind.DOUBLE_QUOTE_TOKEN -> this.parseStringValue();
            case SyntaxKind.TRIPLE_DOUBLE_QUOTE_TOKEN -> this.parseMultilineStringValue();
            case SyntaxKind.SINGLE_QUOTE_TOKEN -> this.parseLiteralStringValue();
            case SyntaxKind.TRIPLE_SINGLE_QUOTE_TOKEN -> this.parseMultilineLiteralStringValue();
            case SyntaxKind.TRUE_KEYWORD, SyntaxKind.FALSE_KEYWORD, SyntaxKind.DECIMAL_INT_TOKEN, SyntaxKind.DECIMAL_FLOAT_TOKEN -> this.parseValue();
            case SyntaxKind.OPEN_BRACKET_TOKEN -> this.parseArray();
            case SyntaxKind.CLOSE_BRACKET_TOKEN -> null;
            case SyntaxKind.OPEN_BRACE_TOKEN -> this.parseInlineTable();
            case SyntaxKind.NEWLINE -> {
                this.consume();
                yield this.parseArrayValue();
            }
            default -> {
                this.recover(this.peek(), ParserRuleContext.ARRAY_VALUE_START, new Object[0]);
                yield this.parseArrayValue();
            }
        };
    }
}

