/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.semantic.diagnostics;

import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.Location;
import io.ballerina.tools.text.LineRange;
import java.util.Comparator;

public class DiagnosticComparator
implements Comparator<Diagnostic> {
    @Override
    public int compare(Diagnostic d1, Diagnostic d2) {
        int fileComparison;
        Location l1 = d1.location();
        Location l2 = d2.location();
        LineRange lineRange1 = l1.lineRange();
        LineRange lineRange2 = l2.lineRange();
        String file1 = lineRange1.fileName();
        String file2 = lineRange2.fileName();
        if (file1 != null && file2 != null && (fileComparison = file1.compareTo(file2)) != 0) {
            return fileComparison;
        }
        int lineComparison = lineRange1.startLine().line() - lineRange2.startLine().line();
        if (lineComparison != 0) {
            return lineComparison;
        }
        int columnComparison = lineRange1.startLine().offset() - lineRange2.startLine().offset();
        if (columnComparison != 0) {
            return columnComparison;
        }
        int msgComparison = d1.message().compareTo(d2.message());
        if (msgComparison != 0) {
            return msgComparison;
        }
        return d1.hashCode() - d2.hashCode();
    }
}

