/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.validator.schema;

import io.ballerina.toml.semantic.ast.TomlNode;
import io.ballerina.toml.semantic.diagnostics.TomlDiagnostic;
import io.ballerina.toml.validator.ValidationUtil;
import io.ballerina.toml.validator.schema.AbstractSchema;
import io.ballerina.toml.validator.schema.SchemaVisitor;
import io.ballerina.toml.validator.schema.Type;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;

public class CompositionSchema
extends AbstractSchema {
    List<AbstractSchema> schemas;

    public CompositionSchema(Type type, List<AbstractSchema> schemas) {
        super(type, new LinkedHashMap<String, String>(), null, null);
        this.schemas = schemas;
    }

    @Override
    public void accept(SchemaVisitor visitor) {
        visitor.visit(this);
    }

    public List<AbstractSchema> schemas() {
        return this.schemas;
    }

    @Override
    public <T extends TomlNode> List<Diagnostic> validate(T givenValueNode, String key) {
        if (this.type() == Type.ALL_OF) {
            ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
            for (AbstractSchema schema : this.schemas()) {
                List<Diagnostic> validate = schema.validate(givenValueNode, key);
                diagnostics.addAll(validate);
            }
            return diagnostics;
        }
        if (this.type() == Type.ANY_OF) {
            ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
            for (AbstractSchema schema : this.schemas()) {
                List<Diagnostic> validate = schema.validate(givenValueNode, key);
                if (validate.isEmpty()) {
                    return Collections.emptyList();
                }
                diagnostics.addAll(validate);
            }
            TomlDiagnostic diagnostic = ValidationUtil.getTomlDiagnostic(givenValueNode.location(), "TVE0007", "error.no.fields.matched.in.anyOf", DiagnosticSeverity.ERROR, "no fields matched in anyOf schema");
            diagnostics.add(diagnostic);
            return diagnostics;
        }
        if (this.type() == Type.ONE_OF) {
            ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
            TomlDiagnostic diagnostic = ValidationUtil.getTomlDiagnostic(givenValueNode.location(), "TVE0008", "error.must.match.exactly.one.schema", DiagnosticSeverity.ERROR, "must match exactly one schema in oneOf");
            diagnostics.add(diagnostic);
            int matchedCount = 0;
            for (AbstractSchema schema : this.schemas()) {
                List<Diagnostic> diagnosticForString = schema.validate(givenValueNode, key);
                if (diagnosticForString.isEmpty()) {
                    ++matchedCount;
                }
                diagnostics.addAll(diagnosticForString);
            }
            if (matchedCount != 1) {
                return diagnostics;
            }
            return Collections.emptyList();
        }
        if (this.type() == Type.NOT) {
            AbstractSchema schema = this.schemas().get(0);
            List<Diagnostic> diagnosticForString = schema.validate(givenValueNode, key);
            if (diagnosticForString.isEmpty()) {
                TomlDiagnostic diagnostic = ValidationUtil.getTomlDiagnostic(givenValueNode.location(), "TVE0009", "error.schema.rule.must.not.valid", DiagnosticSeverity.ERROR, "schema rules must `NOT` be valid");
                return Collections.singletonList(diagnostic);
            }
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }
}

