/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.types;

import io.ballerina.types.Atom;
import io.ballerina.types.Bdd;
import io.ballerina.types.BddMemo;
import io.ballerina.types.CellSemType;
import io.ballerina.types.Conjunction;
import io.ballerina.types.Context;
import io.ballerina.types.RecAtom;
import io.ballerina.types.SemType;
import io.ballerina.types.SubtypeData;
import io.ballerina.types.subtypedata.AllOrNothingSubtype;
import io.ballerina.types.subtypedata.BddAllOrNothing;
import io.ballerina.types.subtypedata.BddNode;
import io.ballerina.types.typeops.BddCommonOps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;

public class Common {
    public static boolean bddEvery(Context cx, Bdd b, Conjunction pos, Conjunction neg, BddPredicate predicate) {
        if (b instanceof BddAllOrNothing) {
            BddAllOrNothing allOrNothing = (BddAllOrNothing)b;
            return !allOrNothing.isAll() || predicate.apply(cx, pos, neg);
        }
        BddNode bn = (BddNode)b;
        return Common.bddEvery(cx, bn.left(), Conjunction.and(bn.atom(), pos), neg, predicate) && Common.bddEvery(cx, bn.middle(), pos, neg, predicate) && Common.bddEvery(cx, bn.right(), pos, Conjunction.and(bn.atom(), neg), predicate);
    }

    public static boolean bddEveryPositive(Context cx, Bdd b, Conjunction pos, Conjunction neg, BddPredicate predicate) {
        if (b instanceof BddAllOrNothing) {
            BddAllOrNothing allOrNothing = (BddAllOrNothing)b;
            return !allOrNothing.isAll() || predicate.apply(cx, pos, neg);
        }
        BddNode bn = (BddNode)b;
        return Common.bddEveryPositive(cx, bn.left(), Common.andIfPositive(bn.atom(), pos), neg, predicate) && Common.bddEveryPositive(cx, bn.middle(), pos, neg, predicate) && Common.bddEveryPositive(cx, bn.right(), pos, Common.andIfPositive(bn.atom(), neg), predicate);
    }

    public static Conjunction andIfPositive(Atom atom, Conjunction next2) {
        if (atom instanceof RecAtom) {
            RecAtom recAtom = (RecAtom)atom;
            if (recAtom.index < 0) {
                return next2;
            }
        }
        return Conjunction.and(atom, next2);
    }

    public static boolean bddPosMaybeEmpty(Bdd b) {
        if (b instanceof BddAllOrNothing) {
            BddAllOrNothing allOrNothing = (BddAllOrNothing)b;
            return allOrNothing.isAll();
        }
        BddNode bddNode = (BddNode)b;
        return Common.bddPosMaybeEmpty(bddNode.middle()) || Common.bddPosMaybeEmpty(bddNode.right());
    }

    public static SubtypeData bddSubtypeUnion(SubtypeData t1, SubtypeData t2) {
        return BddCommonOps.bddUnion((Bdd)t1, (Bdd)t2);
    }

    public static SubtypeData bddSubtypeIntersect(SubtypeData t1, SubtypeData t2) {
        return BddCommonOps.bddIntersect((Bdd)t1, (Bdd)t2);
    }

    public static SubtypeData bddSubtypeDiff(SubtypeData t1, SubtypeData t2) {
        return BddCommonOps.bddDiff((Bdd)t1, (Bdd)t2);
    }

    public static SubtypeData bddSubtypeComplement(SubtypeData t) {
        return BddCommonOps.bddComplement((Bdd)t);
    }

    public static SemType[] shallowCopyTypes(SemType[] v) {
        return Arrays.copyOf(v, v.length);
    }

    public static CellSemType[] shallowCopyCellTypes(CellSemType[] v) {
        return Common.shallowCopyCellTypes(v, v.length);
    }

    public static CellSemType[] shallowCopyCellTypes(CellSemType[] v, int newLength) {
        return Arrays.copyOf(v, newLength);
    }

    public static List<SemType> shallowCopyTypes(List<SemType> v) {
        return new ArrayList<SemType>(v);
    }

    public static String[] shallowCopyStrings(String[] v, int newLength) {
        return Arrays.copyOf(v, newLength);
    }

    public static boolean notIsEmpty(Context cx, SubtypeData d) {
        return false;
    }

    public static boolean codePointCompare(String s1, String s2) {
        int len2;
        if (s1.equals(s2)) {
            return false;
        }
        int len1 = s1.length();
        if (len1 < (len2 = s2.length()) && s2.substring(0, len1).equals(s1)) {
            return true;
        }
        int cpCount1 = s1.codePointCount(0, len1);
        int cpCount2 = s2.codePointCount(0, len2);
        for (int cp = 0; cp < cpCount1 && cp < cpCount2; ++cp) {
            int codepoint2;
            int codepoint1 = s1.codePointAt(cp);
            if (codepoint1 == (codepoint2 = s2.codePointAt(cp))) {
                continue;
            }
            return codepoint1 < codepoint2;
        }
        return false;
    }

    public static boolean isNothingSubtype(SubtypeData data) {
        AllOrNothingSubtype allOrNothingSubtype;
        return data instanceof AllOrNothingSubtype && (allOrNothingSubtype = (AllOrNothingSubtype)data).isNothingSubtype();
    }

    public static boolean memoSubtypeIsEmpty(Context cx, Map<Bdd, BddMemo> memoTable, BddIsEmptyPredicate isEmptyPredicate, Bdd b) {
        boolean isLoop;
        BddMemo m;
        BddMemo mm = memoTable.get(b);
        if (mm != null) {
            BddMemo.MemoStatus res = mm.isEmpty;
            switch (res) {
                case CYCLIC: {
                    return true;
                }
                case TRUE: 
                case FALSE: {
                    return res == BddMemo.MemoStatus.TRUE;
                }
                case NULL: {
                    m = mm;
                    break;
                }
                case LOOP: 
                case PROVISIONAL: {
                    mm.isEmpty = BddMemo.MemoStatus.LOOP;
                    return true;
                }
                default: {
                    throw new AssertionError((Object)("Unexpected memo status: " + String.valueOf((Object)res)));
                }
            }
        } else {
            m = new BddMemo();
            memoTable.put(b, m);
        }
        m.isEmpty = BddMemo.MemoStatus.PROVISIONAL;
        int initStackDepth = cx.memoStack.size();
        cx.memoStack.add(m);
        boolean isEmpty = (Boolean)isEmptyPredicate.apply(cx, b);
        boolean bl = isLoop = m.isEmpty == BddMemo.MemoStatus.LOOP;
        if (!isEmpty || initStackDepth == 0) {
            for (int i = initStackDepth + 1; i < cx.memoStack.size(); ++i) {
                BddMemo.MemoStatus memoStatus = cx.memoStack.get((int)i).isEmpty;
                if (Objects.requireNonNull(memoStatus) != BddMemo.MemoStatus.PROVISIONAL && memoStatus != BddMemo.MemoStatus.LOOP && memoStatus != BddMemo.MemoStatus.CYCLIC) continue;
                cx.memoStack.get((int)i).isEmpty = isEmpty ? BddMemo.MemoStatus.TRUE : BddMemo.MemoStatus.NULL;
            }
            while (cx.memoStack.size() > initStackDepth) {
                cx.memoStack.subList(initStackDepth, cx.memoStack.size()).clear();
            }
            m.isEmpty = isLoop && isEmpty ? BddMemo.MemoStatus.CYCLIC : (isEmpty ? BddMemo.MemoStatus.TRUE : BddMemo.MemoStatus.FALSE);
        }
        return isEmpty;
    }

    public static boolean isAllSubtype(SubtypeData d) {
        if (d instanceof AllOrNothingSubtype) {
            AllOrNothingSubtype allOrNothingSubtype = (AllOrNothingSubtype)d;
            return allOrNothingSubtype.isAllSubtype();
        }
        return false;
    }

    public static interface BddPredicate {
        public boolean apply(Context var1, Conjunction var2, Conjunction var3);
    }

    public static interface BddIsEmptyPredicate
    extends BiFunction<Context, Bdd, Boolean> {
    }
}

