/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.types.definition;

import io.ballerina.types.Atom;
import io.ballerina.types.BasicTypeCode;
import io.ballerina.types.CellAtomicType;
import io.ballerina.types.CellSemType;
import io.ballerina.types.ComplexSemType;
import io.ballerina.types.Core;
import io.ballerina.types.Definition;
import io.ballerina.types.Env;
import io.ballerina.types.FixedLengthArray;
import io.ballerina.types.ListAtomicType;
import io.ballerina.types.PredefinedType;
import io.ballerina.types.RecAtom;
import io.ballerina.types.SemType;
import io.ballerina.types.subtypedata.BddNode;
import io.ballerina.types.subtypedata.CellSubtype;
import io.ballerina.types.typeops.BddCommonOps;
import java.util.List;

public class ListDefinition
implements Definition {
    private RecAtom rec = null;
    private ComplexSemType semType = null;

    @Override
    public SemType getSemType(Env env) {
        ComplexSemType s = this.semType;
        if (s == null) {
            RecAtom rec;
            this.rec = rec = env.recListAtom();
            return this.createSemType(env, rec);
        }
        return s;
    }

    public SemType tupleTypeWrapped(Env env, SemType ... members) {
        return this.defineListTypeWrapped(env, List.of(members), members.length);
    }

    public SemType tupleTypeWrappedRo(Env env, SemType ... members) {
        return this.defineListTypeWrapped(env, List.of(members), members.length, PredefinedType.NEVER, CellAtomicType.CellMutability.CELL_MUT_NONE);
    }

    public SemType defineListTypeWrapped(Env env, List<SemType> initial, int fixedLength, SemType rest, CellAtomicType.CellMutability mut) {
        assert (rest != null);
        List<CellSemType> initialCells = initial.stream().map(t -> CellSubtype.cellContaining(env, t, mut)).toList();
        CellSemType restCell = CellSubtype.cellContaining(env, Core.union(rest, PredefinedType.UNDEF), Core.isNever(rest) ? CellAtomicType.CellMutability.CELL_MUT_NONE : mut);
        return this.define(env, initialCells, fixedLength, restCell);
    }

    public SemType defineListTypeWrapped(Env env, List<SemType> initial, int size) {
        return this.defineListTypeWrapped(env, initial, size, PredefinedType.NEVER, CellAtomicType.CellMutability.CELL_MUT_LIMITED);
    }

    public SemType defineListTypeWrapped(Env env, List<SemType> initial, int fixedLength, SemType rest) {
        return this.defineListTypeWrapped(env, initial, fixedLength, rest, CellAtomicType.CellMutability.CELL_MUT_LIMITED);
    }

    public SemType defineListTypeWrapped(Env env, SemType rest) {
        return this.defineListTypeWrapped(env, List.of(), 0, rest);
    }

    public SemType defineListTypeWrapped(Env env, SemType rest, CellAtomicType.CellMutability mut) {
        return this.defineListTypeWrapped(env, List.of(), 0, rest, mut);
    }

    public SemType defineListTypeWrapped(Env env, List<SemType> initial, SemType rest) {
        return this.defineListTypeWrapped(env, initial, initial.size(), rest, CellAtomicType.CellMutability.CELL_MUT_LIMITED);
    }

    private ComplexSemType define(Env env, List<CellSemType> initial, int fixedLength, CellSemType rest) {
        Atom atom;
        assert (rest != null);
        FixedLengthArray members = this.fixedLengthNormalize(FixedLengthArray.from(initial, fixedLength));
        ListAtomicType atomicType = ListAtomicType.from(members, rest);
        RecAtom rec = this.rec;
        if (rec != null) {
            atom = rec;
            env.setRecListAtomType(rec, atomicType);
        } else {
            atom = env.listAtom(atomicType);
        }
        return this.createSemType(env, atom);
    }

    private FixedLengthArray fixedLengthNormalize(FixedLengthArray array2) {
        List<CellSemType> initial = array2.initial();
        int i = initial.size() - 1;
        if (i <= 0) {
            return array2;
        }
        SemType last = initial.get(i);
        --i;
        while (i >= 0 && last == initial.get(i)) {
            --i;
        }
        return FixedLengthArray.from(initial.subList(0, i + 2), array2.fixedLength());
    }

    private ComplexSemType createSemType(Env env, Atom atom) {
        ComplexSemType complexSemType;
        BddNode bdd = BddCommonOps.bddAtom(atom);
        this.semType = complexSemType = PredefinedType.basicSubtype(BasicTypeCode.BT_LIST, bdd);
        return complexSemType;
    }
}

