/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.types.definition;

import io.ballerina.types.CellAtomicType;
import io.ballerina.types.Env;
import io.ballerina.types.PredefinedType;
import io.ballerina.types.SemType;
import io.ballerina.types.SemTypes;
import io.ballerina.types.definition.CellField;
import io.ballerina.types.definition.Field;
import io.ballerina.types.definition.MappingDefinition;
import io.ballerina.types.subtypedata.CellSubtype;
import java.util.List;

public record ObjectQualifiers(boolean isolated, boolean readonly, NetworkQualifier networkQualifier) {
    private static final ObjectQualifiers DEFAULT = new ObjectQualifiers(false, false, NetworkQualifier.None);

    public static ObjectQualifiers defaultQualifiers() {
        return DEFAULT;
    }

    public static ObjectQualifiers from(boolean isolated, boolean readonly, NetworkQualifier networkQualifier) {
        if (networkQualifier == NetworkQualifier.None && !isolated) {
            return ObjectQualifiers.defaultQualifiers();
        }
        return new ObjectQualifiers(isolated, readonly, networkQualifier);
    }

    public CellField field(Env env) {
        MappingDefinition md = new MappingDefinition();
        Field isolatedField = new Field("isolated", this.isolated ? SemTypes.booleanConst(true) : PredefinedType.BOOLEAN, true, false);
        Field networkField = this.networkQualifier.field();
        SemType ty = md.defineMappingTypeWrapped(env, List.of(isolatedField, networkField), PredefinedType.NEVER, CellAtomicType.CellMutability.CELL_MUT_NONE);
        return CellField.from("$qualifiers", CellSubtype.cellContaining(env, ty));
    }

    public static enum NetworkQualifier {
        Client,
        Service,
        None;

        private static final SemType CLIENT_TAG;
        private static final Field CLIENT;
        private static final SemType SERVICE_TAG;
        private static final Field SERVICE;
        private static final Field NONE;

        private Field field() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> CLIENT;
                case 1 -> SERVICE;
                case 2 -> NONE;
            };
        }

        static {
            CLIENT_TAG = SemTypes.stringConst("client");
            CLIENT = new Field("network", CLIENT_TAG, true, false);
            SERVICE_TAG = SemTypes.stringConst("service");
            SERVICE = new Field("network", SERVICE_TAG, true, false);
            NONE = new Field("network", SemTypes.union(CLIENT_TAG, SERVICE_TAG), true, false);
        }
    }
}

