/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.types.subtypedata;

import io.ballerina.types.BasicTypeCode;
import io.ballerina.types.CellAtomicType;
import io.ballerina.types.CellSemType;
import io.ballerina.types.ComplexSemType;
import io.ballerina.types.Core;
import io.ballerina.types.Env;
import io.ballerina.types.PredefinedType;
import io.ballerina.types.SemType;
import io.ballerina.types.TypeAtom;
import io.ballerina.types.subtypedata.BddNode;
import io.ballerina.types.typeops.BddCommonOps;

public class CellSubtype {
    public static CellSemType cellContaining(Env env, SemType ty) {
        return CellSubtype.cellContaining(env, ty, CellAtomicType.CellMutability.CELL_MUT_LIMITED);
    }

    public static CellSemType roCellContaining(Env env, SemType ty) {
        return CellSubtype.cellContaining(env, ty, CellAtomicType.CellMutability.CELL_MUT_NONE);
    }

    public static CellSemType cellContaining(Env env, SemType ty, CellAtomicType.CellMutability mut) {
        assert (Core.isNever(ty) || !Core.isSubtypeSimple(ty, PredefinedType.CELL));
        CellAtomicType atomicCell = CellAtomicType.from(ty, mut);
        TypeAtom atom = env.cellAtom(atomicCell);
        BddNode bdd = BddCommonOps.bddAtom(atom);
        ComplexSemType complexSemType = PredefinedType.basicSubtype(BasicTypeCode.BT_CELL, bdd);
        return CellSemType.from(complexSemType.subtypeDataList());
    }
}

