/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.types.subtypedata;

import io.ballerina.types.BasicTypeCode;
import io.ballerina.types.PredefinedType;
import io.ballerina.types.ProperSubtypeData;
import io.ballerina.types.SemType;
import io.ballerina.types.SubtypeData;
import io.ballerina.types.subtypedata.AllOrNothingSubtype;
import io.ballerina.types.subtypedata.Range;
import java.util.Arrays;
import java.util.Optional;
import java.util.StringJoiner;

public class IntSubtype
implements ProperSubtypeData {
    public final Range[] ranges;

    public IntSubtype(Range[] ranges) {
        this.ranges = Arrays.copyOf(ranges, ranges.length);
    }

    public static IntSubtype createIntSubtype(Range ... ranges) {
        return new IntSubtype(ranges);
    }

    public static IntSubtype createSingleRangeSubtype(long min, long max) {
        return new IntSubtype(new Range[]{new Range(min, max)});
    }

    public static SemType intConst(long value2) {
        return PredefinedType.basicSubtype(BasicTypeCode.BT_INT, IntSubtype.createSingleRangeSubtype(value2, value2));
    }

    static void validIntWidth(boolean signed, long bits) {
        if (bits <= 0L) {
            throw IntSubtype.error((bits == 0L ? "zero" : "negative") + " width in bits");
        }
        if (signed) {
            if (bits > 64L) {
                throw IntSubtype.error("width of signed integers limited to 64");
            }
        } else if (bits > 63L) {
            throw IntSubtype.error("width of unsigned integers limited to 63");
        }
    }

    static AssertionError error(String message) {
        return new AssertionError((Object)message);
    }

    public static void validIntWidthSigned(int bits) {
        IntSubtype.validIntWidth(true, bits);
    }

    public static void validIntWidthUnsigned(int bits) {
        IntSubtype.validIntWidth(false, bits);
    }

    public static SemType intWidthSigned(long bits) {
        IntSubtype.validIntWidth(true, bits);
        if (bits == 64L) {
            return PredefinedType.INT;
        }
        IntSubtype t = IntSubtype.createSingleRangeSubtype(-(1L << (int)(bits - 1L)), (1L << (int)(bits - 1L)) - 1L);
        return PredefinedType.basicSubtype(BasicTypeCode.BT_INT, t);
    }

    public static SemType intWidthUnsigned(int bits) {
        IntSubtype.validIntWidth(false, bits);
        IntSubtype t = IntSubtype.createSingleRangeSubtype(0L, (1L << bits) - 1L);
        return PredefinedType.basicSubtype(BasicTypeCode.BT_INT, t);
    }

    public static SubtypeData intSubtypeWidenUnsigned(SubtypeData d) {
        if (d instanceof AllOrNothingSubtype) {
            return d;
        }
        IntSubtype v = (IntSubtype)d;
        if (v.ranges[0].min < 0L) {
            return AllOrNothingSubtype.createAll();
        }
        Range r = v.ranges[v.ranges.length - 1];
        for (long i = 8L; i <= 32L; i *= 2L) {
            if (r.max >= 1L << (int)i) continue;
            IntSubtype w = IntSubtype.createSingleRangeSubtype(0L, (1L << (int)i) - 1L);
            return w;
        }
        return AllOrNothingSubtype.createAll();
    }

    public static Optional<Long> intSubtypeSingleValue(SubtypeData d) {
        if (d instanceof AllOrNothingSubtype) {
            return Optional.empty();
        }
        IntSubtype v = (IntSubtype)d;
        if (v.ranges.length != 1) {
            return Optional.empty();
        }
        long min = v.ranges[0].min;
        if (min != v.ranges[0].max) {
            return Optional.empty();
        }
        return Optional.of(min);
    }

    public static boolean intSubtypeContains(SubtypeData d, long n) {
        if (d instanceof AllOrNothingSubtype) {
            AllOrNothingSubtype allOrNothingSubtype = (AllOrNothingSubtype)d;
            return allOrNothingSubtype.isAllSubtype();
        }
        IntSubtype v = (IntSubtype)d;
        for (Range r : v.ranges) {
            if (r.min > n || n > r.max) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringJoiner j = new StringJoiner(", ", "Int:Range[", "]");
        for (Range r : this.ranges) {
            j.add(this.minusIndi(r.min) + "-" + this.minusIndi(r.max));
        }
        return j.toString();
    }

    private String minusIndi(long i) {
        if (i < 0L) {
            return "(" + i + ")";
        }
        return String.valueOf(i);
    }
}

