/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.types.subtypedata;

import io.ballerina.types.BasicTypeBitSet;
import io.ballerina.types.BasicTypeCode;
import io.ballerina.types.Bdd;
import io.ballerina.types.CellAtomicType;
import io.ballerina.types.Context;
import io.ballerina.types.Core;
import io.ballerina.types.Env;
import io.ballerina.types.FixedLengthArray;
import io.ballerina.types.ListAtomicType;
import io.ballerina.types.PredefinedType;
import io.ballerina.types.SemType;
import io.ballerina.types.SemTypes;
import io.ballerina.types.definition.ListDefinition;

public final class TableSubtype {
    private TableSubtype() {
    }

    public static SemType tableContainingKeyConstraint(Context cx, SemType tableConstraint, SemType keyConstraint) {
        SemType normalizedKc;
        ListAtomicType lat = Core.listAtomicType(cx, keyConstraint);
        if (lat != null && PredefinedType.CELL_ATOMIC_UNDEF.equals(Core.cellAtomicType(lat.rest()))) {
            FixedLengthArray members = lat.members();
            normalizedKc = switch (members.fixedLength()) {
                case 0 -> PredefinedType.VAL;
                case 1 -> Core.cellAtomicType(members.initial().get(0)).ty();
                default -> keyConstraint;
            };
        } else {
            normalizedKc = keyConstraint;
        }
        return TableSubtype.tableContaining(cx.env, tableConstraint, normalizedKc, PredefinedType.VAL);
    }

    public static SemType tableContainingKeySpecifier(Context cx, SemType tableConstraint, String[] fieldNames) {
        SemType normalizedKc;
        SemType[] fieldNameSingletons = new SemType[fieldNames.length];
        SemType[] fieldTypes = new SemType[fieldNames.length];
        for (int i = 0; i < fieldNames.length; ++i) {
            SemType key;
            fieldNameSingletons[i] = key = SemTypes.stringConst(fieldNames[i]);
            fieldTypes[i] = Core.mappingMemberTypeInnerVal(cx, tableConstraint, key);
        }
        SemType normalizedKs = new ListDefinition().tupleTypeWrapped(cx.env, fieldNameSingletons);
        if (fieldTypes.length > 1) {
            ListDefinition ld = new ListDefinition();
            normalizedKc = ld.tupleTypeWrapped(cx.env, fieldTypes);
        } else {
            normalizedKc = fieldTypes[0];
        }
        return TableSubtype.tableContaining(cx.env, tableConstraint, normalizedKc, normalizedKs);
    }

    public static SemType tableContaining(Env env, SemType tableConstraint) {
        return TableSubtype.tableContaining(env, tableConstraint, CellAtomicType.CellMutability.CELL_MUT_LIMITED);
    }

    public static SemType tableContaining(Env env, SemType tableConstraint, CellAtomicType.CellMutability mut) {
        BasicTypeBitSet normalizedKc = PredefinedType.VAL;
        BasicTypeBitSet normalizedKs = PredefinedType.VAL;
        return TableSubtype.tableContaining(env, tableConstraint, normalizedKc, normalizedKs, mut);
    }

    private static SemType tableContaining(Env env, SemType tableConstraint, SemType normalizedKc, SemType normalizedKs, CellAtomicType.CellMutability mut) {
        assert (SemTypes.isSubtypeSimple(tableConstraint, PredefinedType.MAPPING));
        ListDefinition typeParamArrDef = new ListDefinition();
        SemType typeParamArray = typeParamArrDef.defineListTypeWrapped(env, tableConstraint, mut);
        ListDefinition listDef = new ListDefinition();
        SemType tupleType = listDef.tupleTypeWrapped(env, typeParamArray, normalizedKc, normalizedKs);
        Bdd bdd = (Bdd)Core.subtypeData(tupleType, BasicTypeCode.BT_LIST);
        return Core.createBasicSemType(BasicTypeCode.BT_TABLE, bdd);
    }

    private static SemType tableContaining(Env env, SemType tableConstraint, SemType normalizedKc, SemType normalizedKs) {
        return TableSubtype.tableContaining(env, tableConstraint, normalizedKc, normalizedKs, CellAtomicType.CellMutability.CELL_MUT_LIMITED);
    }
}

