/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.types.typeops;

import io.ballerina.types.BasicTypeOps;
import io.ballerina.types.Common;
import io.ballerina.types.Context;
import io.ballerina.types.SubtypeData;
import io.ballerina.types.subtypedata.AllOrNothingSubtype;
import io.ballerina.types.subtypedata.IntSubtype;
import io.ballerina.types.subtypedata.Range;
import io.ballerina.types.subtypedata.RangeUnion;
import java.util.ArrayList;
import java.util.List;

public class IntOps
implements BasicTypeOps {
    private static IntOps intOpsInstance = new IntOps();

    @Override
    public SubtypeData union(SubtypeData d1, SubtypeData d2) {
        IntSubtype v1 = (IntSubtype)d1;
        IntSubtype v2 = (IntSubtype)d2;
        Range[] v = this.rangeListUnion(v1.ranges, v2.ranges);
        if (v.length == 1 && v[0].min == Long.MIN_VALUE && v[0].max == Long.MAX_VALUE) {
            return AllOrNothingSubtype.createAll();
        }
        return IntSubtype.createIntSubtype(v);
    }

    @Override
    public SubtypeData intersect(SubtypeData d1, SubtypeData d2) {
        IntSubtype v1 = (IntSubtype)d1;
        IntSubtype v2 = (IntSubtype)d2;
        Range[] v = this.rangeListIntersect(v1.ranges, v2.ranges);
        if (v.length == 0) {
            return AllOrNothingSubtype.createNothing();
        }
        return IntSubtype.createIntSubtype(v);
    }

    @Override
    public SubtypeData diff(SubtypeData d1, SubtypeData d2) {
        IntSubtype v1 = (IntSubtype)d1;
        IntSubtype v2 = (IntSubtype)d2;
        Range[] v = this.rangeListIntersect(v1.ranges, this.rangeListComplement(v2.ranges));
        if (v.length == 0) {
            return AllOrNothingSubtype.createNothing();
        }
        return IntSubtype.createIntSubtype(v);
    }

    @Override
    public SubtypeData complement(SubtypeData d) {
        IntSubtype v = (IntSubtype)d;
        return IntSubtype.createIntSubtype(this.rangeListComplement(v.ranges));
    }

    static boolean intSubtypeOverlapRange(IntSubtype subtype, Range range2) {
        AllOrNothingSubtype allOrNothingSubtype;
        SubtypeData subtypeData = intOpsInstance.intersect(subtype, IntSubtype.createIntSubtype(range2));
        return !(subtypeData instanceof AllOrNothingSubtype && (allOrNothingSubtype = (AllOrNothingSubtype)subtypeData).isNothingSubtype());
    }

    public static long intSubtypeMax(IntSubtype subtype) {
        return subtype.ranges[subtype.ranges.length - 1].max;
    }

    public static long intSubtypeMin(IntSubtype subtype) {
        return subtype.ranges[0].min;
    }

    @Override
    public boolean isEmpty(Context cx, SubtypeData t) {
        return Common.notIsEmpty(cx, t);
    }

    private Range[] rangeListUnion(Range[] v1, Range[] v2) {
        ArrayList<Range> result = new ArrayList<Range>();
        int i1 = 0;
        int i2 = 0;
        int len1 = v1.length;
        int len2 = v2.length;
        while (true) {
            if (i1 >= len1) {
                if (i2 >= len2) break;
                this.rangeUnionPush(result, v2[i2]);
                ++i2;
                continue;
            }
            if (i2 >= len2) {
                this.rangeUnionPush(result, v1[i1]);
                ++i1;
                continue;
            }
            Range r1 = v1[i1];
            Range r2 = v2[i2];
            RangeUnion combined = this.rangeUnion(r1, r2);
            if (combined.status == 0) {
                this.rangeUnionPush(result, combined.range);
                ++i1;
                ++i2;
                continue;
            }
            if (combined.status < 0) {
                this.rangeUnionPush(result, r1);
                ++i1;
                continue;
            }
            this.rangeUnionPush(result, r2);
            ++i2;
        }
        Range[] rangeList = new Range[result.size()];
        return result.toArray(rangeList);
    }

    private void rangeUnionPush(List<Range> ranges, Range next2) {
        int lastIndex = ranges.size() - 1;
        if (lastIndex < 0) {
            ranges.add(next2);
            return;
        }
        RangeUnion combined = this.rangeUnion(ranges.get(lastIndex), next2);
        if (combined.status == 0) {
            ranges.set(lastIndex, combined.range);
        } else {
            ranges.add(next2);
        }
    }

    private RangeUnion rangeUnion(Range r1, Range r2) {
        if (r1.max < r2.min && r1.max + 1L != r2.min) {
            return RangeUnion.from(-1);
        }
        if (r2.max < r1.min && r2.max + 1L != r1.min) {
            return RangeUnion.from(1);
        }
        return RangeUnion.from(new Range(Long.min(r1.min, r2.min), Long.max(r1.max, r2.max)));
    }

    private Range[] rangeListIntersect(Range[] v1, Range[] v2) {
        ArrayList<Range> result = new ArrayList<Range>();
        int i1 = 0;
        int i2 = 0;
        int len1 = v1.length;
        int len2 = v2.length;
        while (i1 < len1 && i2 < len2) {
            Range r1 = v1[i1];
            Range r2 = v2[i2];
            RangeUnion combined = this.rangeIntersect(r1, r2);
            if (combined.status == 0) {
                result.add(combined.range);
                ++i1;
                ++i2;
                continue;
            }
            if (combined.status < 0) {
                ++i1;
                continue;
            }
            ++i2;
        }
        Range[] rangeList = new Range[result.size()];
        return result.toArray(rangeList);
    }

    private RangeUnion rangeIntersect(Range r1, Range r2) {
        if (r1.max < r2.min) {
            return RangeUnion.from(-1);
        }
        if (r2.max < r1.min) {
            return RangeUnion.from(1);
        }
        return RangeUnion.from(new Range(Long.max(r1.min, r2.min), Long.min(r1.max, r2.max)));
    }

    private Range[] rangeListComplement(Range[] v) {
        ArrayList<Range> result = new ArrayList<Range>();
        int len = v.length;
        long min = v[0].min;
        if (min > Long.MIN_VALUE) {
            result.add(new Range(Long.MIN_VALUE, min - 1L));
        }
        for (int i = 1; i < len; ++i) {
            result.add(new Range(v[i - 1].max + 1L, v[i].min - 1L));
        }
        long max = v[v.length - 1].max;
        if (max < Long.MAX_VALUE) {
            result.add(new Range(max + 1L, Long.MAX_VALUE));
        }
        return result.toArray(new Range[0]);
    }
}

