/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.types.typeops;

import io.ballerina.types.Atom;
import io.ballerina.types.BasicTypeBitSet;
import io.ballerina.types.BasicTypeCode;
import io.ballerina.types.Bdd;
import io.ballerina.types.CellSemType;
import io.ballerina.types.Common;
import io.ballerina.types.ComplexSemType;
import io.ballerina.types.Conjunction;
import io.ballerina.types.Context;
import io.ballerina.types.Core;
import io.ballerina.types.FixedLengthArray;
import io.ballerina.types.ListAtomicType;
import io.ballerina.types.PredefinedType;
import io.ballerina.types.SemType;
import io.ballerina.types.SubtypeData;
import io.ballerina.types.subtypedata.BddAllOrNothing;
import io.ballerina.types.subtypedata.BddNode;
import io.ballerina.types.subtypedata.CellSubtype;
import io.ballerina.types.subtypedata.IntSubtype;
import io.ballerina.types.subtypedata.Range;
import io.ballerina.types.typeops.ListOps;
import io.ballerina.types.typeops.TwoTuple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;

public class ListProj {
    public static SemType listProjInnerVal(Context cx, SemType t, SemType k) {
        if (t instanceof BasicTypeBitSet) {
            BasicTypeBitSet b = (BasicTypeBitSet)t;
            return (b.bitset & PredefinedType.LIST.bitset) != 0 ? PredefinedType.VAL : PredefinedType.NEVER;
        }
        SubtypeData keyData = Core.intSubtype(k);
        if (Common.isNothingSubtype(keyData)) {
            return PredefinedType.NEVER;
        }
        return ListProj.listProjBddInnerVal(cx, keyData, (Bdd)Core.getComplexSubtypeData((ComplexSemType)t, BasicTypeCode.BT_LIST), null, null);
    }

    static SemType listProjBddInnerVal(Context cx, SubtypeData k, Bdd b, Conjunction pos, Conjunction neg) {
        if (b instanceof BddAllOrNothing) {
            BddAllOrNothing allOrNothing = (BddAllOrNothing)b;
            return allOrNothing.isAll() ? ListProj.listProjPathInnerVal(cx, k, pos, neg) : PredefinedType.NEVER;
        }
        BddNode bddNode = (BddNode)b;
        return Core.union(ListProj.listProjBddInnerVal(cx, k, bddNode.left(), Conjunction.and(bddNode.atom(), pos), neg), Core.union(ListProj.listProjBddInnerVal(cx, k, bddNode.middle(), pos, neg), ListProj.listProjBddInnerVal(cx, k, bddNode.right(), pos, Conjunction.and(bddNode.atom(), neg))));
    }

    static SemType listProjPathInnerVal(Context cx, SubtypeData k, Conjunction pos, Conjunction neg) {
        CellSemType rest;
        FixedLengthArray members;
        if (pos == null) {
            members = FixedLengthArray.empty();
            rest = CellSubtype.cellContaining(cx.env, Core.union(PredefinedType.VAL, PredefinedType.UNDEF));
        } else {
            ListAtomicType lt = cx.listAtomType(pos.atom);
            members = lt.members();
            rest = lt.rest();
            Conjunction p = pos.next;
            if (p != null || neg != null) {
                members = ListOps.fixedArrayShallowCopy(members);
            }
            while (p != null) {
                Atom d = p.atom;
                p = p.next;
                lt = cx.listAtomType(d);
                TwoTuple<FixedLengthArray, CellSemType> intersected = ListOps.listIntersectWith(cx.env, members, rest, lt.members(), lt.rest());
                if (intersected == null) {
                    return PredefinedType.NEVER;
                }
                members = (FixedLengthArray)intersected.item1;
                rest = (CellSemType)intersected.item2;
            }
            if (ListOps.fixedArrayAnyEmpty(cx, members)) {
                return PredefinedType.NEVER;
            }
            if (!Core.isNever(Core.cellInnerVal(rest)) && Core.isEmpty(cx, rest)) {
                rest = CellSubtype.roCellContaining(cx.env, PredefinedType.NEVER);
            }
        }
        List indices = ListOps.listSamples(cx, members, rest, neg);
        TwoTuple<List<Integer>, List<Integer>> projSamples = ListProj.listProjSamples(indices, k);
        indices = (List)projSamples.item1;
        TwoTuple<List<CellSemType>, Integer> sampleTypes = ListOps.listSampleTypes(cx, members, rest, indices);
        return ListProj.listProjExcludeInnerVal(cx, (Integer[])((List)projSamples.item1).toArray(Integer[]::new), (Integer[])((List)projSamples.item2).toArray(Integer[]::new), (CellSemType[])((List)sampleTypes.item1).toArray(CellSemType[]::new), (Integer)sampleTypes.item2, neg);
    }

    private static TwoTuple<List<Integer>, List<Integer>> listProjSamples(List<Integer> indices, SubtypeData k) {
        ArrayList<TwoTuple> v = new ArrayList<TwoTuple>();
        for (int i : indices) {
            v.add(TwoTuple.from(i, IntSubtype.intSubtypeContains(k, i)));
        }
        if (k instanceof IntSubtype) {
            IntSubtype intSubtype = (IntSubtype)k;
            for (Range range2 : intSubtype.ranges) {
                long max = range2.max;
                if (range2.max < 0L) continue;
                v.add(TwoTuple.from((int)max, true));
                int min = Integer.max(0, (int)range2.min);
                if ((long)min >= max) continue;
                v.add(TwoTuple.from(min, true));
            }
        }
        v.sort(Comparator.comparingInt(p -> (Integer)p.item1));
        ArrayList<Integer> indices1 = new ArrayList<Integer>();
        ArrayList<Integer> keyIndices = new ArrayList<Integer>();
        for (TwoTuple ib : v) {
            if (!indices1.isEmpty() && Objects.equals(ib.item1, indices1.get(indices1.size() - 1))) continue;
            if (((Boolean)ib.item2).booleanValue()) {
                keyIndices.add(indices1.size());
            }
            indices1.add((Integer)ib.item1);
        }
        return TwoTuple.from(indices1, keyIndices);
    }

    static SemType listProjExcludeInnerVal(Context cx, Integer[] indices, Integer[] keyIndices, CellSemType[] memberTypes, int nRequired, Conjunction neg) {
        SemType p = PredefinedType.NEVER;
        if (neg == null) {
            int len = memberTypes.length;
            Integer[] integerArray = keyIndices;
            int n = integerArray.length;
            for (int i = 0; i < n; ++i) {
                int k = integerArray[i];
                if (k >= len) continue;
                p = Core.union(p, Core.cellInnerVal(memberTypes[k]));
            }
        } else {
            CellSemType[] t;
            ListAtomicType nt = cx.listAtomType(neg.atom);
            if (nRequired > 0 && Core.isNever(ListOps.listMemberAtInnerVal(nt.members(), nt.rest(), indices[nRequired - 1]))) {
                return ListProj.listProjExcludeInnerVal(cx, indices, keyIndices, memberTypes, nRequired, neg.next);
            }
            int negLen = nt.members().fixedLength();
            if (negLen > 0) {
                int len = memberTypes.length;
                if (len < indices.length && indices[len] < negLen) {
                    return ListProj.listProjExcludeInnerVal(cx, indices, keyIndices, memberTypes, nRequired, neg.next);
                }
                for (int i = nRequired; i < memberTypes.length && indices[i] < negLen; ++i) {
                    t = Arrays.copyOfRange(memberTypes, 0, i);
                    p = Core.union(p, ListProj.listProjExcludeInnerVal(cx, indices, keyIndices, t, nRequired, neg.next));
                }
            }
            for (int i = 0; i < memberTypes.length; ++i) {
                SemType d = Core.diff(Core.cellInnerVal(memberTypes[i]), ListOps.listMemberAtInnerVal(nt.members(), nt.rest(), indices[i]));
                if (Core.isEmpty(cx, d)) continue;
                t = (CellSemType[])memberTypes.clone();
                t[i] = CellSubtype.cellContaining(cx.env, d);
                p = Core.union(p, ListProj.listProjExcludeInnerVal(cx, indices, keyIndices, t, Integer.max(nRequired, i + 1), neg.next));
            }
        }
        return p;
    }
}

