/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.api.internal;

import io.opentelemetry.api.internal.Contract;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class StringUtils {
    @Contract(value="null -> true")
    public static boolean isNullOrEmpty(@Nullable String string2) {
        return string2 == null || string2.isEmpty();
    }

    public static String padLeft(String value2, int minLength) {
        return StringUtils.padStart(value2, minLength, '0');
    }

    private static String padStart(String string2, int minLength, char padChar) {
        Objects.requireNonNull(string2);
        if (string2.length() >= minLength) {
            return string2;
        }
        StringBuilder sb = new StringBuilder(minLength);
        for (int i = string2.length(); i < minLength; ++i) {
            sb.append(padChar);
        }
        sb.append(string2);
        return sb.toString();
    }

    public static boolean isPrintableString(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (StringUtils.isPrintableChar(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isPrintableChar(char ch) {
        return ch >= ' ' && ch <= '~';
    }

    private StringUtils() {
    }
}

