/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.core.stream.serializer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.axiom.core.stream.CharacterData;
import org.apache.axiom.core.stream.CharacterDataSink;
import org.apache.axiom.core.stream.StreamException;
import org.apache.axiom.core.stream.XmlHandler;
import org.apache.axiom.core.stream.serializer.IllegalCharacterSequenceException;
import org.apache.axiom.core.stream.serializer.SerializerWriter;
import org.apache.axiom.core.stream.serializer.writer.UnmappableCharacterHandler;
import org.apache.axiom.core.stream.serializer.writer.WriterXmlWriter;
import org.apache.axiom.core.stream.serializer.writer.XmlWriter;
import org.apache.axiom.util.base64.AbstractBase64EncodingOutputStream;

public final class Serializer
implements XmlHandler,
CharacterDataSink {
    private static final int CHUNK_SIZE = 4096;
    private static final int MIXED_CONTENT = 0;
    private static final int TAG = 1;
    private static final int ATTRIBUTE_VALUE = 2;
    private static final int COMMENT = 3;
    private static final int PROCESSING_INSTRUCTION = 4;
    private static final int CDATA_SECTION = 5;
    private static final String[] illegalCharacterSequences = new String[]{null, null, null, "--", "?>", "]]>"};
    private static final UnmappableCharacterHandler[] unmappableCharacterHandlers = new UnmappableCharacterHandler[]{UnmappableCharacterHandler.CONVERT_TO_CHARACTER_REFERENCE, UnmappableCharacterHandler.THROW_EXCEPTION, UnmappableCharacterHandler.CONVERT_TO_CHARACTER_REFERENCE, UnmappableCharacterHandler.THROW_EXCEPTION, UnmappableCharacterHandler.THROW_EXCEPTION, UnmappableCharacterHandler.THROW_EXCEPTION};
    private final XmlWriter writer;
    private final OutputStream outputStream;
    protected boolean spaceBeforeClose = false;
    protected boolean inDoctype = false;
    private int context = 0;
    private int matchedIllegalCharacters;
    private int squareBrackets;
    private String[] elementNameStack = new String[8];
    private int depth;
    private boolean startTagOpen;
    private final char[] charsBuff = new char[4096];

    public Serializer(Writer out) {
        this.writer = new WriterXmlWriter(out);
        this.outputStream = null;
    }

    public Serializer(OutputStream out, String encoding) {
        this.writer = XmlWriter.create(out, encoding);
        this.outputStream = out;
    }

    private void switchContext(int context) throws StreamException {
        this.context = context;
        try {
            this.writer.setUnmappableCharacterHandler(unmappableCharacterHandlers[context]);
        }
        catch (IOException ex) {
            throw new StreamException(ex);
        }
        this.matchedIllegalCharacters = 0;
        this.squareBrackets = 0;
    }

    public OutputStream getOutputStream() throws StreamException {
        if (this.outputStream != null) {
            this.closeStartTag();
            this.flushBuffer();
            return this.outputStream;
        }
        return null;
    }

    public void elementDecl(String name, String model) throws StreamException {
        try {
            this.DTDprolog();
            this.writer.write("<!ELEMENT ");
            this.writer.write(name);
            this.writer.write(' ');
            this.writer.write(model);
            this.writer.write(">\n");
        }
        catch (IOException ex) {
            throw new StreamException(ex);
        }
    }

    public void internalEntityDecl(String name, String value2) throws StreamException {
        try {
            this.DTDprolog();
            this.outputEntityDecl(name, value2);
        }
        catch (IOException ex) {
            throw new StreamException(ex);
        }
    }

    private void outputEntityDecl(String name, String value2) throws IOException {
        this.writer.write("<!ENTITY ");
        this.writer.write(name);
        this.writer.write(" \"");
        this.writer.write(value2);
        this.writer.write("\">\n");
    }

    @Override
    public void startDocument(String inputEncoding, String xmlVersion, String xmlEncoding, Boolean standalone) throws StreamException {
        this.switchContext(1);
        try {
            this.writer.write("<?xml version=\"");
            this.writer.write(xmlVersion == null ? "1.0" : xmlVersion);
            this.writer.write('\"');
            if (xmlEncoding != null) {
                this.writer.write(" encoding=\"");
                this.writer.write(xmlEncoding);
                this.writer.write('\"');
            }
            if (standalone != null) {
                this.writer.write(" standalone=\"");
                this.writer.write(standalone != false ? "yes" : "no");
                this.writer.write('\"');
            }
            this.writer.write("?>");
        }
        catch (IOException ex) {
            throw new StreamException(ex);
        }
        this.switchContext(0);
    }

    @Override
    public void startFragment() throws StreamException {
    }

    public void attributeDecl(String eName, String aName, String type, String valueDefault, String value2) throws StreamException {
        try {
            this.DTDprolog();
            this.writer.write("<!ATTLIST ");
            this.writer.write(eName);
            this.writer.write(' ');
            this.writer.write(aName);
            this.writer.write(' ');
            this.writer.write(type);
            if (valueDefault != null) {
                this.writer.write(' ');
                this.writer.write(valueDefault);
            }
            this.writer.write(">\n");
        }
        catch (IOException ex) {
            throw new StreamException(ex);
        }
    }

    public void externalEntityDecl(String name, String publicId, String systemId) throws StreamException {
        try {
            this.DTDprolog();
            this.writer.write("<!ENTITY ");
            this.writer.write(name);
            if (publicId != null) {
                this.writer.write(" PUBLIC \"");
                this.writer.write(publicId);
            } else {
                this.writer.write(" SYSTEM \"");
                this.writer.write(systemId);
            }
            this.writer.write("\" >\n");
        }
        catch (IOException ex) {
            throw new StreamException(ex);
        }
    }

    public void characters(char[] chars, int start, int length) throws StreamException {
        if (length == 0) {
            return;
        }
        XmlWriter writer = this.writer;
        int context = this.context;
        String illegalCharacterSequence = illegalCharacterSequences[context];
        try {
            int i;
            int end = start + length;
            int lastDirtyCharProcessed = start - 1;
            int matchedIllegalCharacters = this.matchedIllegalCharacters;
            int squareBrackets = this.squareBrackets;
            for (i = start; i < end; ++i) {
                boolean generateCharacterReference;
                String replacement;
                char ch;
                block32: {
                    block34: {
                        block33: {
                            ch = chars[i];
                            if (illegalCharacterSequence != null) {
                                while (true) {
                                    int offset;
                                    if (ch == illegalCharacterSequence.charAt(matchedIllegalCharacters)) {
                                        if (++matchedIllegalCharacters != illegalCharacterSequence.length()) break;
                                        throw new IllegalCharacterSequenceException("Illegal character sequence \"" + illegalCharacterSequence + "\"");
                                    }
                                    if (matchedIllegalCharacters <= 0) break;
                                    block15: for (offset = 1; offset < matchedIllegalCharacters; ++offset) {
                                        for (int j = 0; j < matchedIllegalCharacters - offset; ++j) {
                                            if (illegalCharacterSequence.charAt(j) == illegalCharacterSequence.charAt(j + offset)) continue;
                                            continue block15;
                                        }
                                    }
                                    matchedIllegalCharacters -= offset;
                                }
                            }
                            replacement = null;
                            generateCharacterReference = false;
                            if (context != 0 && context != 2) break block32;
                            if (ch > '\u001f') break block33;
                            switch (ch) {
                                case '\t': {
                                    if (context == 2) {
                                        replacement = "&#9;";
                                        break;
                                    }
                                    break block34;
                                }
                                case '\n': {
                                    if (context == 2) {
                                        replacement = "&#10;";
                                        break;
                                    }
                                    break block34;
                                }
                                case '\r': {
                                    replacement = "&#13;";
                                    break;
                                }
                                default: {
                                    generateCharacterReference = true;
                                    break;
                                }
                            }
                            break block34;
                        }
                        if (ch < '\u007f') {
                            switch (ch) {
                                case '<': {
                                    replacement = "&lt;";
                                    break;
                                }
                                case '>': {
                                    if (context != 0 || squareBrackets < 2) break;
                                    replacement = "&gt;";
                                    break;
                                }
                                case '&': {
                                    replacement = "&amp;";
                                    break;
                                }
                                case '\"': {
                                    if (context != 2) break;
                                    replacement = "&quot;";
                                }
                            }
                        } else if (ch <= '\u009f') {
                            generateCharacterReference = true;
                        } else if (ch == '\u2028') {
                            replacement = "&#8232;";
                        }
                    }
                    squareBrackets = ch == ']' ? ++squareBrackets : 0;
                }
                int startClean = lastDirtyCharProcessed + 1;
                int lengthClean = i - startClean;
                if (replacement == null && !generateCharacterReference && lengthClean != 4096) continue;
                if (startClean < i) {
                    writer.write(chars, startClean, lengthClean);
                }
                if (replacement != null) {
                    writer.write(replacement);
                } else if (generateCharacterReference) {
                    writer.writeCharacterReference(ch);
                }
                lastDirtyCharProcessed = i;
            }
            int startClean = lastDirtyCharProcessed + 1;
            if (i > startClean) {
                int lengthClean = i - startClean;
                writer.write(chars, startClean, lengthClean);
            }
            this.matchedIllegalCharacters = matchedIllegalCharacters;
            this.squareBrackets = squareBrackets;
        }
        catch (IOException ex) {
            throw new StreamException(ex);
        }
    }

    private void characters(String s) throws StreamException {
        this.characters(s, 0, s.length());
    }

    void characters(String s, int start, int length) throws StreamException {
        while (length > 0) {
            int count = Math.min(length, 4096);
            s.getChars(start, start + count, this.charsBuff, 0);
            this.characters(this.charsBuff, 0, count);
            start += count;
            length -= count;
        }
    }

    @Override
    public Writer getWriter() {
        return new SerializerWriter(this);
    }

    @Override
    public AbstractBase64EncodingOutputStream getBase64EncodingOutputStream() {
        return this.writer.getBase64EncodingOutputStream();
    }

    @Override
    public void processCharacterData(Object data, boolean ignorable) throws StreamException {
        this.closeStartTag();
        if (data instanceof CharacterData) {
            try {
                ((CharacterData)data).writeTo(this);
            }
            catch (IOException ex) {
                Throwable cause = ex.getCause();
                if (cause instanceof StreamException) {
                    throw (StreamException)cause;
                }
                throw new StreamException(ex);
            }
        } else {
            this.characters(data.toString());
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String prefix) throws StreamException {
        this.closeStartTag();
        try {
            this.switchContext(1);
            this.writer.write('<');
            if (!prefix.isEmpty()) {
                this.writer.write(prefix);
                this.writer.write(':');
            }
            this.writer.write(localName);
        }
        catch (IOException e) {
            throw new StreamException(e);
        }
        if (2 * (this.depth + 1) > this.elementNameStack.length) {
            String[] newElementNameStack = new String[this.elementNameStack.length * 2];
            System.arraycopy(this.elementNameStack, 0, newElementNameStack, 0, this.elementNameStack.length);
            this.elementNameStack = newElementNameStack;
        }
        this.elementNameStack[2 * this.depth] = prefix;
        this.elementNameStack[2 * this.depth + 1] = localName;
        ++this.depth;
        this.startTagOpen = true;
    }

    @Override
    public void processDocumentTypeDeclaration(String rootName, String publicId, String systemId, String internalSubset) throws StreamException {
        this.startDTD(rootName, publicId, systemId);
        if (internalSubset != null) {
            this.writeInternalSubset(internalSubset);
        }
        this.endDTD();
    }

    public void startDTD(String name, String publicId, String systemId) throws StreamException {
        this.inDoctype = true;
        try {
            this.writer.write("<!DOCTYPE ");
            this.writer.write(name);
            if (publicId != null) {
                this.writer.write(" PUBLIC \"");
                this.writer.write(publicId);
                this.writer.write('\"');
            }
            if (systemId != null) {
                if (publicId == null) {
                    this.writer.write(" SYSTEM \"");
                } else {
                    this.writer.write(" \"");
                }
                this.writer.write(systemId);
                this.writer.write('\"');
            }
        }
        catch (IOException ex) {
            throw new StreamException(ex);
        }
    }

    private void writeAttribute(String prefix, String localName, String value2) throws StreamException {
        try {
            this.writer.write(' ');
            if (!prefix.isEmpty()) {
                this.writer.write(prefix);
                this.writer.write(':');
            }
            this.writer.write(localName);
            this.writer.write("=\"");
            if (!value2.isEmpty()) {
                this.switchContext(2);
                this.characters(value2);
                this.switchContext(1);
            }
            this.writer.write('\"');
        }
        catch (IOException ex) {
            throw new StreamException(ex);
        }
    }

    @Override
    public void processNamespaceDeclaration(String prefix, String namespaceURI) throws StreamException {
        if (prefix.isEmpty()) {
            this.writeAttribute("", "xmlns", namespaceURI);
        } else {
            this.writeAttribute("xmlns", prefix, namespaceURI);
        }
    }

    @Override
    public void processAttribute(String namespaceURI, String localName, String prefix, String value2, String type, boolean specified) throws StreamException {
        this.writeAttribute(prefix, localName, value2);
    }

    @Override
    public void processAttribute(String name, String value2, String type, boolean specified) throws StreamException {
        this.writeAttribute("", name, value2);
    }

    @Override
    public void attributesCompleted() throws StreamException {
    }

    @Override
    public void endElement() throws StreamException {
        --this.depth;
        try {
            if (this.startTagOpen) {
                if (this.spaceBeforeClose) {
                    this.writer.write(" />");
                } else {
                    this.writer.write("/>");
                }
            } else {
                this.switchContext(1);
                this.writer.write("</");
                String prefix = this.elementNameStack[2 * this.depth];
                if (!prefix.isEmpty()) {
                    this.writer.write(prefix);
                    this.writer.write(':');
                }
                this.writer.write(this.elementNameStack[2 * this.depth + 1]);
                this.writer.write('>');
            }
            this.switchContext(0);
        }
        catch (IOException ex) {
            throw new StreamException(ex);
        }
        this.startTagOpen = false;
    }

    @Override
    public void startComment() throws StreamException {
        this.closeStartTag();
        try {
            this.writer.write("<!--");
        }
        catch (IOException ex) {
            throw new StreamException(ex);
        }
        this.switchContext(3);
    }

    @Override
    public void endComment() throws StreamException {
        try {
            this.writer.write("-->");
        }
        catch (IOException ex) {
            throw new StreamException(ex);
        }
        this.switchContext(0);
    }

    @Override
    public void endCDATASection() throws StreamException {
        try {
            this.writer.write("]]>");
        }
        catch (IOException ex) {
            throw new StreamException(ex);
        }
        this.switchContext(0);
    }

    public void endDTD() throws StreamException {
        try {
            if (!this.inDoctype) {
                this.writer.write("]>");
            } else {
                this.writer.write('>');
            }
        }
        catch (IOException ex) {
            throw new StreamException(ex);
        }
    }

    @Override
    public void startCDATASection() throws StreamException {
        this.closeStartTag();
        try {
            this.writer.write("<![CDATA[");
        }
        catch (IOException ex) {
            throw new StreamException(ex);
        }
        this.switchContext(5);
    }

    private void closeStartTag() throws StreamException {
        if (this.startTagOpen) {
            try {
                this.writer.write('>');
                this.switchContext(0);
            }
            catch (IOException ex) {
                throw new StreamException(ex);
            }
            this.startTagOpen = false;
        }
    }

    @Override
    public void startProcessingInstruction(String target) throws StreamException {
        this.closeStartTag();
        this.switchContext(1);
        try {
            this.writer.write("<?");
            this.writer.write(target);
            this.writer.write(' ');
        }
        catch (IOException ex) {
            throw new StreamException(ex);
        }
        this.switchContext(4);
    }

    @Override
    public void endProcessingInstruction() throws StreamException {
        try {
            this.writer.write("?>");
        }
        catch (IOException ex) {
            throw new StreamException(ex);
        }
        this.switchContext(0);
    }

    public void writeInternalSubset(String internalSubset) throws StreamException {
        try {
            this.DTDprolog();
            this.writer.write(internalSubset);
        }
        catch (IOException ex) {
            throw new StreamException(ex);
        }
    }

    public void flushBuffer() throws StreamException {
        try {
            this.writer.flushBuffer();
        }
        catch (IOException ex) {
            throw new StreamException(ex);
        }
    }

    public void notationDecl(String name, String pubID, String sysID) throws StreamException {
        try {
            this.DTDprolog();
            this.writer.write("<!NOTATION ");
            this.writer.write(name);
            if (pubID != null) {
                this.writer.write(" PUBLIC \"");
                this.writer.write(pubID);
            } else {
                this.writer.write(" SYSTEM \"");
                this.writer.write(sysID);
            }
            this.writer.write("\" >\n");
        }
        catch (IOException ex) {
            throw new StreamException(ex);
        }
    }

    public void unparsedEntityDecl(String name, String pubID, String sysID, String notationName) throws StreamException {
        try {
            this.DTDprolog();
            this.writer.write("<!ENTITY ");
            this.writer.write(name);
            if (pubID != null) {
                this.writer.write(" PUBLIC \"");
                this.writer.write(pubID);
            } else {
                this.writer.write(" SYSTEM \"");
                this.writer.write(sysID);
            }
            this.writer.write("\" NDATA ");
            this.writer.write(notationName);
            this.writer.write(" >\n");
        }
        catch (IOException ex) {
            throw new StreamException(ex);
        }
    }

    private void DTDprolog() throws IOException {
        if (this.inDoctype) {
            this.writer.write(" [\n");
            this.inDoctype = false;
        }
    }

    public void writeRaw(String s, UnmappableCharacterHandler unmappableCharacterHandler) throws StreamException {
        try {
            this.writer.setUnmappableCharacterHandler(unmappableCharacterHandler);
            this.writer.write(s);
            this.writer.setUnmappableCharacterHandler(unmappableCharacterHandlers[this.context]);
        }
        catch (IOException ex) {
            throw new StreamException(ex);
        }
    }

    @Override
    public void processEntityReference(String name, String replacementText) throws StreamException {
        this.closeStartTag();
        try {
            this.writer.write('&');
            this.writer.write(name);
            this.writer.write(';');
        }
        catch (IOException ex) {
            throw new StreamException(ex);
        }
    }

    @Override
    public void completed() throws StreamException {
        this.flushBuffer();
    }

    @Override
    public boolean drain() throws StreamException {
        return true;
    }
}

