/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.core.stream.stax.push.input;

import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.core.stream.NamespaceContextProvider;
import org.apache.axiom.core.stream.StreamException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XMLStreamWriterNamespaceContextProvider
implements NamespaceContextProvider {
    private static final Log log = LogFactory.getLog(XMLStreamWriterNamespaceContextProvider.class);
    private final XMLStreamWriter writer;

    public XMLStreamWriterNamespaceContextProvider(XMLStreamWriter writer) {
        this.writer = writer;
    }

    @Override
    public boolean isBound(String prefix, String namespace) throws StreamException {
        try {
            String writerNS;
            NamespaceContext nsContext;
            block10: {
                if ("xml".equals(prefix)) {
                    return true;
                }
                prefix = prefix == null ? "" : prefix;
                String string2 = namespace = namespace == null ? "" : namespace;
                if (namespace.length() > 0) {
                    NamespaceContext nsContext2;
                    String writerPrefix = this.writer.getPrefix(namespace);
                    if (prefix.equals(writerPrefix)) {
                        return true;
                    }
                    if (writerPrefix != null && (nsContext2 = this.writer.getNamespaceContext()) != null) {
                        String writerNS2 = nsContext2.getNamespaceURI(prefix);
                        return namespace.equals(writerNS2);
                    }
                    return false;
                }
                if (prefix.length() > 0) {
                    throw new StreamException("Invalid namespace declaration: Prefixed namespace bindings may not be empty.");
                }
                try {
                    String writerPrefix = this.writer.getPrefix("");
                    if (writerPrefix != null && writerPrefix.length() == 0) {
                        return true;
                    }
                }
                catch (Throwable t) {
                    if (!log.isDebugEnabled()) break block10;
                    log.debug("Caught exception from getPrefix(\"\"). Processing continues: " + t);
                }
            }
            return (nsContext = this.writer.getNamespaceContext()) == null || (writerNS = nsContext.getNamespaceURI("")) == null || writerNS.length() <= 0;
        }
        catch (XMLStreamException ex) {
            throw new StreamException(ex);
        }
    }
}

