/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.core.stream.xop;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.xml.namespace.QName;
import org.apache.axiom.core.stream.StreamException;
import org.apache.axiom.core.stream.XmlHandler;
import org.apache.axiom.core.stream.XmlHandlerWrapper;

public abstract class AbstractXOPDecodingFilterHandler
extends XmlHandlerWrapper {
    private static final String SOLE_CHILD_MSG = "Expected xop:Include as the sole child of an element information item (see section 3.2 of http://www.w3.org/TR/xop10/)";
    private State state = State.CONTENT_SEEN;
    private String contentID;

    public AbstractXOPDecodingFilterHandler(XmlHandler parent) {
        super(parent);
    }

    protected abstract Object buildCharacterData(String var1) throws StreamException;

    private void inContent() throws StreamException {
        switch (this.state) {
            case IN_XOP_INCLUDE: {
                throw new StreamException("Expected xop:Include element information item to be empty");
            }
            case AFTER_XOP_INCLUDE: {
                throw new StreamException(SOLE_CHILD_MSG);
            }
        }
        this.state = State.CONTENT_SEEN;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startElement(String namespaceURI, String localName, String prefix) throws StreamException {
        if (localName.equals("Include") && namespaceURI.equals("http://www.w3.org/2004/08/xop/include")) {
            if (this.state != State.AFTER_START_ELEMENT) throw new StreamException(SOLE_CHILD_MSG);
            this.state = State.IN_XOP_INCLUDE;
            return;
        } else {
            this.inContent();
            super.startElement(namespaceURI, localName, prefix);
        }
    }

    @Override
    public void endElement() throws StreamException {
        if (this.state == State.IN_XOP_INCLUDE) {
            if (this.contentID == null) {
                throw new StreamException("No href attribute found on xop:Include element");
            }
            super.processCharacterData(this.buildCharacterData(this.contentID), false);
            this.contentID = null;
            this.state = State.AFTER_XOP_INCLUDE;
        } else {
            this.state = State.CONTENT_SEEN;
            super.endElement();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void processAttribute(String namespaceURI, String localName, String prefix, String value2, String type, boolean specified) throws StreamException {
        if (this.state == State.IN_XOP_INCLUDE) {
            if (!namespaceURI.isEmpty() || !localName.equals("href")) throw new StreamException("Encountered unexpected attribute " + new QName(namespaceURI, localName) + " on xop:Include element");
            if (!value2.startsWith("cid:")) {
                throw new StreamException("Expected href attribute containing a URL in the cid scheme");
            }
            try {
                this.contentID = URLDecoder.decode(value2.substring(4), "ascii");
                return;
            }
            catch (UnsupportedEncodingException ex) {
                throw new StreamException(ex);
            }
        } else {
            super.processAttribute(namespaceURI, localName, prefix, value2, type, specified);
        }
    }

    @Override
    public void processNamespaceDeclaration(String prefix, String namespaceURI) throws StreamException {
        if (this.state != State.IN_XOP_INCLUDE) {
            super.processNamespaceDeclaration(prefix, namespaceURI);
        }
    }

    @Override
    public void attributesCompleted() throws StreamException {
        if (this.state != State.IN_XOP_INCLUDE) {
            super.attributesCompleted();
            this.state = State.AFTER_START_ELEMENT;
        }
    }

    @Override
    public void processCharacterData(Object data, boolean ignorable) throws StreamException {
        this.inContent();
        super.processCharacterData(data, ignorable);
    }

    @Override
    public void startProcessingInstruction(String target) throws StreamException {
        this.inContent();
        super.startProcessingInstruction(target);
    }

    @Override
    public void endProcessingInstruction() throws StreamException {
        this.inContent();
        super.endProcessingInstruction();
    }

    @Override
    public void startComment() throws StreamException {
        this.inContent();
        super.startComment();
    }

    @Override
    public void endComment() throws StreamException {
        this.inContent();
        super.endComment();
    }

    @Override
    public void startCDATASection() throws StreamException {
        this.inContent();
        super.startCDATASection();
    }

    @Override
    public void endCDATASection() throws StreamException {
        this.inContent();
        super.endCDATASection();
    }

    @Override
    public void processEntityReference(String name, String replacementText) throws StreamException {
        this.inContent();
        super.processEntityReference(name, replacementText);
    }

    private static enum State {
        AFTER_START_ELEMENT,
        CONTENT_SEEN,
        IN_XOP_INCLUDE,
        AFTER_XOP_INCLUDE;

    }
}

