/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.dom.impl.mixin;

import org.apache.axiom.core.CoreChildNode;
import org.apache.axiom.core.CoreModelException;
import org.apache.axiom.dom.DOMExceptionUtil;
import org.apache.axiom.dom.DOMSemantics;
import org.apache.axiom.dom.DOMText;
import org.apache.axiom.dom.DOMTextNode;
import org.apache.axiom.weaver.annotation.Mixin;
import org.w3c.dom.DOMException;
import org.w3c.dom.Text;

@Mixin
public abstract class DOMTextNodeMixin
implements DOMTextNode {
    private DOMTextNode getWholeTextStartNode() {
        CoreChildNode sibling;
        DOMTextNode first = this;
        while ((sibling = first.coreGetPreviousSibling()) instanceof DOMTextNode) {
            first = (DOMTextNode)sibling;
        }
        return first;
    }

    private DOMTextNode getWholeTextEndNode() {
        try {
            CoreChildNode sibling;
            DOMTextNode last = this;
            while ((sibling = last.coreGetNextSibling()) instanceof DOMTextNode) {
                last = (DOMTextNode)sibling;
            }
            return last;
        }
        catch (CoreModelException ex) {
            throw DOMExceptionUtil.toUncheckedException(ex);
        }
    }

    @Override
    public final String getWholeText() {
        try {
            DOMTextNode first = this.getWholeTextStartNode();
            DOMTextNode last = this.getWholeTextEndNode();
            if (first == last) {
                return first.getData();
            }
            StringBuilder buffer = new StringBuilder();
            DOMTextNode current = first;
            while (true) {
                buffer.append(current.getData());
                if (current == last) break;
                current = (DOMTextNode)current.coreGetNextSibling();
            }
            return buffer.toString();
        }
        catch (CoreModelException ex) {
            throw DOMExceptionUtil.toUncheckedException(ex);
        }
    }

    @Override
    public final Text replaceWholeText(String content) throws DOMException {
        try {
            DOMText newText;
            if (content.length() > 0) {
                newText = this.getDOMNodeFactory().createCharacterDataNode();
                newText.coreSetCharacterData(content);
            } else {
                newText = null;
            }
            if (this.coreHasParent()) {
                DOMTextNode next2;
                DOMTextNode first = this.getWholeTextStartNode();
                DOMTextNode last = this.getWholeTextEndNode();
                if (newText != null) {
                    first.coreInsertSiblingBefore(newText);
                }
                DOMTextNode current = first;
                do {
                    next2 = current == last ? null : (DOMTextNode)current.coreGetNextSibling();
                    current.coreDetach(DOMSemantics.INSTANCE);
                    current = next2;
                } while (next2 != null);
            }
            return newText;
        }
        catch (CoreModelException ex) {
            throw DOMExceptionUtil.toUncheckedException(ex);
        }
    }

    @Override
    public final Text splitText(int offset) throws DOMException {
        try {
            String value2 = this.getData();
            if (offset < 0 || offset > value2.length()) {
                throw DOMExceptionUtil.newDOMException((short)1);
            }
            String newValue = value2.substring(offset);
            this.deleteData(offset, value2.length());
            DOMText newText = this.getDOMNodeFactory().createCharacterDataNode();
            newText.coreSetCharacterData(newValue);
            if (this.coreHasParent()) {
                this.coreInsertSiblingAfter(newText);
            } else {
                newText.coreSetOwnerDocument(this.coreGetOwnerDocument(true));
            }
            return newText;
        }
        catch (CoreModelException ex) {
            throw DOMExceptionUtil.toUncheckedException(ex);
        }
    }

    public String toString() {
        String value2 = this.getData();
        return value2 != null ? value2 : "";
    }
}

