/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.mime;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;

final class DebugInputStream
extends InputStream {
    private final InputStream parent;
    private final Log log;
    private long read;
    private int chunks;
    private boolean logged;

    DebugInputStream(InputStream parent, Log log) {
        this.parent = parent;
        this.log = log;
    }

    private void log(IOException ex) {
        if (!this.logged) {
            this.log.debug("IOException occurred after reading " + this.read + " bytes in " + this.chunks + " chunks", ex);
            this.logged = true;
        }
    }

    private void logEOF() {
        if (!this.logged) {
            this.log.debug("EOF reached after reading " + this.read + " bytes in " + this.chunks + " chunks");
            this.logged = true;
        }
    }

    @Override
    public int available() throws IOException {
        try {
            return this.parent.available();
        }
        catch (IOException ex) {
            this.log(ex);
            throw ex;
        }
    }

    @Override
    public boolean markSupported() {
        return this.parent.markSupported();
    }

    @Override
    public void mark(int readlimit) {
        this.parent.mark(readlimit);
    }

    @Override
    public void reset() throws IOException {
        try {
            this.parent.reset();
        }
        catch (IOException ex) {
            this.log(ex);
            throw ex;
        }
    }

    @Override
    public int read() throws IOException {
        int result;
        try {
            result = this.parent.read();
        }
        catch (IOException ex) {
            this.log(ex);
            throw ex;
        }
        if (result == -1) {
            this.logEOF();
        } else {
            ++this.read;
            ++this.chunks;
        }
        return result;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int c;
        try {
            c = this.parent.read(b, off, len);
        }
        catch (IOException ex) {
            this.log(ex);
            throw ex;
        }
        if (c == -1) {
            this.logEOF();
        } else {
            this.read += (long)c;
            ++this.chunks;
        }
        return c;
    }

    @Override
    public long skip(long n) throws IOException {
        try {
            return this.parent.skip(n);
        }
        catch (IOException ex) {
            this.log(ex);
            throw ex;
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.logged) {
            this.log.debug("Closing stream after reading " + this.read + " bytes in " + this.chunks + " chunks");
            this.logged = true;
        }
        this.parent.close();
    }
}

