/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.array;

import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BString;
import java.util.ArrayList;

public final class FromBase16 {
    private FromBase16() {
    }

    public static Object fromBase16(BString str) {
        if (str.length() % 2 != 0) {
            return ErrorCreator.createError(StringUtils.fromString("Invalid base16 string"), StringUtils.fromString("Expected an even length string, but the length of the string was: " + str.length()));
        }
        char[] chars = str.getValue().toCharArray();
        byte[] bytes = new byte[chars.length / 2];
        ArrayList<Character> invalidChars = new ArrayList<Character>();
        int i = 0;
        int j = 0;
        while (i < chars.length) {
            int upperHalf = Character.digit(chars[i], 16);
            int lowerHalf = Character.digit(chars[i + 1], 16);
            if (upperHalf < 0) {
                invalidChars.add(Character.valueOf(chars[i]));
            }
            if (lowerHalf < 0) {
                invalidChars.add(Character.valueOf(chars[i]));
            }
            bytes[j] = (byte)(upperHalf << 4 | lowerHalf);
            i += 2;
            ++j;
        }
        if (!invalidChars.isEmpty()) {
            return ErrorCreator.createError(StringUtils.fromString("Invalid base16 string"), StringUtils.fromString("Invalid character(s): " + ((Object)invalidChars).toString()));
        }
        return ValueCreator.createArrayValue(bytes);
    }
}

