/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.array;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BFunctionPointer;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.internal.errors.ErrorReasons;
import io.ballerina.runtime.internal.utils.ValueComparisonUtils;
import org.ballerinalang.langlib.array.utils.ArrayUtils;

public final class Sort {
    private Sort() {
    }

    public static BArray sort(Environment env, BArray arr, Object direction, Object func) {
        ArrayUtils.checkIsArrayOnlyOperation(TypeUtils.getImpliedType(arr.getType()), "sort()");
        BFunctionPointer function2 = (BFunctionPointer)func;
        Object[][] sortArr = new Object[arr.size()][2];
        Object[][] sortArrClone = new Object[arr.size()][2];
        if (function2 != null) {
            for (i = 0; i < arr.size(); ++i) {
                sortArr[i][0] = function2.call(env.getRuntime(), arr.get(i));
                sortArr[i][1] = arr.get(i);
            }
        } else {
            for (i = 0; i < arr.size(); ++i) {
                Object object = arr.get(i);
                sortArr[i][1] = object;
                sortArr[i][0] = object;
            }
        }
        Sort.mergesort(sortArr, sortArrClone, 0, sortArr.length - 1, direction.toString());
        BArray sortedArray = ValueCreator.createArrayValue(TypeCreator.createArrayType(arr.getElementType()));
        for (int k = 0; k < sortArr.length; ++k) {
            sortedArray.add((long)k, sortArr[k][1]);
        }
        return sortedArray;
    }

    private static void mergesort(Object[][] input, Object[][] aux, int lo, int hi, String direction) {
        if (hi <= lo) {
            return;
        }
        int mid = lo + (hi - lo) / 2;
        Sort.mergesort(input, aux, lo, mid, direction);
        Sort.mergesort(input, aux, mid + 1, hi, direction);
        Sort.merge(input, aux, lo, mid, hi, direction);
    }

    private static void merge(Object[][] input, Object[][] aux, int lo, int mid, int hi, String direction) {
        if (hi + 1 - lo >= 0) {
            System.arraycopy(input, lo, aux, lo, hi + 1 - lo);
        }
        int i = lo;
        int j = mid + 1;
        for (int k = lo; k <= hi; ++k) {
            try {
                int index = i > mid ? j++ : (j > hi ? i++ : (direction.equals("ascending") && ValueComparisonUtils.compareValues(aux[j][0], aux[i][0], direction) < 0 ? j++ : (direction.equals("descending") && ValueComparisonUtils.compareValues(aux[i][0], aux[j][0], direction) < 0 ? j++ : i++)));
                input[k] = aux[index];
                continue;
            }
            catch (BError error2) {
                throw ErrorCreator.createError(ErrorReasons.getModulePrefixedReason("lang.array", "SortOperationError"), (BMap)error2.getDetails());
            }
        }
    }
}

