/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.array.utils;

import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.TupleType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.UnionType;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.internal.errors.ErrorCodes;
import io.ballerina.runtime.internal.errors.ErrorHelper;
import io.ballerina.runtime.internal.errors.ErrorReasons;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.ballerinalang.langlib.array.utils.GetFunction;

public final class ArrayUtils {
    @Deprecated
    public static void add(BArray arr, int elemTypeTag, long index, Object value2) {
        switch (elemTypeTag) {
            case 1: {
                arr.add(index, (Long)value2);
                break;
            }
            case 6: {
                arr.add(index, (Boolean)value2);
                break;
            }
            case 2: {
                arr.add(index, ((Integer)value2).byteValue());
                break;
            }
            case 3: {
                arr.add(index, (Double)value2);
                break;
            }
            case 5: {
                arr.add(index, (String)value2);
                break;
            }
            default: {
                arr.add(index, value2);
            }
        }
    }

    public static GetFunction getElementAccessFunction(Type arrType, String funcName) {
        return switch (TypeUtils.getImpliedType(arrType).getTag()) {
            case 32 -> BArray::get;
            case 44 -> BArray::getRefValue;
            default -> throw ArrayUtils.createOpNotSupportedError(arrType, funcName);
        };
    }

    public static void checkIsArrayOnlyOperation(Type arrType, String op) {
        if (TypeUtils.getImpliedType(arrType).getTag() != 32) {
            throw ArrayUtils.createOpNotSupportedError(arrType, op);
        }
    }

    public static void checkIsClosedArray(ArrayType arrType, String op) {
        if (arrType.getState() == ArrayType.ArrayState.CLOSED) {
            throw ArrayUtils.createOpNotSupportedError(arrType, op);
        }
    }

    public static BError createOpNotSupportedError(Type type, String op) {
        return ErrorCreator.createError(ErrorReasons.getModulePrefixedReason("lang.array", "OperationNotSupported"), ErrorHelper.getErrorDetails(ErrorCodes.OPERATION_NOT_SUPPORTED_ERROR, op, type));
    }

    public static BArray createEmptyArrayFromTuple(BArray arr) {
        Type arrType = TypeUtils.getImpliedType(arr.getType());
        TupleType tupleType = (TupleType)arrType;
        List<Type> tupleTypes = tupleType.getTupleTypes();
        Type restType = tupleType.getRestType();
        HashSet<Type> uniqueTypes = new HashSet<Type>(tupleTypes);
        if (restType != null) {
            uniqueTypes.add(restType);
        }
        if (uniqueTypes.isEmpty()) {
            return ValueCreator.createArrayValue(TypeCreator.createArrayType(PredefinedTypes.TYPE_NEVER));
        }
        if (uniqueTypes.size() == 1) {
            Type type = (Type)uniqueTypes.iterator().next();
            ArrayType arrayType = TypeCreator.createArrayType(type);
            return ValueCreator.createArrayValue(arrayType);
        }
        UnionType unionType = TypeCreator.createUnionType(new ArrayList<Type>(uniqueTypes));
        ArrayType slicedArrType = TypeCreator.createArrayType(unionType);
        return ValueCreator.createArrayValue(slicedArrType);
    }

    private ArrayUtils() {
    }
}

