/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.decimal;

import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.values.BDecimal;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;

public class Round {
    private Round() {
    }

    public static BDecimal round(BDecimal x, long fractionDigits) {
        BigDecimal value2 = x.value();
        int scale = value2.scale();
        if (fractionDigits > 0L) {
            if (fractionDigits >= (long)scale) {
                return x;
            }
        } else if (fractionDigits < 0L) {
            int precision = value2.precision();
            if (Math.abs(fractionDigits) > (long)(precision - scale)) {
                BigDecimal scaledDecimal = new BigDecimal(0, MathContext.DECIMAL128);
                return ValueCreator.createDecimalValue(scaledDecimal);
            }
        }
        int toIntExact = Math.toIntExact(fractionDigits);
        BigDecimal scaledDecimal = value2.setScale(toIntExact, RoundingMode.HALF_EVEN);
        return ValueCreator.createDecimalValue(scaledDecimal);
    }
}

